/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils.easypermissions;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import com.hippo.utils.easypermissions.AfterPermissionGranted;
import com.hippo.utils.easypermissions.PermissionRequest;
import com.hippo.utils.easypermissions.helper.PermissionHelper;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class EasyPermissions {
    private static final String TAG = "EasyPermissions";

    public static boolean hasPermissions(@NonNull Context context, String ... stringArray) {
        if (Build.VERSION.SDK_INT < 23) {
            Log.w((String)TAG, (String)"hasPermissions: API version < M, returning true by default");
            return true;
        }
        if (context == null) {
            throw new IllegalArgumentException("Can't check permissions for null context");
        }
        for (String string2 : stringArray) {
            if (ContextCompat.checkSelfPermission((Context)context, (String)string2) == 0) continue;
            return false;
        }
        return true;
    }

    public static void requestPermissions(@NonNull Activity activity, @NonNull String string2, int n, String ... stringArray) {
        EasyPermissions.requestPermissions(new PermissionRequest.Builder(activity, n, stringArray).setRationale(string2).build());
    }

    public static void requestPermissions(@NonNull Fragment fragment, @NonNull String string2, int n, String ... stringArray) {
        EasyPermissions.requestPermissions(new PermissionRequest.Builder(fragment, n, stringArray).setRationale(string2).build());
    }

    public static void requestPermissions(PermissionRequest permissionRequest) {
        if (EasyPermissions.hasPermissions(permissionRequest.getHelper().getContext(), permissionRequest.getPerms())) {
            EasyPermissions.notifyAlreadyHasPermissions(permissionRequest.getHelper().getHost(), permissionRequest.getRequestCode(), permissionRequest.getPerms());
            return;
        }
        permissionRequest.getHelper().requestPermissions(permissionRequest.getRationale(), permissionRequest.getPositiveButtonText(), permissionRequest.getNegativeButtonText(), permissionRequest.getTheme(), permissionRequest.getRequestCode(), permissionRequest.getPerms());
    }

    public static void onRequestPermissionsResult(int n, @NonNull String[] stringArray, @NonNull int[] nArray, Object ... objectArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (int j = 0; j < stringArray.length; ++j) {
            String string2 = stringArray[j];
            if (nArray[j] == 0) {
                arrayList.add(string2);
                continue;
            }
            arrayList2.add(string2);
        }
        for (Object object : objectArray) {
            if (!arrayList.isEmpty() && object instanceof PermissionCallbacks) {
                ((PermissionCallbacks)object).onPermissionsGranted(n, arrayList);
            }
            if (!arrayList2.isEmpty() && object instanceof PermissionCallbacks) {
                ((PermissionCallbacks)object).onPermissionsDenied(n, arrayList2);
            }
            if (arrayList.isEmpty() || !arrayList2.isEmpty()) continue;
            EasyPermissions.runAnnotatedMethods(object, n);
        }
    }

    public static boolean somePermissionPermanentlyDenied(@NonNull Activity activity, @NonNull List<String> list) {
        return PermissionHelper.newInstance(activity).somePermissionPermanentlyDenied(list);
    }

    public static boolean somePermissionPermanentlyDenied(@NonNull Fragment fragment, @NonNull List<String> list) {
        return PermissionHelper.newInstance(fragment).somePermissionPermanentlyDenied(list);
    }

    public static boolean permissionPermanentlyDenied(@NonNull Activity activity, @NonNull String string2) {
        return PermissionHelper.newInstance(activity).permissionPermanentlyDenied(string2);
    }

    public static boolean permissionPermanentlyDenied(@NonNull Fragment fragment, @NonNull String string2) {
        return PermissionHelper.newInstance(fragment).permissionPermanentlyDenied(string2);
    }

    public static boolean somePermissionDenied(@NonNull Activity activity, String ... stringArray) {
        return PermissionHelper.newInstance(activity).somePermissionDenied(stringArray);
    }

    public static boolean somePermissionDenied(@NonNull Fragment fragment, String ... stringArray) {
        return PermissionHelper.newInstance(fragment).somePermissionDenied(stringArray);
    }

    private static void notifyAlreadyHasPermissions(@NonNull Object object, int n, @NonNull String[] stringArray) {
        int[] nArray = new int[stringArray.length];
        for (int j = 0; j < stringArray.length; ++j) {
            nArray[j] = 0;
        }
        EasyPermissions.onRequestPermissionsResult(n, stringArray, nArray, object);
    }

    private static void runAnnotatedMethods(@NonNull Object object, int n) {
        Class<?> clazz = object.getClass();
        if (EasyPermissions.isUsingAndroidAnnotations(object)) {
            clazz = clazz.getSuperclass();
        }
        while (clazz != null) {
            for (Method method : clazz.getDeclaredMethods()) {
                AfterPermissionGranted afterPermissionGranted = method.getAnnotation(AfterPermissionGranted.class);
                if (afterPermissionGranted == null || afterPermissionGranted.value() != n) continue;
                if (method.getParameterTypes().length > 0) {
                    throw new RuntimeException("Cannot execute method " + method.getName() + " because it is non-void method and/or has input parameters.");
                }
                try {
                    if (!method.isAccessible()) {
                        method.setAccessible(true);
                    }
                    method.invoke(object, new Object[0]);
                }
                catch (IllegalAccessException illegalAccessException) {
                    Log.e((String)TAG, (String)"runDefaultMethod:IllegalAccessException", (Throwable)illegalAccessException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    Log.e((String)TAG, (String)"runDefaultMethod:InvocationTargetException", (Throwable)invocationTargetException);
                }
            }
            clazz = clazz.getSuperclass();
        }
    }

    private static boolean isUsingAndroidAnnotations(@NonNull Object object) {
        if (!object.getClass().getSimpleName().endsWith("_")) {
            return false;
        }
        try {
            Class<?> clazz = Class.forName("org.androidannotations.api.view.HasViews");
            return clazz.isInstance(object);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public static interface RationaleCallbacks {
        public void onRationaleAccepted(int var1);

        public void onRationaleDenied(int var1);
    }

    public static interface PermissionCallbacks
    extends ActivityCompat.OnRequestPermissionsResultCallback {
        public void onPermissionsGranted(int var1, @NonNull List<String> var2);

        public void onPermissionsDenied(int var1, @NonNull List<String> var2);
    }
}

