/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils.easypermissions;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.StringRes;
import androidx.annotation.StyleRes;
import androidx.appcompat.app.AlertDialog;
import androidx.fragment.app.Fragment;
import com.hippo.R;
import com.hippo.utils.easypermissions.AppSettingsDialogHolderActivity;

public class AppSettingsDialog
implements Parcelable {
    public static final int DEFAULT_SETTINGS_REQ_CODE = 16061;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final Parcelable.Creator<AppSettingsDialog> CREATOR = new Parcelable.Creator<AppSettingsDialog>(){

        public AppSettingsDialog createFromParcel(Parcel parcel) {
            return new AppSettingsDialog(parcel);
        }

        public AppSettingsDialog[] newArray(int n) {
            return new AppSettingsDialog[n];
        }
    };
    static final String EXTRA_APP_SETTINGS = "extra_app_settings";
    @StyleRes
    private final int mThemeResId;
    private final String mRationale;
    private final String mTitle;
    private final String mPositiveButtonText;
    private final String mNegativeButtonText;
    private final int mRequestCode;
    private final int mIntentFlags;
    private Object mActivityOrFragment;
    private Context mContext;

    private AppSettingsDialog(Parcel parcel) {
        this.mThemeResId = parcel.readInt();
        this.mRationale = parcel.readString();
        this.mTitle = parcel.readString();
        this.mPositiveButtonText = parcel.readString();
        this.mNegativeButtonText = parcel.readString();
        this.mRequestCode = parcel.readInt();
        this.mIntentFlags = parcel.readInt();
    }

    private AppSettingsDialog(@NonNull Object object, @StyleRes int n, @Nullable String string2, @Nullable String string3, @Nullable String string4, @Nullable String string5, int n2, int n3) {
        this.setActivityOrFragment(object);
        this.mThemeResId = n;
        this.mRationale = string2;
        this.mTitle = string3;
        this.mPositiveButtonText = string4;
        this.mNegativeButtonText = string5;
        this.mRequestCode = n2;
        this.mIntentFlags = n3;
    }

    static AppSettingsDialog fromIntent(Intent intent, Activity activity) {
        AppSettingsDialog appSettingsDialog = (AppSettingsDialog)intent.getParcelableExtra(EXTRA_APP_SETTINGS);
        appSettingsDialog.setActivityOrFragment(activity);
        return appSettingsDialog;
    }

    private void setActivityOrFragment(Object object) {
        this.mActivityOrFragment = object;
        if (object instanceof Activity) {
            this.mContext = (Activity)object;
        } else if (object instanceof Fragment) {
            this.mContext = ((Fragment)object).getContext();
        } else {
            throw new IllegalStateException("Unknown object: " + object);
        }
    }

    private void startForResult(Intent intent) {
        if (this.mActivityOrFragment instanceof Activity) {
            ((Activity)this.mActivityOrFragment).startActivityForResult(intent, this.mRequestCode);
        } else if (this.mActivityOrFragment instanceof Fragment) {
            ((Fragment)this.mActivityOrFragment).startActivityForResult(intent, this.mRequestCode);
        }
    }

    public void show() {
        this.startForResult(AppSettingsDialogHolderActivity.createShowDialogIntent(this.mContext, this));
    }

    AlertDialog showDialog(DialogInterface.OnClickListener onClickListener, DialogInterface.OnClickListener onClickListener2) {
        AlertDialog.Builder builder = this.mThemeResId > 0 ? new AlertDialog.Builder(this.mContext, this.mThemeResId) : new AlertDialog.Builder(this.mContext);
        return builder.setCancelable(false).setTitle((CharSequence)this.mTitle).setMessage((CharSequence)this.mRationale).setPositiveButton((CharSequence)this.mPositiveButtonText, onClickListener).setNegativeButton((CharSequence)this.mNegativeButtonText, onClickListener2).show();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NonNull Parcel parcel, int n) {
        parcel.writeInt(this.mThemeResId);
        parcel.writeString(this.mRationale);
        parcel.writeString(this.mTitle);
        parcel.writeString(this.mPositiveButtonText);
        parcel.writeString(this.mNegativeButtonText);
        parcel.writeInt(this.mRequestCode);
        parcel.writeInt(this.mIntentFlags);
    }

    int getIntentFlags() {
        return this.mIntentFlags;
    }

    public static class Builder {
        private final Object mActivityOrFragment;
        private final Context mContext;
        @StyleRes
        private int mThemeResId = -1;
        private String mRationale;
        private String mTitle;
        private String mPositiveButtonText;
        private String mNegativeButtonText;
        private int mRequestCode = -1;
        private boolean mOpenInNewTask = false;

        public Builder(@NonNull Activity activity) {
            this.mActivityOrFragment = activity;
            this.mContext = activity;
        }

        public Builder(@NonNull Fragment fragment) {
            this.mActivityOrFragment = fragment;
            this.mContext = fragment.getContext();
        }

        @NonNull
        public Builder setThemeResId(@StyleRes int n) {
            this.mThemeResId = n;
            return this;
        }

        @NonNull
        public Builder setTitle(@Nullable String string2) {
            this.mTitle = string2;
            return this;
        }

        @NonNull
        public Builder setTitle(@StringRes int n) {
            this.mTitle = this.mContext.getString(n);
            return this;
        }

        @NonNull
        public Builder setRationale(@Nullable String string2) {
            this.mRationale = string2;
            return this;
        }

        @NonNull
        public Builder setRationale(@StringRes int n) {
            this.mRationale = this.mContext.getString(n);
            return this;
        }

        @NonNull
        public Builder setPositiveButton(@Nullable String string2) {
            this.mPositiveButtonText = string2;
            return this;
        }

        @NonNull
        public Builder setPositiveButton(@StringRes int n) {
            this.mPositiveButtonText = this.mContext.getString(n);
            return this;
        }

        @NonNull
        public Builder setNegativeButton(@Nullable String string2) {
            this.mNegativeButtonText = string2;
            return this;
        }

        @NonNull
        public Builder setNegativeButton(@StringRes int n) {
            this.mNegativeButtonText = this.mContext.getString(n);
            return this;
        }

        @NonNull
        public Builder setRequestCode(int n) {
            this.mRequestCode = n;
            return this;
        }

        @NonNull
        public Builder setOpenInNewTask(boolean bl) {
            this.mOpenInNewTask = bl;
            return this;
        }

        @NonNull
        public AppSettingsDialog build() {
            this.mRationale = TextUtils.isEmpty((CharSequence)this.mRationale) ? this.mContext.getString(R.string.hippo_rationale_ask_again) : this.mRationale;
            this.mTitle = TextUtils.isEmpty((CharSequence)this.mTitle) ? this.mContext.getString(R.string.title_settings_dialog) : this.mTitle;
            this.mPositiveButtonText = TextUtils.isEmpty((CharSequence)this.mPositiveButtonText) ? this.mContext.getString(17039370) : this.mPositiveButtonText;
            this.mNegativeButtonText = TextUtils.isEmpty((CharSequence)this.mNegativeButtonText) ? this.mContext.getString(0x1040000) : this.mNegativeButtonText;
            this.mRequestCode = this.mRequestCode > 0 ? this.mRequestCode : 16061;
            int n = 0;
            if (this.mOpenInNewTask) {
                n |= 0x10000000;
            }
            return new AppSettingsDialog(this.mActivityOrFragment, this.mThemeResId, this.mRationale, this.mTitle, this.mPositiveButtonText, this.mNegativeButtonText, this.mRequestCode, n);
        }
    }
}

