/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils.countrypicker;

import android.content.Context;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.EditText;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.DialogFragment;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.hippo.R;
import com.hippo.utils.countrypicker.CountriesAdapter;
import com.hippo.utils.countrypicker.Country;
import com.hippo.utils.countrypicker.OnCountryPickerListener;
import com.hippo.utils.countrypicker.OnItemClickListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class CountryPickerDialog
extends DialogFragment
implements OnItemClickListener {
    private CountryPickerDialogInteractionListener dialogInteractionListener;
    private EditText searchEditText;
    private RecyclerView countriesRecyclerView;
    private CountriesAdapter adapter;
    private List<Country> searchResults;
    private OnCountryPickerListener listener;

    public static CountryPickerDialog newInstance() {
        return new CountryPickerDialog();
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater layoutInflater, @Nullable ViewGroup viewGroup, Bundle bundle) {
        View view = layoutInflater.inflate(R.layout.hippo_country_picker, null);
        this.getDialog().setTitle(R.string.hippo_country_picker_header);
        this.searchEditText = (EditText)view.findViewById(R.id.country_code_picker_search);
        this.countriesRecyclerView = (RecyclerView)view.findViewById(R.id.countries_recycler_view);
        this.setupRecyclerView();
        if (!this.dialogInteractionListener.canSearch()) {
            this.searchEditText.setVisibility(8);
        } else {
            this.searchEditText.setVisibility(0);
        }
        this.searchEditText.addTextChangedListener(new TextWatcher(){

            public void onTextChanged(CharSequence charSequence, int n, int n2, int n3) {
            }

            public void beforeTextChanged(CharSequence charSequence, int n, int n2, int n3) {
            }

            public void afterTextChanged(Editable editable) {
                CountryPickerDialog.this.search(editable.toString());
            }
        });
        return view;
    }

    public void onStart() {
        super.onStart();
        WindowManager.LayoutParams layoutParams = this.getDialog().getWindow().getAttributes();
        layoutParams.width = -1;
        layoutParams.height = -1;
        this.getDialog().getWindow().setAttributes(layoutParams);
    }

    @Override
    public void onItemClicked(Country country) {
        if (this.listener != null) {
            this.listener.onSelectCountry(country);
        }
        this.dismiss();
    }

    public void setCountryPickerListener(OnCountryPickerListener onCountryPickerListener) {
        this.listener = onCountryPickerListener;
    }

    public void setDialogInteractionListener(CountryPickerDialogInteractionListener countryPickerDialogInteractionListener) {
        this.dialogInteractionListener = countryPickerDialogInteractionListener;
    }

    private void search(String string2) {
        this.searchResults.clear();
        for (Country country : this.dialogInteractionListener.getAllCountries()) {
            if (!country.getName().toLowerCase(Locale.ENGLISH).contains(string2.toLowerCase())) continue;
            this.searchResults.add(country);
        }
        this.dialogInteractionListener.sortCountries(this.searchResults);
        this.adapter.notifyDataSetChanged();
    }

    private void setupRecyclerView() {
        this.searchResults = new ArrayList<Country>();
        this.searchResults.addAll(this.dialogInteractionListener.getAllCountries());
        this.adapter = new CountriesAdapter((Context)this.getActivity(), this.searchResults, this);
        this.countriesRecyclerView.setHasFixedSize(true);
        LinearLayoutManager linearLayoutManager = new LinearLayoutManager(this.getContext());
        linearLayoutManager.setOrientation(1);
        this.countriesRecyclerView.setLayoutManager((RecyclerView.LayoutManager)linearLayoutManager);
        this.countriesRecyclerView.setAdapter((RecyclerView.Adapter)this.adapter);
    }

    public static interface CountryPickerDialogInteractionListener {
        public List<Country> getAllCountries();

        public void sortCountries(List<Country> var1);

        public boolean canSearch();
    }
}

