/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils;

import android.content.Context;
import android.media.AudioManager;
import android.os.SystemClock;
import android.util.Patterns;
import java.util.regex.Pattern;

public class Utils {
    private static final int MULTIPLE_CLICK_THRESHOLD = 2500;
    private static long mLastClickTime = 0L;

    public static boolean isNumeric(String string2) {
        if (string2 == null) {
            return false;
        }
        return Pattern.matches("-?\\d+(\\.\\d+)?", string2);
    }

    public static boolean isEmailValid(String string2) {
        if (string2 == null) {
            return false;
        }
        return Patterns.EMAIL_ADDRESS.matcher(string2).matches();
    }

    public static final boolean isValidPhoneNumber(CharSequence charSequence) {
        if (charSequence == null) {
            return false;
        }
        if (charSequence.length() < 6 || charSequence.length() > 17) {
            return false;
        }
        return Patterns.PHONE.matcher(charSequence).matches();
    }

    public static boolean preventMultipleClicks() {
        if (SystemClock.elapsedRealtime() - mLastClickTime < 2500L) {
            return false;
        }
        mLastClickTime = SystemClock.elapsedRealtime();
        return true;
    }

    public static AudioManager getAudioManager(Context context) {
        return (AudioManager)context.getSystemService("audio");
    }
}

