/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.OvalShape;
import android.graphics.drawable.shapes.RectShape;
import android.graphics.drawable.shapes.RoundRectShape;
import android.graphics.drawable.shapes.Shape;

public class TextDrawable
extends ShapeDrawable {
    private final Paint textPaint;
    private final Paint borderPaint;
    private static final float SHADE_FACTOR = 0.9f;
    private final String text;
    private final int color;
    private final RectShape shape;
    private final int height;
    private final int width;
    private final int fontSize;
    private final float radius;
    private final int borderThickness;

    private TextDrawable(Builder builder) {
        super((Shape)builder.shape);
        this.shape = builder.shape;
        this.height = builder.height;
        this.width = builder.width;
        this.radius = builder.radius;
        this.text = builder.toUpperCase ? builder.text.toUpperCase() : builder.text;
        this.color = builder.color;
        this.fontSize = builder.fontSize;
        this.textPaint = new Paint();
        this.textPaint.setColor(builder.textColor);
        this.textPaint.setAntiAlias(true);
        this.textPaint.setFakeBoldText(builder.isBold);
        this.textPaint.setStyle(Paint.Style.FILL);
        this.textPaint.setTypeface(builder.font);
        this.textPaint.setTextAlign(Paint.Align.CENTER);
        this.textPaint.setStrokeWidth((float)builder.borderThickness);
        this.borderThickness = builder.borderThickness;
        this.borderPaint = new Paint();
        this.borderPaint.setColor(this.getDarkerShade(this.color));
        this.borderPaint.setStyle(Paint.Style.STROKE);
        this.borderPaint.setStrokeWidth((float)this.borderThickness);
        Paint paint = this.getPaint();
        paint.setColor(this.color);
    }

    private int getDarkerShade(int n) {
        return Color.rgb((int)((int)(0.9f * (float)Color.red((int)n))), (int)((int)(0.9f * (float)Color.green((int)n))), (int)((int)(0.9f * (float)Color.blue((int)n))));
    }

    public void draw(Canvas canvas) {
        super.draw(canvas);
        Rect rect = this.getBounds();
        if (this.borderThickness > 0) {
            this.drawBorder(canvas);
        }
        int n = canvas.save();
        canvas.translate((float)rect.left, (float)rect.top);
        int n2 = this.width < 0 ? rect.width() : this.width;
        int n3 = this.height < 0 ? rect.height() : this.height;
        int n4 = this.fontSize < 0 ? Math.min(n2, n3) / 2 : this.fontSize;
        this.textPaint.setTextSize((float)n4);
        canvas.drawText(this.text, (float)(n2 / 2), (float)(n3 / 2) - (this.textPaint.descent() + this.textPaint.ascent()) / 2.0f, this.textPaint);
        canvas.restoreToCount(n);
    }

    private void drawBorder(Canvas canvas) {
        RectF rectF = new RectF(this.getBounds());
        rectF.inset((float)(this.borderThickness / 2), (float)(this.borderThickness / 2));
        if (this.shape instanceof OvalShape) {
            canvas.drawOval(rectF, this.borderPaint);
        } else if (this.shape instanceof RoundRectShape) {
            canvas.drawRoundRect(rectF, this.radius, this.radius, this.borderPaint);
        } else {
            canvas.drawRect(rectF, this.borderPaint);
        }
    }

    public void setAlpha(int n) {
        this.textPaint.setAlpha(n);
    }

    public void setColorFilter(ColorFilter colorFilter) {
        this.textPaint.setColorFilter(colorFilter);
    }

    public int getOpacity() {
        return -3;
    }

    public int getIntrinsicWidth() {
        return this.width;
    }

    public int getIntrinsicHeight() {
        return this.height;
    }

    public static IShapeBuilder builder() {
        return new Builder();
    }

    public static interface IShapeBuilder {
        public IConfigBuilder beginConfig();

        public IBuilder rect();

        public IBuilder round();

        public IBuilder roundRect(int var1);

        public TextDrawable buildRect(String var1, int var2);

        public TextDrawable buildRoundRect(String var1, int var2, int var3);

        public TextDrawable buildRound(String var1, int var2);
    }

    public static interface IBuilder {
        public TextDrawable build(String var1, int var2);
    }

    public static interface IConfigBuilder {
        public IConfigBuilder width(int var1);

        public IConfigBuilder height(int var1);

        public IConfigBuilder textColor(int var1);

        public IConfigBuilder withBorder(int var1);

        public IConfigBuilder useFont(Typeface var1);

        public IConfigBuilder fontSize(int var1);

        public IConfigBuilder bold();

        public IConfigBuilder toUpperCase();

        public IShapeBuilder endConfig();
    }

    public static class Builder
    implements IBuilder,
    IConfigBuilder,
    IShapeBuilder {
        private String text = "";
        private int color = -7829368;
        private int borderThickness = 0;
        private int width = -1;
        private int height = -1;
        private Typeface font;
        private RectShape shape = new RectShape();
        public int textColor = -1;
        private int fontSize = -1;
        private boolean isBold = false;
        private boolean toUpperCase = false;
        public float radius;

        private Builder() {
            this.font = Typeface.create((String)"sans-serif-light", (int)1);
        }

        @Override
        public IConfigBuilder width(int n) {
            this.width = n;
            return this;
        }

        @Override
        public IConfigBuilder height(int n) {
            this.height = n;
            return this;
        }

        @Override
        public IConfigBuilder textColor(int n) {
            this.textColor = n;
            return this;
        }

        @Override
        public IConfigBuilder withBorder(int n) {
            this.borderThickness = n;
            return this;
        }

        @Override
        public IConfigBuilder useFont(Typeface typeface) {
            this.font = typeface;
            return this;
        }

        @Override
        public IConfigBuilder fontSize(int n) {
            this.fontSize = n;
            return this;
        }

        @Override
        public IConfigBuilder bold() {
            this.isBold = true;
            return this;
        }

        @Override
        public IConfigBuilder toUpperCase() {
            this.toUpperCase = true;
            return this;
        }

        @Override
        public IConfigBuilder beginConfig() {
            return this;
        }

        @Override
        public IShapeBuilder endConfig() {
            return this;
        }

        @Override
        public IBuilder rect() {
            this.shape = new RectShape();
            return this;
        }

        @Override
        public IBuilder round() {
            this.shape = new OvalShape();
            return this;
        }

        @Override
        public IBuilder roundRect(int n) {
            this.radius = n;
            float[] fArray = new float[]{n, n, n, n, n, n, n, n};
            this.shape = new RoundRectShape(fArray, null, null);
            return this;
        }

        @Override
        public TextDrawable buildRect(String string2, int n) {
            this.rect();
            return this.build(string2, n);
        }

        @Override
        public TextDrawable buildRoundRect(String string2, int n, int n2) {
            this.roundRect(n2);
            return this.build(string2, n);
        }

        @Override
        public TextDrawable buildRound(String string2, int n) {
            this.round();
            return this.build(string2, n);
        }

        @Override
        public TextDrawable build(String string2, int n) {
            this.color = n;
            this.text = string2;
            return new TextDrawable(this);
        }
    }
}

