/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.net.Uri;
import android.util.AttributeSet;
import android.util.Log;
import android.widget.ImageView;
import com.hippo.R;

public class SelectableRoundedImageView
extends ImageView {
    public static final String TAG = "SelectableRoundedImageView";
    private int mResource = 0;
    private static final ImageView.ScaleType[] sScaleTypeArray = new ImageView.ScaleType[]{ImageView.ScaleType.MATRIX, ImageView.ScaleType.FIT_XY, ImageView.ScaleType.FIT_START, ImageView.ScaleType.FIT_CENTER, ImageView.ScaleType.FIT_END, ImageView.ScaleType.CENTER, ImageView.ScaleType.CENTER_CROP, ImageView.ScaleType.CENTER_INSIDE};
    private ImageView.ScaleType mScaleType = ImageView.ScaleType.FIT_CENTER;
    private float mLeftTopCornerRadius = 0.0f;
    private float mRightTopCornerRadius = 0.0f;
    private float mLeftBottomCornerRadius = 0.0f;
    private float mRightBottomCornerRadius = 0.0f;
    private float mBorderWidth = 0.0f;
    private static final int DEFAULT_BORDER_COLOR = -16777216;
    private ColorStateList mBorderColor = ColorStateList.valueOf((int)-16777216);
    private boolean isOval = false;
    private Drawable mDrawable;
    private float[] mRadii = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};

    public SelectableRoundedImageView(Context context) {
        super(context);
    }

    public SelectableRoundedImageView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public SelectableRoundedImageView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.SelectableRoundedImageView, n, 0);
        int n2 = typedArray.getInt(R.styleable.SelectableRoundedImageView_android_scaleType, -1);
        if (n2 >= 0) {
            this.setScaleType(sScaleTypeArray[n2]);
        }
        this.mLeftTopCornerRadius = typedArray.getDimensionPixelSize(R.styleable.SelectableRoundedImageView_sriv_left_top_corner_radius, 0);
        this.mRightTopCornerRadius = typedArray.getDimensionPixelSize(R.styleable.SelectableRoundedImageView_sriv_right_top_corner_radius, 0);
        this.mLeftBottomCornerRadius = typedArray.getDimensionPixelSize(R.styleable.SelectableRoundedImageView_sriv_left_bottom_corner_radius, 0);
        this.mRightBottomCornerRadius = typedArray.getDimensionPixelSize(R.styleable.SelectableRoundedImageView_sriv_right_bottom_corner_radius, 0);
        if (this.mLeftTopCornerRadius < 0.0f || this.mRightTopCornerRadius < 0.0f || this.mLeftBottomCornerRadius < 0.0f || this.mRightBottomCornerRadius < 0.0f) {
            throw new IllegalArgumentException("radius values cannot be negative.");
        }
        this.mRadii = new float[]{this.mLeftTopCornerRadius, this.mLeftTopCornerRadius, this.mRightTopCornerRadius, this.mRightTopCornerRadius, this.mRightBottomCornerRadius, this.mRightBottomCornerRadius, this.mLeftBottomCornerRadius, this.mLeftBottomCornerRadius};
        this.mBorderWidth = typedArray.getDimensionPixelSize(R.styleable.SelectableRoundedImageView_sriv_border_width, 0);
        if (this.mBorderWidth < 0.0f) {
            throw new IllegalArgumentException("border width cannot be negative.");
        }
        this.mBorderColor = typedArray.getColorStateList(R.styleable.SelectableRoundedImageView_sriv_border_color);
        if (this.mBorderColor == null) {
            this.mBorderColor = ColorStateList.valueOf((int)-16777216);
        }
        this.isOval = typedArray.getBoolean(R.styleable.SelectableRoundedImageView_sriv_oval, false);
        typedArray.recycle();
        this.updateDrawable();
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        this.invalidate();
    }

    public ImageView.ScaleType getScaleType() {
        return this.mScaleType;
    }

    public void setScaleType(ImageView.ScaleType scaleType) {
        super.setScaleType(scaleType);
        this.mScaleType = scaleType;
        this.updateDrawable();
    }

    public void setImageDrawable(Drawable drawable2) {
        this.mResource = 0;
        this.mDrawable = SelectableRoundedCornerDrawable.fromDrawable(drawable2, this.getResources());
        super.setImageDrawable(this.mDrawable);
        this.updateDrawable();
    }

    public void setImageBitmap(Bitmap bitmap) {
        this.mResource = 0;
        this.mDrawable = SelectableRoundedCornerDrawable.fromBitmap(bitmap, this.getResources());
        super.setImageDrawable(this.mDrawable);
        this.updateDrawable();
    }

    public void setImageResource(int n) {
        if (this.mResource != n) {
            this.mResource = n;
            this.mDrawable = this.resolveResource();
            super.setImageDrawable(this.mDrawable);
            this.updateDrawable();
        }
    }

    public void setImageURI(Uri uri) {
        super.setImageURI(uri);
        this.setImageDrawable(this.getDrawable());
    }

    private Drawable resolveResource() {
        Resources resources = this.getResources();
        if (resources == null) {
            return null;
        }
        Drawable drawable2 = null;
        if (this.mResource != 0) {
            try {
                drawable2 = resources.getDrawable(this.mResource);
            }
            catch (Resources.NotFoundException notFoundException) {
                Log.w((String)TAG, (String)("Unable to find resource: " + this.mResource), (Throwable)notFoundException);
                this.mResource = 0;
            }
        }
        return SelectableRoundedCornerDrawable.fromDrawable(drawable2, this.getResources());
    }

    private void updateDrawable() {
        if (this.mDrawable == null) {
            return;
        }
        ((SelectableRoundedCornerDrawable)this.mDrawable).setScaleType(this.mScaleType);
        ((SelectableRoundedCornerDrawable)this.mDrawable).setCornerRadii(this.mRadii);
        ((SelectableRoundedCornerDrawable)this.mDrawable).setBorderWidth(this.mBorderWidth);
        ((SelectableRoundedCornerDrawable)this.mDrawable).setBorderColor(this.mBorderColor);
        ((SelectableRoundedCornerDrawable)this.mDrawable).setOval(this.isOval);
    }

    public float getCornerRadius() {
        return this.mLeftTopCornerRadius;
    }

    public void setCornerRadiiDP(float f2, float f3, float f4, float f5) {
        float f6 = this.getResources().getDisplayMetrics().density;
        float f7 = f2 * f6;
        float f8 = f3 * f6;
        float f9 = f4 * f6;
        float f10 = f5 * f6;
        this.mRadii = new float[]{f7, f7, f8, f8, f10, f10, f9, f9};
        this.updateDrawable();
    }

    public float getBorderWidth() {
        return this.mBorderWidth;
    }

    public void setBorderWidthDP(float f2) {
        float f3 = this.getResources().getDisplayMetrics().density * f2;
        if (this.mBorderWidth == f3) {
            return;
        }
        this.mBorderWidth = f3;
        this.updateDrawable();
        this.invalidate();
    }

    public int getBorderColor() {
        return this.mBorderColor.getDefaultColor();
    }

    public void setBorderColor(int n) {
        this.setBorderColor(ColorStateList.valueOf((int)n));
    }

    public ColorStateList getBorderColors() {
        return this.mBorderColor;
    }

    public void setBorderColor(ColorStateList colorStateList) {
        if (this.mBorderColor.equals(colorStateList)) {
            return;
        }
        this.mBorderColor = colorStateList != null ? colorStateList : ColorStateList.valueOf((int)-16777216);
        this.updateDrawable();
        if (this.mBorderWidth > 0.0f) {
            this.invalidate();
        }
    }

    public boolean isOval() {
        return this.isOval;
    }

    public void setOval(boolean bl) {
        this.isOval = bl;
        this.updateDrawable();
        this.invalidate();
    }

    static class SelectableRoundedCornerDrawable
    extends Drawable {
        private static final String TAG = "SelectableRoundedCornerDrawable";
        private static final int DEFAULT_BORDER_COLOR = -16777216;
        private RectF mBounds = new RectF();
        private RectF mBorderBounds = new RectF();
        private final RectF mBitmapRect = new RectF();
        private final int mBitmapWidth;
        private final int mBitmapHeight;
        private final Paint mBitmapPaint;
        private final Paint mBorderPaint;
        private BitmapShader mBitmapShader;
        private float[] mRadii = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
        private float[] mBorderRadii = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
        private boolean mOval = false;
        private float mBorderWidth = 0.0f;
        private ColorStateList mBorderColor = ColorStateList.valueOf((int)-16777216);
        private ImageView.ScaleType mScaleType = ImageView.ScaleType.FIT_CENTER;
        private Path mPath = new Path();
        private Bitmap mBitmap;
        private boolean mBoundsConfigured = false;

        public SelectableRoundedCornerDrawable(Bitmap bitmap, Resources resources) {
            this.mBitmap = bitmap;
            this.mBitmapShader = new BitmapShader(bitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
            if (bitmap != null) {
                this.mBitmapWidth = bitmap.getScaledWidth(resources.getDisplayMetrics());
                this.mBitmapHeight = bitmap.getScaledHeight(resources.getDisplayMetrics());
            } else {
                this.mBitmapHeight = -1;
                this.mBitmapWidth = -1;
            }
            this.mBitmapRect.set(0.0f, 0.0f, (float)this.mBitmapWidth, (float)this.mBitmapHeight);
            this.mBitmapPaint = new Paint(1);
            this.mBitmapPaint.setStyle(Paint.Style.FILL);
            this.mBitmapPaint.setShader((Shader)this.mBitmapShader);
            this.mBorderPaint = new Paint(1);
            this.mBorderPaint.setStyle(Paint.Style.STROKE);
            this.mBorderPaint.setColor(this.mBorderColor.getColorForState(this.getState(), -16777216));
            this.mBorderPaint.setStrokeWidth(this.mBorderWidth);
        }

        public static SelectableRoundedCornerDrawable fromBitmap(Bitmap bitmap, Resources resources) {
            if (bitmap != null) {
                return new SelectableRoundedCornerDrawable(bitmap, resources);
            }
            return null;
        }

        public static Drawable fromDrawable(Drawable drawable2, Resources resources) {
            if (drawable2 != null) {
                if (drawable2 instanceof SelectableRoundedCornerDrawable) {
                    return drawable2;
                }
                if (drawable2 instanceof LayerDrawable) {
                    LayerDrawable layerDrawable = (LayerDrawable)drawable2;
                    int n = layerDrawable.getNumberOfLayers();
                    for (int j = 0; j < n; ++j) {
                        Drawable drawable3 = layerDrawable.getDrawable(j);
                        layerDrawable.setDrawableByLayerId(layerDrawable.getId(j), SelectableRoundedCornerDrawable.fromDrawable(drawable3, resources));
                    }
                    return layerDrawable;
                }
                Bitmap bitmap = SelectableRoundedCornerDrawable.drawableToBitmap(drawable2);
                if (bitmap != null) {
                    return new SelectableRoundedCornerDrawable(bitmap, resources);
                }
                Log.w((String)TAG, (String)"Failed to create bitmap from drawable!");
            }
            return drawable2;
        }

        public static Bitmap drawableToBitmap(Drawable drawable2) {
            Bitmap bitmap;
            if (drawable2 == null) {
                return null;
            }
            if (drawable2 instanceof BitmapDrawable) {
                return ((BitmapDrawable)drawable2).getBitmap();
            }
            int n = Math.max(drawable2.getIntrinsicWidth(), 2);
            int n2 = Math.max(drawable2.getIntrinsicHeight(), 2);
            try {
                bitmap = Bitmap.createBitmap((int)n, (int)n2, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                Canvas canvas = new Canvas(bitmap);
                drawable2.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
                drawable2.draw(canvas);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
                bitmap = null;
            }
            return bitmap;
        }

        public boolean isStateful() {
            return this.mBorderColor.isStateful();
        }

        protected boolean onStateChange(int[] nArray) {
            int n = this.mBorderColor.getColorForState(nArray, 0);
            if (this.mBorderPaint.getColor() != n) {
                this.mBorderPaint.setColor(n);
                return true;
            }
            return super.onStateChange(nArray);
        }

        private void configureBounds(Canvas canvas) {
            Rect rect = canvas.getClipBounds();
            Matrix matrix = canvas.getMatrix();
            if (ImageView.ScaleType.CENTER == this.mScaleType) {
                this.mBounds.set(rect);
            } else if (ImageView.ScaleType.CENTER_CROP == this.mScaleType) {
                this.applyScaleToRadii(matrix);
                this.mBounds.set(rect);
            } else if (ImageView.ScaleType.FIT_XY == this.mScaleType) {
                Matrix matrix2 = new Matrix();
                matrix2.setRectToRect(this.mBitmapRect, new RectF(rect), Matrix.ScaleToFit.FILL);
                this.mBitmapShader.setLocalMatrix(matrix2);
                this.mBounds.set(rect);
            } else if (ImageView.ScaleType.FIT_START == this.mScaleType || ImageView.ScaleType.FIT_END == this.mScaleType || ImageView.ScaleType.FIT_CENTER == this.mScaleType || ImageView.ScaleType.CENTER_INSIDE == this.mScaleType) {
                this.applyScaleToRadii(matrix);
                this.mBounds.set(this.mBitmapRect);
            } else if (ImageView.ScaleType.MATRIX == this.mScaleType) {
                this.applyScaleToRadii(matrix);
                this.mBounds.set(this.mBitmapRect);
            }
        }

        private void applyScaleToRadii(Matrix matrix) {
            float[] fArray = new float[9];
            matrix.getValues(fArray);
            for (int j = 0; j < this.mRadii.length; ++j) {
                this.mRadii[j] = this.mRadii[j] / fArray[0];
            }
        }

        private void adjustCanvasForBorder(Canvas canvas) {
            Matrix matrix = canvas.getMatrix();
            float[] fArray = new float[9];
            matrix.getValues(fArray);
            float f2 = fArray[0];
            float f3 = fArray[4];
            float f4 = fArray[2];
            float f5 = fArray[5];
            float f6 = this.mBounds.width() / (this.mBounds.width() + this.mBorderWidth + this.mBorderWidth);
            float f7 = this.mBounds.height() / (this.mBounds.height() + this.mBorderWidth + this.mBorderWidth);
            canvas.scale(f6, f7);
            if (ImageView.ScaleType.FIT_START == this.mScaleType || ImageView.ScaleType.FIT_END == this.mScaleType || ImageView.ScaleType.FIT_XY == this.mScaleType || ImageView.ScaleType.FIT_CENTER == this.mScaleType || ImageView.ScaleType.CENTER_INSIDE == this.mScaleType || ImageView.ScaleType.MATRIX == this.mScaleType) {
                canvas.translate(this.mBorderWidth, this.mBorderWidth);
            } else if (ImageView.ScaleType.CENTER == this.mScaleType || ImageView.ScaleType.CENTER_CROP == this.mScaleType) {
                canvas.translate(-f4 / (f6 * f2), -f5 / (f7 * f3));
                canvas.translate(-(this.mBounds.left - this.mBorderWidth), -(this.mBounds.top - this.mBorderWidth));
            }
        }

        private void adjustBorderWidthAndBorderBounds(Canvas canvas) {
            Matrix matrix = canvas.getMatrix();
            float[] fArray = new float[9];
            matrix.getValues(fArray);
            float f2 = fArray[0];
            float f3 = this.mBounds.width() * f2;
            this.mBorderWidth = this.mBorderWidth * this.mBounds.width() / (f3 - 2.0f * this.mBorderWidth);
            this.mBorderPaint.setStrokeWidth(this.mBorderWidth);
            this.mBorderBounds.set(this.mBounds);
            this.mBorderBounds.inset(-this.mBorderWidth / 2.0f, -this.mBorderWidth / 2.0f);
        }

        private void setBorderRadii() {
            for (int j = 0; j < this.mRadii.length; ++j) {
                if (!(this.mRadii[j] > 0.0f)) continue;
                this.mBorderRadii[j] = this.mRadii[j];
                this.mRadii[j] = this.mRadii[j] - this.mBorderWidth;
            }
        }

        public void draw(Canvas canvas) {
            canvas.save();
            if (!this.mBoundsConfigured) {
                this.configureBounds(canvas);
                if (this.mBorderWidth > 0.0f) {
                    this.adjustBorderWidthAndBorderBounds(canvas);
                    this.setBorderRadii();
                }
                this.mBoundsConfigured = true;
            }
            if (this.mOval) {
                if (this.mBorderWidth > 0.0f) {
                    this.adjustCanvasForBorder(canvas);
                    this.mPath.addOval(this.mBounds, Path.Direction.CW);
                    canvas.drawPath(this.mPath, this.mBitmapPaint);
                    this.mPath.reset();
                    this.mPath.addOval(this.mBorderBounds, Path.Direction.CW);
                    canvas.drawPath(this.mPath, this.mBorderPaint);
                } else {
                    this.mPath.addOval(this.mBounds, Path.Direction.CW);
                    canvas.drawPath(this.mPath, this.mBitmapPaint);
                }
            } else if (this.mBorderWidth > 0.0f) {
                this.adjustCanvasForBorder(canvas);
                this.mPath.addRoundRect(this.mBounds, this.mRadii, Path.Direction.CW);
                canvas.drawPath(this.mPath, this.mBitmapPaint);
                this.mPath.reset();
                this.mPath.addRoundRect(this.mBorderBounds, this.mBorderRadii, Path.Direction.CW);
                canvas.drawPath(this.mPath, this.mBorderPaint);
            } else {
                this.mPath.addRoundRect(this.mBounds, this.mRadii, Path.Direction.CW);
                canvas.drawPath(this.mPath, this.mBitmapPaint);
            }
            canvas.restore();
        }

        public void setCornerRadii(float[] fArray) {
            if (fArray == null) {
                return;
            }
            if (fArray.length != 8) {
                throw new ArrayIndexOutOfBoundsException("radii[] needs 8 values");
            }
            for (int j = 0; j < fArray.length; ++j) {
                this.mRadii[j] = fArray[j];
            }
        }

        public int getOpacity() {
            return this.mBitmap == null || this.mBitmap.hasAlpha() || this.mBitmapPaint.getAlpha() < 255 ? -3 : -1;
        }

        public void setAlpha(int n) {
            this.mBitmapPaint.setAlpha(n);
            this.invalidateSelf();
        }

        public void setColorFilter(ColorFilter colorFilter) {
            this.mBitmapPaint.setColorFilter(colorFilter);
            this.invalidateSelf();
        }

        public void setDither(boolean bl) {
            this.mBitmapPaint.setDither(bl);
            this.invalidateSelf();
        }

        public void setFilterBitmap(boolean bl) {
            this.mBitmapPaint.setFilterBitmap(bl);
            this.invalidateSelf();
        }

        public int getIntrinsicWidth() {
            return this.mBitmapWidth;
        }

        public int getIntrinsicHeight() {
            return this.mBitmapHeight;
        }

        public float getBorderWidth() {
            return this.mBorderWidth;
        }

        public void setBorderWidth(float f2) {
            this.mBorderWidth = f2;
            this.mBorderPaint.setStrokeWidth(f2);
        }

        public int getBorderColor() {
            return this.mBorderColor.getDefaultColor();
        }

        public void setBorderColor(int n) {
            this.setBorderColor(ColorStateList.valueOf((int)n));
        }

        public ColorStateList getBorderColors() {
            return this.mBorderColor;
        }

        public void setBorderColor(ColorStateList colorStateList) {
            if (colorStateList == null) {
                this.mBorderWidth = 0.0f;
                this.mBorderColor = ColorStateList.valueOf((int)0);
                this.mBorderPaint.setColor(0);
            } else {
                this.mBorderColor = colorStateList;
                this.mBorderPaint.setColor(this.mBorderColor.getColorForState(this.getState(), -16777216));
            }
        }

        public boolean isOval() {
            return this.mOval;
        }

        public void setOval(boolean bl) {
            this.mOval = bl;
        }

        public ImageView.ScaleType getScaleType() {
            return this.mScaleType;
        }

        public void setScaleType(ImageView.ScaleType scaleType) {
            if (scaleType == null) {
                return;
            }
            this.mScaleType = scaleType;
        }
    }
}

