/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Shader;
import androidx.annotation.NonNull;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.Transformation;
import com.bumptech.glide.load.engine.Resource;
import com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import com.bumptech.glide.load.resource.bitmap.BitmapResource;
import java.security.MessageDigest;

public class RoundedCornersTransformation
implements Transformation<Bitmap> {
    private BitmapPool mBitmapPool;
    private int mRadius;
    private int mDiameter;
    private int mMargin;
    private CornerType mCornerType;

    @NonNull
    public Resource<Bitmap> transform(@NonNull Context context, @NonNull Resource<Bitmap> resource, int n, int n2) {
        int n3;
        Bitmap bitmap = (Bitmap)resource.get();
        int n4 = bitmap.getWidth();
        Bitmap bitmap2 = this.mBitmapPool.get(n4, n3 = bitmap.getHeight(), Bitmap.Config.ARGB_8888);
        if (bitmap2 == null) {
            bitmap2 = Bitmap.createBitmap((int)n4, (int)n3, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        }
        Canvas canvas = new Canvas(bitmap2);
        Paint paint = new Paint();
        paint.setAntiAlias(true);
        paint.setShader((Shader)new BitmapShader(bitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP));
        this.drawRoundRect(canvas, paint, n4, n3);
        return BitmapResource.obtain((Bitmap)bitmap2, (BitmapPool)this.mBitmapPool);
    }

    public void updateDiskCacheKey(@NonNull MessageDigest messageDigest) {
    }

    public RoundedCornersTransformation(Context context, int n, int n2) {
        this(context, n, n2, CornerType.ALL);
    }

    public RoundedCornersTransformation(BitmapPool bitmapPool, int n, int n2) {
        this(bitmapPool, n, n2, CornerType.ALL);
    }

    public RoundedCornersTransformation(Context context, int n, int n2, CornerType cornerType) {
        this(Glide.get((Context)context).getBitmapPool(), n, n2, cornerType);
    }

    public RoundedCornersTransformation(BitmapPool bitmapPool, int n, int n2, CornerType cornerType) {
        this.mBitmapPool = bitmapPool;
        this.mRadius = n;
        this.mDiameter = this.mRadius * 2;
        this.mMargin = n2;
        this.mCornerType = cornerType;
    }

    private void drawRoundRect(Canvas canvas, Paint paint, float f2, float f3) {
        float f4 = f2 - (float)this.mMargin;
        float f5 = f3 - (float)this.mMargin;
        switch (this.mCornerType) {
            case ALL: {
                canvas.drawRoundRect(new RectF((float)this.mMargin, (float)this.mMargin, f4, f5), (float)this.mRadius, (float)this.mRadius, paint);
                break;
            }
            case TOP_LEFT: {
                this.drawTopLeftRoundRect(canvas, paint, f4, f5);
                break;
            }
            case TOP_RIGHT: {
                this.drawTopRightRoundRect(canvas, paint, f4, f5);
                break;
            }
            case BOTTOM_LEFT: {
                this.drawBottomLeftRoundRect(canvas, paint, f4, f5);
                break;
            }
            case BOTTOM_RIGHT: {
                this.drawBottomRightRoundRect(canvas, paint, f4, f5);
                break;
            }
            case TOP: {
                this.drawTopRoundRect(canvas, paint, f4, f5);
                break;
            }
            case BOTTOM: {
                this.drawBottomRoundRect(canvas, paint, f4, f5);
                break;
            }
            case LEFT: {
                this.drawLeftRoundRect(canvas, paint, f4, f5);
                break;
            }
            case RIGHT: {
                this.drawRightRoundRect(canvas, paint, f4, f5);
                break;
            }
            case OTHER_TOP_LEFT: {
                this.drawOtherTopLeftRoundRect(canvas, paint, f4, f5);
                break;
            }
            case OTHER_TOP_RIGHT: {
                this.drawOtherTopRightRoundRect(canvas, paint, f4, f5);
                break;
            }
            case OTHER_BOTTOM_LEFT: {
                this.drawOtherBottomLeftRoundRect(canvas, paint, f4, f5);
                break;
            }
            case OTHER_BOTTOM_RIGHT: {
                this.drawOtherBottomRightRoundRect(canvas, paint, f4, f5);
                break;
            }
            case DIAGONAL_FROM_TOP_LEFT: {
                this.drawDiagonalFromTopLeftRoundRect(canvas, paint, f4, f5);
                break;
            }
            case DIAGONAL_FROM_TOP_RIGHT: {
                this.drawDiagonalFromTopRightRoundRect(canvas, paint, f4, f5);
                break;
            }
            default: {
                canvas.drawRoundRect(new RectF((float)this.mMargin, (float)this.mMargin, f4, f5), (float)this.mRadius, (float)this.mRadius, paint);
            }
        }
    }

    private void drawTopLeftRoundRect(Canvas canvas, Paint paint, float f2, float f3) {
        canvas.drawRoundRect(new RectF((float)this.mMargin, (float)this.mMargin, (float)(this.mMargin + this.mDiameter), (float)(this.mMargin + this.mDiameter)), (float)this.mRadius, (float)this.mRadius, paint);
        canvas.drawRect(new RectF((float)this.mMargin, (float)(this.mMargin + this.mRadius), (float)(this.mMargin + this.mRadius), f3), paint);
        canvas.drawRect(new RectF((float)(this.mMargin + this.mRadius), (float)this.mMargin, f2, f3), paint);
    }

    private void drawTopRightRoundRect(Canvas canvas, Paint paint, float f2, float f3) {
        canvas.drawRoundRect(new RectF(f2 - (float)this.mDiameter, (float)this.mMargin, f2, (float)(this.mMargin + this.mDiameter)), (float)this.mRadius, (float)this.mRadius, paint);
        canvas.drawRect(new RectF((float)this.mMargin, (float)this.mMargin, f2 - (float)this.mRadius, f3), paint);
        canvas.drawRect(new RectF(f2 - (float)this.mRadius, (float)(this.mMargin + this.mRadius), f2, f3), paint);
    }

    private void drawBottomLeftRoundRect(Canvas canvas, Paint paint, float f2, float f3) {
        canvas.drawRoundRect(new RectF((float)this.mMargin, f3 - (float)this.mDiameter, (float)(this.mMargin + this.mDiameter), f3), (float)this.mRadius, (float)this.mRadius, paint);
        canvas.drawRect(new RectF((float)this.mMargin, (float)this.mMargin, (float)(this.mMargin + this.mDiameter), f3 - (float)this.mRadius), paint);
        canvas.drawRect(new RectF((float)(this.mMargin + this.mRadius), (float)this.mMargin, f2, f3), paint);
    }

    private void drawBottomRightRoundRect(Canvas canvas, Paint paint, float f2, float f3) {
        canvas.drawRoundRect(new RectF(f2 - (float)this.mDiameter, f3 - (float)this.mDiameter, f2, f3), (float)this.mRadius, (float)this.mRadius, paint);
        canvas.drawRect(new RectF((float)this.mMargin, (float)this.mMargin, f2 - (float)this.mRadius, f3), paint);
        canvas.drawRect(new RectF(f2 - (float)this.mRadius, (float)this.mMargin, f2, f3 - (float)this.mRadius), paint);
    }

    private void drawTopRoundRect(Canvas canvas, Paint paint, float f2, float f3) {
        canvas.drawRoundRect(new RectF((float)this.mMargin, (float)this.mMargin, f2, (float)(this.mMargin + this.mDiameter)), (float)this.mRadius, (float)this.mRadius, paint);
        canvas.drawRect(new RectF((float)this.mMargin, (float)(this.mMargin + this.mRadius), f2, f3), paint);
    }

    private void drawBottomRoundRect(Canvas canvas, Paint paint, float f2, float f3) {
        canvas.drawRoundRect(new RectF((float)this.mMargin, f3 - (float)this.mDiameter, f2, f3), (float)this.mRadius, (float)this.mRadius, paint);
        canvas.drawRect(new RectF((float)this.mMargin, (float)this.mMargin, f2, f3 - (float)this.mRadius), paint);
    }

    private void drawLeftRoundRect(Canvas canvas, Paint paint, float f2, float f3) {
        canvas.drawRoundRect(new RectF((float)this.mMargin, (float)this.mMargin, (float)(this.mMargin + this.mDiameter), f3), (float)this.mRadius, (float)this.mRadius, paint);
        canvas.drawRect(new RectF((float)(this.mMargin + this.mRadius), (float)this.mMargin, f2, f3), paint);
    }

    private void drawRightRoundRect(Canvas canvas, Paint paint, float f2, float f3) {
        canvas.drawRoundRect(new RectF(f2 - (float)this.mDiameter, (float)this.mMargin, f2, f3), (float)this.mRadius, (float)this.mRadius, paint);
        canvas.drawRect(new RectF((float)this.mMargin, (float)this.mMargin, f2 - (float)this.mRadius, f3), paint);
    }

    private void drawOtherTopLeftRoundRect(Canvas canvas, Paint paint, float f2, float f3) {
        canvas.drawRoundRect(new RectF((float)this.mMargin, f3 - (float)this.mDiameter, f2, f3), (float)this.mRadius, (float)this.mRadius, paint);
        canvas.drawRoundRect(new RectF(f2 - (float)this.mDiameter, (float)this.mMargin, f2, f3), (float)this.mRadius, (float)this.mRadius, paint);
        canvas.drawRect(new RectF((float)this.mMargin, (float)this.mMargin, f2 - (float)this.mRadius, f3 - (float)this.mRadius), paint);
    }

    private void drawOtherTopRightRoundRect(Canvas canvas, Paint paint, float f2, float f3) {
        canvas.drawRoundRect(new RectF((float)this.mMargin, (float)this.mMargin, (float)(this.mMargin + this.mDiameter), f3), (float)this.mRadius, (float)this.mRadius, paint);
        canvas.drawRoundRect(new RectF((float)this.mMargin, f3 - (float)this.mDiameter, f2, f3), (float)this.mRadius, (float)this.mRadius, paint);
        canvas.drawRect(new RectF((float)(this.mMargin + this.mRadius), (float)this.mMargin, f2, f3 - (float)this.mRadius), paint);
    }

    private void drawOtherBottomLeftRoundRect(Canvas canvas, Paint paint, float f2, float f3) {
        canvas.drawRoundRect(new RectF((float)this.mMargin, (float)this.mMargin, f2, (float)(this.mMargin + this.mDiameter)), (float)this.mRadius, (float)this.mRadius, paint);
        canvas.drawRoundRect(new RectF(f2 - (float)this.mDiameter, (float)this.mMargin, f2, f3), (float)this.mRadius, (float)this.mRadius, paint);
        canvas.drawRect(new RectF((float)this.mMargin, (float)(this.mMargin + this.mRadius), f2 - (float)this.mRadius, f3), paint);
    }

    private void drawOtherBottomRightRoundRect(Canvas canvas, Paint paint, float f2, float f3) {
        canvas.drawRoundRect(new RectF((float)this.mMargin, (float)this.mMargin, f2, (float)(this.mMargin + this.mDiameter)), (float)this.mRadius, (float)this.mRadius, paint);
        canvas.drawRoundRect(new RectF((float)this.mMargin, (float)this.mMargin, (float)(this.mMargin + this.mDiameter), f3), (float)this.mRadius, (float)this.mRadius, paint);
        canvas.drawRect(new RectF((float)(this.mMargin + this.mRadius), (float)(this.mMargin + this.mRadius), f2, f3), paint);
    }

    private void drawDiagonalFromTopLeftRoundRect(Canvas canvas, Paint paint, float f2, float f3) {
        canvas.drawRoundRect(new RectF((float)this.mMargin, (float)this.mMargin, (float)(this.mMargin + this.mDiameter), (float)(this.mMargin + this.mDiameter)), (float)this.mRadius, (float)this.mRadius, paint);
        canvas.drawRoundRect(new RectF(f2 - (float)this.mDiameter, f3 - (float)this.mDiameter, f2, f3), (float)this.mRadius, (float)this.mRadius, paint);
        canvas.drawRect(new RectF((float)this.mMargin, (float)(this.mMargin + this.mRadius), f2 - (float)this.mDiameter, f3), paint);
        canvas.drawRect(new RectF((float)(this.mMargin + this.mDiameter), (float)this.mMargin, f2, f3 - (float)this.mRadius), paint);
    }

    private void drawDiagonalFromTopRightRoundRect(Canvas canvas, Paint paint, float f2, float f3) {
        canvas.drawRoundRect(new RectF(f2 - (float)this.mDiameter, (float)this.mMargin, f2, (float)(this.mMargin + this.mDiameter)), (float)this.mRadius, (float)this.mRadius, paint);
        canvas.drawRoundRect(new RectF((float)this.mMargin, f3 - (float)this.mDiameter, (float)(this.mMargin + this.mDiameter), f3), (float)this.mRadius, (float)this.mRadius, paint);
        canvas.drawRect(new RectF((float)this.mMargin, (float)this.mMargin, f2 - (float)this.mRadius, f3 - (float)this.mRadius), paint);
        canvas.drawRect(new RectF((float)(this.mMargin + this.mRadius), (float)(this.mMargin + this.mRadius), f2, f3), paint);
    }

    public static enum CornerType {
        ALL,
        TOP_LEFT,
        TOP_RIGHT,
        BOTTOM_LEFT,
        BOTTOM_RIGHT,
        TOP,
        BOTTOM,
        LEFT,
        RIGHT,
        OTHER_TOP_LEFT,
        OTHER_TOP_RIGHT,
        OTHER_BOTTOM_LEFT,
        OTHER_BOTTOM_RIGHT,
        DIAGONAL_FROM_TOP_LEFT,
        DIAGONAL_FROM_TOP_RIGHT;

    }
}

