/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.graphics.PorterDuff;
import android.os.Build;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import androidx.core.view.ViewCompat;
import com.hippo.R;

public class RatingBarMenuFeedback
extends LinearLayout {
    private static final int LOW_RATING_RED = Color.parseColor((String)"#FB9758");
    private static final int MEDIUM_RATING_YELLOW = Color.parseColor((String)"#FFD365");
    private static final int GOOD_RATING_GREEN = Color.parseColor((String)"#8DCF61");
    private static final int RATING_DISABLED_COLOR = Color.parseColor((String)"#efefef");
    private static final int NO_RATING_COLOR = Color.parseColor((String)"#595968");
    private boolean mAnimate = true;
    private boolean mDisplayText = true;
    private int mMaxStars = 5;
    private float mCurrentScore = 0.0f;
    private int mStarOnResource;
    private int mStarOffResource;
    private int mStarHalfResource = R.drawable.ic_menu_feedback_star_off;
    private int belowTextColor;
    private boolean singleColor;
    private int starColor;
    private int noStarColor;
    private TextView[] mStarsViews;
    private float mStarPadding;
    private float viewMargin;
    private float mTextSize;
    private float compoundDrawablePadding;
    private float viewMinWidth;
    private IRatingBarCallbacks onScoreChanged;
    private int mLastStarId;
    private boolean mOnlyForDisplay;
    private double mLastX;
    private boolean mHalfStars = true;

    public IRatingBarCallbacks getOnScoreChanged() {
        return this.onScoreChanged;
    }

    public void setOnScoreChanged(IRatingBarCallbacks iRatingBarCallbacks) {
        this.onScoreChanged = iRatingBarCallbacks;
    }

    public RatingBarMenuFeedback(Context context) {
        super(context);
        this.init();
    }

    public TextView[] getmStarsViews() {
        return this.mStarsViews;
    }

    public float getScore() {
        return this.mCurrentScore;
    }

    public void setScore(float f2, boolean bl) {
        f2 = (float)Math.round(f2 * 2.0f) / 2.0f;
        if (!this.mHalfStars) {
            f2 = Math.round(f2);
        }
        this.mCurrentScore = f2;
        this.refreshStars();
        if (bl && this.onScoreChanged != null) {
            this.onScoreChanged.scoreChanged(this.mCurrentScore);
        }
    }

    public void setStarResource(int n, int n2) {
        this.mStarOnResource = n;
        this.mStarOffResource = n2;
        this.mStarHalfResource = n2;
    }

    public void setScrollToSelect(boolean bl) {
        this.mOnlyForDisplay = !bl;
    }

    public RatingBarMenuFeedback(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.initializeAttributes(attributeSet, context);
        this.init();
    }

    private void initializeAttributes(AttributeSet attributeSet, Context context) {
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.CustomRatingBar);
        int n = typedArray.getIndexCount();
        for (int j = 0; j < n; ++j) {
            int n2 = typedArray.getIndex(j);
            if (n2 == R.styleable.CustomRatingBar_maxStars) {
                this.mMaxStars = typedArray.getInt(n2, 5);
                continue;
            }
            if (n2 == R.styleable.CustomRatingBar_belowTextColor) {
                this.belowTextColor = typedArray.getColor(n2, ContextCompat.getColor((Context)context, (int)R.color.fugu_text_color_primary));
                continue;
            }
            if (n2 == R.styleable.CustomRatingBar_stars) {
                this.mCurrentScore = typedArray.getFloat(n2, 2.5f);
                continue;
            }
            if (n2 == R.styleable.CustomRatingBar_starHalf) {
                this.mStarHalfResource = typedArray.getResourceId(n2, 17301620);
                continue;
            }
            if (n2 == R.styleable.CustomRatingBar_starOn) {
                this.mStarOnResource = typedArray.getResourceId(n2, 17301620);
                continue;
            }
            if (n2 == R.styleable.CustomRatingBar_starOff) {
                this.mStarOffResource = typedArray.getResourceId(n2, 17301621);
                continue;
            }
            if (n2 == R.styleable.CustomRatingBar_starPadding) {
                this.mStarPadding = typedArray.getDimension(n2, 0.0f);
                continue;
            }
            if (n2 == R.styleable.CustomRatingBar_belowTextSize) {
                this.mTextSize = typedArray.getDimension(n2, 0.0f);
                continue;
            }
            if (n2 == R.styleable.CustomRatingBar_viewMargin) {
                this.viewMargin = typedArray.getDimension(n2, 0.0f);
                continue;
            }
            if (n2 == R.styleable.CustomRatingBar_viewMinWidth) {
                this.viewMinWidth = typedArray.getDimension(n2, 0.0f);
                continue;
            }
            if (n2 == R.styleable.CustomRatingBar_compoundDrawablePadding) {
                this.compoundDrawablePadding = typedArray.getDimension(n2, 0.0f);
                continue;
            }
            if (n2 == R.styleable.CustomRatingBar_onlyForDisplay) {
                this.mOnlyForDisplay = typedArray.getBoolean(n2, false);
                continue;
            }
            if (n2 == R.styleable.CustomRatingBar_halfStars) {
                this.mHalfStars = typedArray.getBoolean(n2, true);
                continue;
            }
            if (n2 == R.styleable.CustomRatingBar_animate) {
                this.mAnimate = typedArray.getBoolean(n2, true);
                continue;
            }
            if (n2 == R.styleable.CustomRatingBar_displayText) {
                this.mDisplayText = typedArray.getBoolean(n2, true);
                continue;
            }
            if (n2 == R.styleable.CustomRatingBar_singleColor) {
                this.singleColor = typedArray.getBoolean(n2, false);
                continue;
            }
            if (n2 == R.styleable.CustomRatingBar_starColor) {
                this.starColor = typedArray.getColor(n2, ContextCompat.getColor((Context)context, (int)R.color.fugu_theme_color_primary));
                continue;
            }
            if (n2 != R.styleable.CustomRatingBar_noStarColor) continue;
            this.noStarColor = typedArray.getColor(n2, ContextCompat.getColor((Context)context, (int)R.color.fugu_secondary_text_msg_you));
        }
        typedArray.recycle();
    }

    @TargetApi(value=11)
    public RatingBarMenuFeedback(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.initializeAttributes(attributeSet, context);
        this.init();
    }

    void init() {
        this.mStarsViews = new TextView[this.mMaxStars];
        for (int j = 0; j < this.mMaxStars; ++j) {
            TextView textView = this.createStar();
            this.addView((View)textView);
            this.mStarsViews[j] = textView;
        }
        this.refreshStars();
    }

    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        return true;
    }

    private float getScoreForPosition(float f2) {
        if (this.mHalfStars) {
            return (float)Math.round(f2 / ((float)this.getWidth() / ((float)this.mMaxStars * 3.0f)) / 3.0f * 2.0f) / 2.0f;
        }
        Float f3 = Float.valueOf(f2 / ((float)this.getWidth() / (float)this.mMaxStars));
        int n = f3.intValue() + 1;
        return n > this.mMaxStars ? (float)this.mMaxStars : (n < 0 ? 0.0f : (float)n);
    }

    private int getImageForScore(float f2) {
        if (f2 > 0.0f) {
            return Math.round(f2) - 1;
        }
        return -1;
    }

    private void refreshStars() {
        boolean bl = this.mCurrentScore != 0.0f && (double)this.mCurrentScore % 0.5 == 0.0 && this.mHalfStars;
        for (int j = 1; j <= this.mMaxStars; ++j) {
            if ((float)j <= this.mCurrentScore) {
                this.mStarsViews[j - 1].setCompoundDrawablesWithIntrinsicBounds(0, this.mStarOnResource, 0, 0);
                this.starColor = this.mCurrentScore >= 3.0f ? GOOD_RATING_GREEN : (this.mCurrentScore > 1.0f ? MEDIUM_RATING_YELLOW : LOW_RATING_RED);
                this.mStarsViews[j - 1].getCompoundDrawables()[1].mutate().setColorFilter(this.starColor, PorterDuff.Mode.SRC_ATOP);
            } else {
                if (bl && (double)j - 0.5 <= (double)this.mCurrentScore) {
                    this.mStarsViews[j - 1].setCompoundDrawablesWithIntrinsicBounds(0, this.mStarHalfResource, 0, 0);
                } else {
                    this.mStarsViews[j - 1].setCompoundDrawablesWithIntrinsicBounds(0, this.mStarOffResource, 0, 0);
                }
                if (this.singleColor) {
                    this.mStarsViews[j - 1].getCompoundDrawables()[1].mutate().setColorFilter(RATING_DISABLED_COLOR, PorterDuff.Mode.SRC_ATOP);
                } else {
                    this.mStarsViews[j - 1].getCompoundDrawables()[1].mutate().setColorFilter(RATING_DISABLED_COLOR, PorterDuff.Mode.SRC_ATOP);
                }
            }
            if (!this.mDisplayText) continue;
            if ((float)j == this.mCurrentScore) {
                switch (j) {
                    case 1: {
                        this.mStarsViews[j - 1].setText((CharSequence)this.getContext().getString(R.string.hippo_smile_rating_terrible));
                        break;
                    }
                    case 2: {
                        this.mStarsViews[j - 1].setText((CharSequence)this.getContext().getString(R.string.hippo_smile_rating_bad));
                        break;
                    }
                    case 3: {
                        this.mStarsViews[j - 1].setText((CharSequence)this.getContext().getString(R.string.hippo_smile_rating_okay));
                        break;
                    }
                    case 4: {
                        this.mStarsViews[j - 1].setText((CharSequence)this.getContext().getString(R.string.hippo_smile_rating_good));
                        break;
                    }
                    case 5: {
                        this.mStarsViews[j - 1].setText((CharSequence)this.getContext().getString(R.string.hippo_smile_rating_great));
                    }
                }
                continue;
            }
            this.mStarsViews[j - 1].setText(null);
        }
    }

    private TextView createStar() {
        TextView textView = new TextView(this.getContext());
        textView.setMinWidth((int)(this.viewMinWidth > 0.0f ? this.viewMinWidth : 100.0f));
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, -2);
        layoutParams.weight = 1.0f;
        layoutParams.leftMargin = (int)(this.viewMargin > 0.0f ? this.viewMargin : 5.0f);
        layoutParams.rightMargin = (int)(this.viewMargin > 0.0f ? this.viewMargin : 5.0f);
        if (Build.VERSION.SDK_INT >= 17) {
            layoutParams.setMarginStart((int)(this.viewMargin > 0.0f ? this.viewMargin : 5.0f));
            layoutParams.setMarginEnd((int)(this.viewMargin > 0.0f ? this.viewMargin : 5.0f));
        }
        layoutParams.bottomMargin = (int)(this.viewMargin > 0.0f ? this.viewMargin : 5.0f);
        layoutParams.topMargin = (int)(this.viewMargin > 0.0f ? this.viewMargin : 5.0f);
        textView.setGravity(17);
        textView.setCompoundDrawablePadding((int)(this.compoundDrawablePadding > 0.0f ? this.compoundDrawablePadding : 5.0f));
        textView.setTextSize(2, this.mTextSize > 0.0f ? this.mTextSize : 14.0f);
        textView.setTextColor(this.belowTextColor > 0 ? this.belowTextColor : ContextCompat.getColor((Context)this.getContext(), (int)R.color.fugu_text_color_primary));
        textView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        textView.setCompoundDrawablesWithIntrinsicBounds(0, this.mStarOffResource, 0, 0);
        textView.setPaddingRelative((int)this.mStarPadding, (int)this.mStarPadding, (int)this.mStarPadding, (int)this.mStarPadding);
        return textView;
    }

    private TextView getImageView(int n) {
        try {
            return this.mStarsViews[n];
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean onTouchEvent(@NonNull MotionEvent motionEvent) {
        if (this.mOnlyForDisplay) {
            return true;
        }
        switch (motionEvent.getAction()) {
            case 1: {
                this.animateStarRelease(this.getImageView(this.mLastStarId), this.mCurrentScore);
                this.mLastStarId = -1;
                break;
            }
            case 2: {
                if (Math.abs((double)motionEvent.getX() - this.mLastX) > 80.0) {
                    this.requestDisallowInterceptTouchEvent(true);
                }
                float f2 = this.mCurrentScore;
                this.mCurrentScore = this.getScoreForPosition(motionEvent.getX());
                if (f2 == this.mCurrentScore) break;
                this.animateStarRelease(this.getImageView(this.mLastStarId), this.mCurrentScore);
                this.animateStarPressed(this.getImageView(this.getImageForScore(this.mCurrentScore)), this.mCurrentScore);
                this.mLastStarId = this.getImageForScore(this.mCurrentScore);
                this.refreshStars();
                if (this.onScoreChanged == null) break;
                this.onScoreChanged.scoreChanged(this.mCurrentScore);
                break;
            }
            case 0: {
                this.mLastX = motionEvent.getX();
                float f3 = this.mCurrentScore;
                this.mCurrentScore = this.getScoreForPosition(motionEvent.getX());
                this.animateStarPressed(this.getImageView(this.getImageForScore(this.mCurrentScore)), this.mCurrentScore);
                this.mLastStarId = this.getImageForScore(this.mCurrentScore);
                if (f3 != this.mCurrentScore) {
                    this.refreshStars();
                    if (this.onScoreChanged != null) {
                        this.onScoreChanged.scoreChanged(this.mCurrentScore);
                    }
                }
                return true;
            }
            case 3: {
                this.animateStarRelease(this.getImageView(this.getImageForScore(this.mCurrentScore)), this.mCurrentScore);
            }
        }
        return true;
    }

    private void animateStarPressed(TextView textView, float f2) {
        if (this.mAnimate && textView != null) {
            ViewCompat.animate((View)textView).scaleX(1.2f).scaleY(1.2f).setDuration(100L).start();
        }
    }

    private void animateStarRelease(TextView textView, float f2) {
        if (this.mAnimate && textView != null) {
            ViewCompat.animate((View)textView).scaleX(1.0f).scaleY(1.0f).setDuration(100L).start();
        }
    }

    public boolean isHalfStars() {
        return this.mHalfStars;
    }

    public void setHalfStars(boolean bl) {
        this.mHalfStars = bl;
    }

    public void setEnabled(boolean bl) {
        this.mOnlyForDisplay = !bl;
    }

    public void setRatingDisabled(boolean bl) {
        if (bl) {
            for (int j = 1; j <= this.mMaxStars; ++j) {
                this.mStarsViews[j - 1].getCompoundDrawables()[1].mutate().setColorFilter(RATING_DISABLED_COLOR, PorterDuff.Mode.SRC_ATOP);
            }
        } else {
            this.refreshStars();
        }
    }

    public static interface IRatingBarCallbacks {
        public void scoreChanged(float var1);
    }
}

