/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.PermissionInfo;
import android.net.Uri;
import android.os.Build;
import android.view.View;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import com.google.android.material.R;
import com.google.android.material.snackbar.Snackbar;
import java.util.ArrayList;
import java.util.HashMap;

public final class PermissionCommon {
    private static final int REQUEST_CODE = 8;
    private static final int REQUEST_CODE_RATIONAL = 9;
    private int requestCodeInitiated;
    private View view;
    private String[] permissionsInitiated;
    private Snackbar snackBarPermissionDenied;
    private Snackbar snackBarRational;
    private String appName;
    private Activity activity;
    private PermissionListener permissionListener;
    private HashMap<String, String> rationalMessageMap;
    private boolean isFragment;
    private Fragment fragment;

    private PermissionCommon() {
    }

    public <Instance extends PermissionListener> PermissionCommon(Instance Instance2) {
        this.permissionListener = Instance2;
        if (Instance2 instanceof Activity) {
            this.activity = (Activity)Instance2;
        } else if (Instance2 instanceof Fragment) {
            this.activity = ((Fragment)Instance2).getActivity();
            this.isFragment = true;
            this.fragment = (Fragment)Instance2;
        }
        this.view = this.activity.findViewById(0x1020002);
    }

    public <Instance extends PermissionListener> PermissionCommon(Instance Instance2, @NonNull HashMap<String, String> hashMap) {
        this.permissionListener = Instance2;
        if (Instance2 instanceof Activity) {
            this.activity = (Activity)Instance2;
        } else if (Instance2 instanceof Fragment) {
            this.activity = ((Fragment)Instance2).getActivity();
            this.isFragment = true;
            this.fragment = (Fragment)Instance2;
        }
        this.view = this.activity.findViewById(0x1020002);
        this.rationalMessageMap = hashMap;
    }

    public final void onRequestPermissionsResult(int n, @NonNull String[] stringArray, @NonNull int[] nArray) {
        switch (n) {
            case 8: {
                int n2 = 0;
                for (int n4 : nArray) {
                    if (n4 != 0) continue;
                    ++n2;
                }
                if (nArray.length == n2) {
                    this.permissionListener.permissionGranted(this.requestCodeInitiated);
                    break;
                }
                for (String string2 : stringArray) {
                    if (this.isGranted(string2) || this.shouldShowRationalPermission(string2)) continue;
                    String string3 = "You have disabled the permission to " + this.getPermissionLabel(string2) + ". Please go to app settings to allow permission";
                    this.showPermissionDenied(string3);
                    this.permissionListener.permissionDenied(this.requestCodeInitiated);
                    return;
                }
                this.permissionListener.permissionDenied(this.requestCodeInitiated);
                break;
            }
            case 9: {
                if (nArray.length > 0 && nArray[0] == 0) {
                    this.getPermission(this.requestCodeInitiated, false, this.permissionsInitiated);
                    break;
                }
                if (this.shouldShowRationalPermission(stringArray[0])) {
                    String string4 = "You have disabled the permission to " + this.getPermissionLabel(stringArray[0]) + ".Please go to app settings to allow permission";
                    this.showPermissionDenied(string4);
                    this.permissionListener.permissionDenied(this.requestCodeInitiated);
                    return;
                }
                this.permissionListener.permissionDenied(this.requestCodeInitiated);
                break;
            }
        }
    }

    private String getRationalMessage(String string2) {
        if (this.rationalMessageMap != null && this.rationalMessageMap.containsKey(string2)) {
            return this.rationalMessageMap.get(string2);
        }
        if (this.appName == null) {
            this.appName = this.activity.getString(this.activity.getApplicationInfo().labelRes);
        }
        switch (string2) {
            case "android.permission.CAMERA": {
                return this.appName + " needs permission to access the camera to save images";
            }
            case "android.permission.ACCESS_COARSE_LOCATION": {
                return this.appName + " needs permission fetch current location address";
            }
            case "android.permission.ACCESS_FINE_LOCATION": {
                return this.appName + " needs permission fetch current location address";
            }
            case "android.permission.WRITE_EXTERNAL_STORAGE": {
                return this.appName + " needs storage permission to share the feedback";
            }
        }
        return this.appName + " needs this permission to proceed.";
    }

    public void getPermission(int n, boolean bl, String ... stringArray) {
        if (!bl && Build.VERSION.SDK_INT < 23) {
            this.permissionListener.permissionGranted(n);
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : stringArray) {
            if (this.isGranted(string2)) continue;
            arrayList.add(string2);
        }
        if (arrayList.size() < 1) {
            this.permissionListener.permissionGranted(n);
            return;
        }
        this.permissionsInitiated = stringArray;
        this.requestCodeInitiated = n;
        for (final String string3 : arrayList) {
            if (!this.shouldShowRationalPermission(string3)) continue;
            this.getRationalSnackBar(this.getRationalMessage(string3)).setAction((CharSequence)"OK", new View.OnClickListener(){

                public void onClick(View view) {
                    PermissionCommon.this.requestPermissions(new String[]{string3}, 9);
                }
            }).show();
            return;
        }
        this.requestPermissions(arrayList.toArray(new String[arrayList.size()]), 8);
    }

    private void requestPermissions(String[] stringArray, int n) {
        if (this.isFragment) {
            this.fragment.requestPermissions(stringArray, n);
        } else {
            ActivityCompat.requestPermissions((Activity)this.activity, (String[])stringArray, (int)n);
        }
    }

    private boolean shouldShowRationalPermission(String string2) {
        if (this.isFragment) {
            return this.fragment.shouldShowRequestPermissionRationale(string2);
        }
        return ActivityCompat.shouldShowRequestPermissionRationale((Activity)this.activity, (String)string2);
    }

    public boolean isGranted(String string2) {
        return ContextCompat.checkSelfPermission((Context)this.activity, (String)string2) == 0;
    }

    private CharSequence getPermissionLabel(String string2) {
        try {
            PermissionInfo permissionInfo = this.activity.getPackageManager().getPermissionInfo(string2, 0);
            return permissionInfo.loadLabel(this.activity.getPackageManager());
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            nameNotFoundException.printStackTrace();
            return null;
        }
    }

    private void showPermissionDenied(String string2) {
        if (this.snackBarPermissionDenied == null) {
            this.snackBarPermissionDenied = Snackbar.make((View)this.view, (CharSequence)string2, (int)0);
            ((TextView)this.snackBarPermissionDenied.getView().findViewById(R.id.snackbar_text)).setMaxLines(5);
            this.snackBarPermissionDenied.setAction((CharSequence)"Settings", new View.OnClickListener(){

                public void onClick(View view) {
                    PermissionCommon.this.snackBarPermissionDenied.dismiss();
                    Intent intent = new Intent();
                    intent.setAction("android.settings.APPLICATION_DETAILS_SETTINGS");
                    Uri uri = Uri.fromParts((String)"package", (String)PermissionCommon.this.activity.getPackageName(), null);
                    intent.setData(uri);
                    PermissionCommon.this.activity.startActivity(intent);
                }
            });
        }
        this.snackBarPermissionDenied.setText((CharSequence)string2);
        this.snackBarPermissionDenied.show();
    }

    private Snackbar getRationalSnackBar(String string2) {
        if (this.snackBarRational == null) {
            this.snackBarRational = Snackbar.make((View)this.view, (CharSequence)string2, (int)0);
            ((TextView)this.snackBarRational.getView().findViewById(R.id.snackbar_text)).setMaxLines(5);
        }
        this.snackBarRational.setText((CharSequence)string2);
        return this.snackBarRational;
    }

    public static interface PermissionListener {
        public void permissionGranted(int var1);

        public void permissionDenied(int var1);
    }
}

