/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import com.hippo.utils.HippoLog;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class Foreground
implements Application.ActivityLifecycleCallbacks {
    private static final long CHECK_DELAY = 500L;
    private static final String TAG = Foreground.class.getName();
    private static Foreground instance;
    private boolean foreground = false;
    private boolean paused = true;
    private List<Listener> listeners = new CopyOnWriteArrayList<Listener>();
    private Runnable check;

    public static Foreground init(Application application) {
        if (instance == null) {
            instance = new Foreground();
            application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)instance);
        }
        return instance;
    }

    public static Foreground get(Application application) {
        if (instance == null) {
            Foreground.init(application);
        }
        return instance;
    }

    public static Foreground get(Context context) {
        if (instance == null) {
            Context context2 = context.getApplicationContext();
            if (context2 instanceof Application) {
                return Foreground.init((Application)context2);
            }
            throw new IllegalStateException("Foreground is not initialised and cannot obtain the Application object");
        }
        return instance;
    }

    public static Foreground get() {
        if (instance == null) {
            throw new IllegalStateException("Foreground is not initialised - invoke at least once with parameterised init/get");
        }
        return instance;
    }

    public boolean isForeground() {
        return this.foreground;
    }

    public boolean isBackground() {
        return !this.foreground;
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    public void onActivityResumed(Activity activity) {
        this.paused = false;
        boolean bl = !this.foreground;
        this.foreground = true;
        if (this.check != null) {
            // empty if block
        }
        if (bl) {
            HippoLog.i(TAG, "went foreground");
            for (Listener listener : this.listeners) {
                if (listener == null) continue;
                listener.onBecameForeground();
            }
        } else {
            HippoLog.i(TAG, "still foreground");
        }
    }

    public void onActivityPaused(Activity activity) {
        this.paused = true;
        if (this.check != null) {
            // empty if block
        }
        this.check = new Runnable(){

            @Override
            public void run() {
                if (Foreground.this.foreground && Foreground.this.paused) {
                    Foreground.this.foreground = false;
                    HippoLog.i(TAG, "went background");
                    for (Listener listener : Foreground.this.listeners) {
                        if (listener == null) continue;
                        listener.onBecameBackground();
                    }
                } else {
                    HippoLog.i(TAG, "still foreground");
                }
            }
        };
    }

    public void onActivityCreated(Activity activity, Bundle bundle) {
    }

    public void onActivityStarted(Activity activity) {
    }

    public void onActivityStopped(Activity activity) {
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
    }

    public void onActivityDestroyed(Activity activity) {
    }

    public static interface Listener {
        public void onBecameForeground();

        public void onBecameBackground();
    }
}

