/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils;

import com.hippo.utils.HippoLog;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class DateUtils {
    private static DateUtils dateUtils;
    private static final DateFormat FORMAT_UTC;
    static String STANDARD_DATE_FORMAT_TZ;
    public static String STANDARD_DATE_ONLY_FORMAT;
    private static Calendar feedPostedCal;
    private static Calendar currentDateCal;
    private static final long MESSAGE_EXPIRED_TIME = 600000L;

    public static DateUtils getInstance() {
        if (dateUtils == null) {
            dateUtils = new DateUtils();
        }
        return dateUtils;
    }

    public static String getFormattedDate(Date date) {
        return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.ENGLISH).format(date);
    }

    public static String getFormattedDate(Date date, String string2) {
        return new SimpleDateFormat(string2, Locale.ENGLISH).format(date);
    }

    public String convertToLocal(String string2) {
        return this.convertToLocal(string2, STANDARD_DATE_FORMAT_TZ);
    }

    public String convertToLocal(String string2, String string3) {
        return this.convertToLocal(string2, STANDARD_DATE_FORMAT_TZ, string3);
    }

    public String convertToLocal(String string2, String string3, String string4) {
        Date date;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string3);
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        try {
            date = simpleDateFormat.parse(string2);
        }
        catch (ParseException parseException) {
            try {
                date = DateUtils.utcToLocalTZ(string2);
            }
            catch (Exception exception) {
                date = new Date();
                exception.printStackTrace();
            }
        }
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat(string4);
        simpleDateFormat2.setTimeZone(TimeZone.getDefault());
        String string5 = simpleDateFormat2.format(date);
        return string5;
    }

    public static Date utcToLocalTZ(String string2) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        simpleDateFormat2.setTimeZone(TimeZone.getTimeZone("UTC"));
        try {
            string2 = string2.replace("T", " ");
            string2 = string2.split("\\.")[0];
            Date date = simpleDateFormat2.parse(string2);
            return date;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return new Date();
        }
    }

    public String convertToUTC(String string2) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(STANDARD_DATE_FORMAT_TZ);
        Date date = null;
        try {
            date = simpleDateFormat.parse(string2);
        }
        catch (ParseException parseException) {
            date = new Date();
            parseException.printStackTrace();
        }
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        String string3 = simpleDateFormat.format(date);
        return string3;
    }

    public static String getTime(String string2) {
        try {
            String string3 = string2.split("T")[1].replace("Z", "");
            String string4 = string3.split(":")[0];
            String string5 = string3.split(":")[1];
            String string6 = Integer.parseInt(string4) >= 12 ? "PM" : "AM";
            String string7 = "";
            string7 = Integer.parseInt(string4) == 0 ? "12" : (Integer.parseInt(string4) <= 12 ? string4 : "" + (Integer.parseInt(string4) - 12));
            String string8 = "" + string7 + ":" + string5 + " " + string6;
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(STANDARD_DATE_FORMAT_TZ);
            Date date = simpleDateFormat.parse(string2);
            return string8;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return string2;
        }
    }

    public static String getDate(String string2) {
        try {
            String string3 = "";
            if (!string2.isEmpty()) {
                String string4 = string2.split("T")[0];
                String string5 = string4.split("-")[0];
                String string6 = string4.split("-")[1];
                String string7 = string4.split("-")[2];
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(STANDARD_DATE_ONLY_FORMAT);
                Date date = simpleDateFormat.parse(string2);
                if (android.text.format.DateUtils.isToday((long)date.getTime())) {
                    return "Today";
                }
                if (String.valueOf(android.text.format.DateUtils.getRelativeTimeSpanString((long)date.getTime(), (long)simpleDateFormat.parse(DateUtils.getFormattedDate(new Date())).getTime(), (long)131072L)).equalsIgnoreCase("yesterday")) {
                    return "Yesterday";
                }
                if ("01".equalsIgnoreCase(string6)) {
                    string6 = "Jan";
                } else if ("02".equalsIgnoreCase(string6)) {
                    string6 = "Feb";
                } else if ("03".equalsIgnoreCase(string6)) {
                    string6 = "Mar";
                } else if ("04".equalsIgnoreCase(string6)) {
                    string6 = "Apr";
                } else if ("05".equalsIgnoreCase(string6)) {
                    string6 = "May";
                } else if ("06".equalsIgnoreCase(string6)) {
                    string6 = "Jun";
                } else if ("07".equalsIgnoreCase(string6)) {
                    string6 = "Jul";
                } else if ("08".equalsIgnoreCase(string6)) {
                    string6 = "Aug";
                } else if ("09".equalsIgnoreCase(string6)) {
                    string6 = "Sept";
                } else if ("10".equalsIgnoreCase(string6)) {
                    string6 = "Oct";
                } else if ("11".equalsIgnoreCase(string6)) {
                    string6 = "Nov";
                } else if ("12".equalsIgnoreCase(string6)) {
                    string6 = "Dec";
                }
                string3 = string7 + " " + string6 + " " + string5;
            }
            return string3;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return string2;
        }
    }

    public static String getRelativeDate(String string2, boolean bl) {
        String string3 = "";
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(STANDARD_DATE_FORMAT_TZ);
            Date date = simpleDateFormat.parse(string2);
            if (android.text.format.DateUtils.isToday((long)date.getTime()) && bl) {
                String string4;
                String string5 = string2.split("T")[1].replace("Z", "");
                String string6 = string5.split(":")[0];
                String string7 = string5.split(":")[1];
                String string8 = Integer.parseInt(string6) >= 12 ? "PM" : "AM";
                String string9 = "";
                string9 = Integer.parseInt(string6) == 0 ? "12" : (Integer.parseInt(string6) <= 12 ? string6 : "" + (Integer.parseInt(string6) - 12));
                string3 = string4 = "" + string9 + ":" + string7 + " " + string8;
            } else {
                string3 = String.valueOf(android.text.format.DateUtils.getRelativeTimeSpanString((long)date.getTime(), (long)simpleDateFormat.parse(DateUtils.getFormattedDate(new Date())).getTime(), (long)86400000L, (int)65540));
            }
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
        }
        return string3;
    }

    public static int getTimeInMinutes(String string2) {
        try {
            String string3 = string2.split("T")[1].replace("Z", "");
            int n = Integer.parseInt(string3.split(":")[0]);
            int n2 = Integer.parseInt(string3.split(":")[1]);
            return n * 60 + n2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 0;
        }
    }

    public static Date getUtcDateWithTimeZone(String string2) {
        try {
            HippoLog.v("ttttttttttt", FORMAT_UTC.parse(string2).toString());
            return FORMAT_UTC.parse(string2);
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
            return null;
        }
    }

    public static String getTimeToDisplay(String string2) {
        feedPostedCal.setTime(DateUtils.getUtcDateWithTimeZone(string2));
        currentDateCal.setTimeInMillis(System.currentTimeMillis());
        int n = feedPostedCal.get(1);
        int n2 = currentDateCal.get(1);
        int n3 = currentDateCal.get(2);
        int n4 = feedPostedCal.get(2);
        int n5 = currentDateCal.get(5);
        int n6 = feedPostedCal.get(5);
        int n7 = n2 - n;
        if (n4 > n3 || n4 == n3 && n6 > n5) {
            --n7;
        }
        if (n7 > 0) {
            if (n7 == 1) {
                return n7 + " year ago";
            }
            return n7 + " years ago";
        }
        if (n != n2) {
            n7 = n3 + (11 - n4);
            if (n6 > n5) {
                --n7;
            }
        } else {
            n7 = n3 - n4;
            if (n3 != n4 && n6 > n5) {
                --n7;
            }
        }
        if (n7 > 0) {
            if (n7 == 1) {
                return n7 + " month ago";
            }
            return n7 + " months ago";
        }
        long l = currentDateCal.getTimeInMillis() - feedPostedCal.getTimeInMillis();
        long l2 = l / 604800000L;
        if (l2 >= 1L) {
            return l2 + (l2 == 1L ? " week ago" : " weeks ago");
        }
        l2 = l / 86400000L;
        if (l2 >= 1L) {
            return l2 + (l2 == 1L ? " day ago" : " days ago");
        }
        l2 = l / 3600000L % 24L;
        if (l2 >= 1L) {
            return l2 + (l2 == 1L ? " hour ago" : " hours ago");
        }
        l2 = l / 60000L % 60L;
        if (l2 >= 1L) {
            return l2 + (l2 == 1L ? " minute ago" : " minutes ago");
        }
        l2 = l / 1000L % 60L;
        return " Just now";
    }

    public static String getDateTimeToShow(String string2) {
        feedPostedCal.setTime(DateUtils.getUtcDateWithTimeZone(string2));
        currentDateCal.setTimeInMillis(System.currentTimeMillis());
        int n = feedPostedCal.get(1);
        int n2 = currentDateCal.get(1);
        int n3 = currentDateCal.get(2);
        int n4 = feedPostedCal.get(2);
        int n5 = currentDateCal.get(5);
        int n6 = feedPostedCal.get(5);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMM");
        String string3 = simpleDateFormat.format(feedPostedCal.getTime());
        String string4 = String.valueOf(n).substring(2);
        int n7 = n2 - n;
        if (n4 > n3 || n4 == n3 && n6 > n5) {
            --n7;
        }
        if (n7 > 0) {
            if (n7 == 1) {
                return " " + n6 + " " + string3 + " " + string4;
            }
            return " " + n6 + " " + string3 + " " + string4;
        }
        if (n != n2) {
            n7 = n3 + (11 - n4);
            if (n6 > n5) {
                --n7;
            }
        } else {
            n7 = n3 - n4;
            if (n3 != n4 && n6 > n5) {
                --n7;
            }
        }
        if (n7 > 0) {
            if (n7 == 1) {
                return " " + n6 + " " + string3 + " " + string4;
            }
            return " " + n6 + " " + string3 + " " + string4;
        }
        long l = currentDateCal.getTimeInMillis() - feedPostedCal.getTimeInMillis();
        long l2 = l / 604800000L;
        if (l2 >= 1L) {
            return l2 == 1L ? " " + n6 + " " + string3 + " " + string4 : " " + n6 + " " + string3 + " " + string4;
        }
        l2 = l / 86400000L;
        if (l2 >= 1L) {
            return l2 == 1L ? " " + n6 + " " + string3 + " " + string4 : " " + n6 + " " + string3 + " " + string4;
        }
        l2 = l / 3600000L % 24L;
        if (l2 >= 1L) {
            return l2 + (l2 == 1L ? " hr ago" : " hrs ago");
        }
        l2 = l / 60000L % 60L;
        if (l2 >= 1L) {
            return l2 + (l2 == 1L ? " min ago" : " mins ago");
        }
        l2 = l / 1000L % 60L;
        return " Just now";
    }

    public static long getTimeInLong(String string2) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(STANDARD_DATE_FORMAT_TZ);
        try {
            Date date = simpleDateFormat.parse(string2);
            return date.getTime();
        }
        catch (Exception exception) {
            return -100L;
        }
    }

    public static boolean getTimeDiff(String string2) {
        feedPostedCal.setTime(DateUtils.getUtcDateWithTimeZone(string2));
        currentDateCal.setTimeInMillis(System.currentTimeMillis());
        long l = currentDateCal.getTimeInMillis() - feedPostedCal.getTimeInMillis();
        return l >= 600000L;
    }

    static {
        FORMAT_UTC = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.getDefault());
        FORMAT_UTC.setTimeZone(TimeZone.getTimeZone("UTC"));
        STANDARD_DATE_FORMAT_TZ = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
        STANDARD_DATE_ONLY_FORMAT = "yyyy-MM-dd";
        feedPostedCal = Calendar.getInstance();
        currentDateCal = Calendar.getInstance();
    }
}

