/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils;

import android.content.Context;
import android.content.DialogInterface;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import androidx.appcompat.app.AlertDialog;
import com.hippo.R;

public class CustomAlertDialog {
    public CustomAlertDialog(Builder builder) {
    }

    public static class Builder {
        private final Context mContext;
        private final LayoutInflater mInflater;
        private CharSequence mTitle;
        private CharSequence mMessage;
        private CharSequence mPositiveButtonText;
        private CustomDialogInterface.OnClickListener mPositiveButtonListener;
        private CharSequence mNegativeButtonText;
        private CustomDialogInterface.OnClickListener mNegativeButtonListener;
        private boolean mCancelable;
        private CustomDialogInterface.OnCancelListener mOnCancelListener;
        private CustomDialogInterface.OnDismissListener mOnDismissListener;
        private AlertDialog.Builder mBuilder;
        private AlertDialog mAlertDialog;

        public Builder(@NonNull Context context) {
            this.mContext = context;
            this.mCancelable = true;
            this.mInflater = (LayoutInflater)context.getSystemService("layout_inflater");
        }

        public Builder setTitle(@StringRes int n) {
            this.mTitle = this.mContext.getText(n);
            return this;
        }

        public Builder setTitle(@Nullable CharSequence charSequence) {
            this.mTitle = charSequence;
            return this;
        }

        public Builder setMessage(@StringRes int n) {
            this.mMessage = this.mContext.getText(n);
            return this;
        }

        public Builder setMessage(@Nullable CharSequence charSequence) {
            this.mMessage = charSequence;
            return this;
        }

        public Builder setPositiveButton(@StringRes int n, CustomDialogInterface.OnClickListener onClickListener) {
            this.mPositiveButtonText = this.mContext.getText(n);
            this.mPositiveButtonListener = onClickListener;
            return this;
        }

        public Builder setPositiveButton(CharSequence charSequence, CustomDialogInterface.OnClickListener onClickListener) {
            this.mPositiveButtonText = charSequence;
            this.mPositiveButtonListener = onClickListener;
            return this;
        }

        public Builder setNegativeButton(@StringRes int n, CustomDialogInterface.OnClickListener onClickListener) {
            this.mNegativeButtonText = this.mContext.getText(n);
            this.mNegativeButtonListener = onClickListener;
            return this;
        }

        public Builder setNegativeButton(CharSequence charSequence, CustomDialogInterface.OnClickListener onClickListener) {
            this.mNegativeButtonText = charSequence;
            this.mNegativeButtonListener = onClickListener;
            return this;
        }

        public Builder setCancelable(boolean bl) {
            this.mCancelable = bl;
            return this;
        }

        public Builder setOnCancelListener(CustomDialogInterface.OnCancelListener onCancelListener) {
            this.mOnCancelListener = onCancelListener;
            return this;
        }

        public Builder setOnDismissListener(CustomDialogInterface.OnDismissListener onDismissListener) {
            this.mOnDismissListener = onDismissListener;
            return this;
        }

        public AlertDialog create() {
            this.mBuilder = new AlertDialog.Builder(this.mContext);
            View view = this.mInflater.inflate(R.layout.hippo_dialog_custom, null);
            this.mBuilder.setView(view);
            this.mAlertDialog = this.mBuilder.create();
            TextView textView = (TextView)view.findViewById(R.id.tvTitle);
            TextView textView2 = (TextView)view.findViewById(R.id.tvMessage);
            Button button = (Button)view.findViewById(R.id.btnNegative);
            Button button2 = (Button)view.findViewById(R.id.btnPositive);
            if (this.mTitle != null) {
                textView.setText(this.mTitle);
            } else {
                textView.setVisibility(8);
            }
            if (this.mMessage != null) {
                textView2.setText(this.mMessage);
            }
            if (this.mPositiveButtonText != null) {
                button2.setText(this.mPositiveButtonText);
                button2.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        Builder.this.mAlertDialog.dismiss();
                        if (Builder.this.mPositiveButtonListener != null) {
                            Builder.this.mPositiveButtonListener.onClick();
                        }
                    }
                });
            } else {
                button2.setVisibility(8);
            }
            if (this.mNegativeButtonText != null) {
                button.setText(this.mNegativeButtonText);
                button.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        Builder.this.mAlertDialog.dismiss();
                        if (Builder.this.mNegativeButtonListener != null) {
                            Builder.this.mNegativeButtonListener.onClick();
                        }
                    }
                });
            } else {
                button.setVisibility(8);
            }
            this.mAlertDialog.setCancelable(this.mCancelable);
            this.mAlertDialog.setCanceledOnTouchOutside(this.mCancelable);
            if (this.mOnCancelListener != null) {
                this.mAlertDialog.setOnCancelListener(new DialogInterface.OnCancelListener(){

                    public void onCancel(DialogInterface dialogInterface) {
                        if (Builder.this.mOnCancelListener != null) {
                            Builder.this.mOnCancelListener.onCancel();
                        }
                    }
                });
            }
            if (this.mOnDismissListener != null) {
                this.mAlertDialog.setOnDismissListener(new DialogInterface.OnDismissListener(){

                    public void onDismiss(DialogInterface dialogInterface) {
                        if (Builder.this.mOnDismissListener != null) {
                            Builder.this.mOnDismissListener.onDismiss();
                        }
                    }
                });
            }
            return this.mAlertDialog;
        }

        public AlertDialog show() {
            AlertDialog alertDialog = this.create();
            alertDialog.show();
            return alertDialog;
        }

        public CustomAlertDialog build() {
            return new CustomAlertDialog(this);
        }
    }

    public static interface CustomDialogInterface {

        public static interface OnCancelListener {
            public void onCancel();
        }

        public static interface OnDismissListener {
            public void onDismiss();
        }

        public static interface OnClickListener {
            public void onClick();
        }
    }
}

