/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.support.db;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import com.google.gson.Gson;
import com.hippo.support.model.SupportDataList;
import com.hippo.utils.HippoLog;
import java.util.Map;

public class HippoDatabase {
    private static HippoDatabase INSTANCE;
    private static final String DATABASE_NAME = "hippo_database";
    private static final int DATABASE_VERSION = 1;
    private DbHelper dbHelper;
    private SQLiteDatabase database;
    private static final String TABLE_SUPPORT_DATA = "table_support_data";
    private static final String SUPPORT_CATEGORY = "support_category";
    private static final String SUPPORT_CATEGORY_NAME = "support_category_name";
    private static final String SUPPORT_DATA = "support_data";

    private static void createTable(SQLiteDatabase sQLiteDatabase) {
        sQLiteDatabase.execSQL(" CREATE TABLE IF NOT EXISTS table_support_data (support_category INTEGER, support_category_name TEXT, support_data TEXT);");
    }

    public static HippoDatabase getInstance(Context context) {
        if (INSTANCE == null) {
            INSTANCE = new HippoDatabase(context);
        } else if (!HippoDatabase.INSTANCE.database.isOpen()) {
            INSTANCE = null;
            INSTANCE = new HippoDatabase(context);
        }
        return INSTANCE;
    }

    private HippoDatabase(Context context) {
        this.dbHelper = new DbHelper(context);
        this.database = this.dbHelper.getWritableDatabase();
        HippoDatabase.createTable(this.database);
    }

    public void close() {
        try {
            this.database.close();
            this.dbHelper.close();
            System.gc();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void insertSupportData(int n, String string2) {
        try {
            ContentValues contentValues = new ContentValues();
            contentValues.put(SUPPORT_CATEGORY, Integer.valueOf(n));
            contentValues.put(SUPPORT_DATA, string2);
            this.database.insert(TABLE_SUPPORT_DATA, null, contentValues);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertUpdateSupportData(Map<String, SupportDataList> map) {
        this.deleteSupportData();
        if (map == null) {
            return;
        }
        this.database.beginTransaction();
        Gson gson = new Gson();
        try {
            for (Map.Entry<String, SupportDataList> entry : map.entrySet()) {
                ContentValues contentValues = new ContentValues();
                contentValues.put(SUPPORT_CATEGORY, Integer.valueOf(Integer.parseInt(entry.getKey())));
                contentValues.put(SUPPORT_CATEGORY_NAME, entry.getValue().getCategoryName().toLowerCase().trim());
                contentValues.put(SUPPORT_DATA, gson.toJson((Object)entry.getValue()));
                this.database.insert(TABLE_SUPPORT_DATA, null, contentValues);
            }
            this.database.setTransactionSuccessful();
        }
        catch (Exception exception) {
            HippoLog.e("Error in transaction", "" + exception.toString());
        }
        finally {
            this.database.endTransaction();
        }
    }

    public SupportDataList getSupportDataItems(int n) {
        SupportDataList supportDataList = new SupportDataList();
        try {
            String[] stringArray = new String[]{SUPPORT_DATA};
            Cursor cursor = this.database.query(TABLE_SUPPORT_DATA, stringArray, "support_category=" + n, null, null, null, null);
            if (cursor.getCount() > 0) {
                cursor.moveToFirst();
                String string2 = cursor.getString(cursor.getColumnIndex(SUPPORT_DATA));
                Gson gson = new Gson();
                supportDataList = (SupportDataList)gson.fromJson(string2, SupportDataList.class);
            } else {
                supportDataList = null;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            supportDataList = null;
        }
        return supportDataList;
    }

    public SupportDataList getSupportDataItems(String string2) {
        SupportDataList supportDataList = new SupportDataList();
        try {
            String[] stringArray = new String[]{SUPPORT_DATA};
            Cursor cursor = this.database.query(TABLE_SUPPORT_DATA, stringArray, "support_category_name='" + string2 + "'", null, null, null, null);
            if (cursor.getCount() > 0) {
                cursor.moveToFirst();
                String string3 = cursor.getString(cursor.getColumnIndex(SUPPORT_DATA));
                Gson gson = new Gson();
                supportDataList = (SupportDataList)gson.fromJson(string3, SupportDataList.class);
            } else {
                supportDataList = null;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            supportDataList = null;
        }
        return supportDataList;
    }

    public SupportDataList getSupportDataListLike(String string2) {
        SupportDataList supportDataList = new SupportDataList();
        try {
            String[] stringArray = new String[]{SUPPORT_DATA};
            Cursor cursor = this.database.query(true, TABLE_SUPPORT_DATA, stringArray, "support_category_name LIKE ?", new String[]{"%" + string2 + "%"}, null, null, null, null);
            if (cursor.getCount() > 0) {
                cursor.moveToFirst();
                String string3 = cursor.getString(cursor.getColumnIndex(SUPPORT_DATA));
                Gson gson = new Gson();
                supportDataList = (SupportDataList)gson.fromJson(string3, SupportDataList.class);
            } else {
                supportDataList = null;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            supportDataList = null;
        }
        return supportDataList;
    }

    public void deleteSupportData() {
        this.database.delete(TABLE_SUPPORT_DATA, null, null);
    }

    private static class DbHelper
    extends SQLiteOpenHelper {
        public DbHelper(Context context) {
            super(context, HippoDatabase.DATABASE_NAME, null, 1);
        }

        public DbHelper(Context context, String string2, SQLiteDatabase.CursorFactory cursorFactory, int n) {
            super(context, string2, cursorFactory, n);
        }

        public void onCreate(SQLiteDatabase sQLiteDatabase) {
            HippoDatabase.createTable(sQLiteDatabase);
        }

        public void onUpgrade(SQLiteDatabase sQLiteDatabase, int n, int n2) {
            this.onCreate(sQLiteDatabase);
        }
    }
}

