/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.retrofit;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.text.TextUtils;
import android.widget.Toast;
import com.google.gson.JsonSyntaxException;
import com.hippo.retrofit.APIError;
import com.hippo.retrofit.ErrorUtils;
import com.hippo.utils.HippoLog;
import com.hippo.utils.loadingBox.LoadingBox;
import java.lang.ref.WeakReference;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import org.json.JSONObject;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public abstract class ResponseResolver<T>
implements Callback<T> {
    private WeakReference<Activity> weakActivity = null;
    private Boolean showLoading = false;
    private Boolean showError = false;
    private final String NO_INTERNET_MESSAGE = "No internet connection. Please try again later.";
    private final String REMOTE_SERVER_FAILED_MESSAGE = "Application server could not respond. Please try later.";
    public static final String UNEXPECTED_ERROR_OCCURRED = "Something went wrong. Please try again later";
    private static final String PARSING_ERROR = "Parsing error";
    private AlertDialog.Builder alertDialogBuilder;
    private AlertDialog alertDialog;

    public ResponseResolver(Activity activity) {
        this.weakActivity = new WeakReference<Activity>(activity);
    }

    public ResponseResolver(Activity activity, Boolean bl) {
        this.weakActivity = new WeakReference<Activity>(activity);
        this.showLoading = bl;
        if (bl.booleanValue()) {
            LoadingBox.showOn(activity);
        }
    }

    public ResponseResolver(Activity activity, Boolean bl, Boolean bl2) {
        this.weakActivity = new WeakReference<Activity>(activity);
        this.showLoading = bl;
        this.showError = bl2;
        if (bl.booleanValue()) {
            LoadingBox.showOn(activity);
        }
    }

    public ResponseResolver() {
    }

    public abstract void success(T var1);

    public abstract void failure(APIError var1);

    public void onResponse(Call<T> call, Response<T> response) {
        JSONObject jSONObject = null;
        int n = 0;
        String string2 = "";
        try {
            if (response.errorBody() != null) {
                jSONObject = new JSONObject(response.errorBody().string());
                string2 = jSONObject.getString("message");
                n = Integer.parseInt(jSONObject.getString("type"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        LoadingBox.hide();
        if (response.isSuccessful()) {
            this.success(response.body());
        } else if (TextUtils.isEmpty((CharSequence)string2)) {
            this.fireError(ErrorUtils.parseError(response, n));
        } else {
            this.fireError(new APIError(900, string2, 0));
        }
    }

    public void onFailure(Call<T> call, Throwable throwable) {
        LoadingBox.hide();
        this.fireError(new APIError(900, this.resolveNetworkError(throwable), 0));
    }

    public void fireError(APIError aPIError) {
        if (this.showError.booleanValue() && this.weakActivity.get() != null && this.checkAuthorizationError(aPIError).booleanValue()) {
            return;
        }
        this.failure(aPIError);
    }

    public Boolean checkAuthorizationError(APIError aPIError) {
        if (aPIError.getStatusCode() == 403) {
            Toast.makeText((Context)((Context)this.weakActivity.get()), (CharSequence)aPIError.getMessage(), (int)0).show();
            ((Activity)this.weakActivity.get()).finish();
            return false;
        }
        if (this.showError.booleanValue()) {
            Toast.makeText((Context)((Context)this.weakActivity.get()), (CharSequence)aPIError.getMessage(), (int)0).show();
        }
        return true;
    }

    private String resolveNetworkError(Throwable throwable) {
        HippoLog.e("resolveNetworkError =", String.valueOf(throwable.toString()));
        if (throwable instanceof UnknownHostException) {
            return "No internet connection. Please try again later.";
        }
        if (throwable instanceof SocketTimeoutException) {
            return "No internet connection. Please try again later.";
        }
        if (throwable instanceof ConnectException) {
            return "No internet connection. Please try again later.";
        }
        if (throwable instanceof JsonSyntaxException) {
            return PARSING_ERROR;
        }
        return UNEXPECTED_ERROR_OCCURRED;
    }
}

