/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.payment;

import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.UrlQuerySanitizer;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.webkit.JsResult;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceRequest;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.EditText;
import android.widget.RelativeLayout;
import androidx.appcompat.app.AlertDialog;
import com.hippo.R;
import com.hippo.payment.PaymentConstants;
import com.hippo.utils.HippoLog;
import com.hippo.utils.filepicker.activity.BaseActivity;

public class ProcessingPaymentWebViewActivity
extends BaseActivity
implements View.OnClickListener,
PaymentConstants {
    private WebView wvWebView;
    private String url = "";
    private long paymentMethod = 0L;
    private long paymentFor = 0L;

    @Override
    protected void permissionGranted() {
    }

    @Override
    protected void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.setContentView(R.layout.hippo_web_view_activity);
        if (this.getIntent() != null) {
            this.url = this.getIntent().getStringExtra("url_webview");
            this.paymentMethod = this.getIntent().getLongExtra("VALUE_PAYMENT", 0L);
            this.paymentFor = this.getIntent().getLongExtra("paymentForFlow", 0L);
        }
        this.initViews();
        if (this.url != null) {
            HippoLog.e("URL", this.url + "");
            this.wvWebView.loadUrl(this.url);
        }
    }

    private void initViews() {
        this.wvWebView = (WebView)this.findViewById(R.id.wvWebsite);
        this.setWebViewProperties(this.wvWebView);
    }

    public boolean dispatchTouchEvent(MotionEvent motionEvent) {
        boolean bl = super.dispatchTouchEvent(motionEvent);
        View view = this.getCurrentFocus();
        try {
            if (view != null && view instanceof EditText) {
                View view2 = this.getCurrentFocus();
                int[] nArray = new int[2];
                assert (view2 != null);
                view2.getLocationOnScreen(nArray);
                float f2 = motionEvent.getRawX() + (float)view2.getLeft() - (float)nArray[0];
                float f3 = motionEvent.getRawY() + (float)view2.getTop() - (float)nArray[1];
                if (motionEvent.getAction() == 1 && (f2 < (float)view2.getLeft() || f2 >= (float)view2.getRight() || f3 < (float)view2.getTop() || f3 > (float)view2.getBottom())) {
                    InputMethodManager inputMethodManager = (InputMethodManager)this.getSystemService("input_method");
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }

    private void setWebViewProperties(final WebView webView) {
        webView.setWebViewClient((WebViewClient)new MyWebViewClient());
        webView.setWebChromeClient(new WebChromeClient());
        webView.getSettings().setLoadsImagesAutomatically(true);
        webView.getSettings().setJavaScriptEnabled(true);
        webView.getSettings().setDomStorageEnabled(true);
        webView.setScrollBarStyle(0);
        webView.getSettings().setJavaScriptCanOpenWindowsAutomatically(true);
        webView.getSettings().setSupportMultipleWindows(true);
        if (Build.VERSION.SDK_INT >= 21) {
            webView.getSettings().setMixedContentMode(0);
        }
        webView.getSettings().setAllowFileAccessFromFileURLs(true);
        webView.getSettings().setAllowUniversalAccessFromFileURLs(true);
        webView.getSettings().setAllowFileAccess(true);
        webView.getSettings().setAllowContentAccess(true);
        webView.setWebChromeClient(new WebChromeClient(){

            public boolean onCreateWindow(WebView webView3, boolean bl, boolean bl2, Message message) {
                WebView webView2 = new WebView((Context)ProcessingPaymentWebViewActivity.this);
                webView2.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
                if (ProcessingPaymentWebViewActivity.this.paymentMethod == PaymentConstants.PaymentValue.RAZORPAY.intValue) {
                    webView.addView((View)webView2);
                }
                if (ProcessingPaymentWebViewActivity.this.paymentMethod == PaymentConstants.PaymentValue.RAZORPAY.intValue) {
                    ProcessingPaymentWebViewActivity.this.setWebViewProperties(webView2);
                } else {
                    ProcessingPaymentWebViewActivity.this.setWebViewProperties(ProcessingPaymentWebViewActivity.this.wvWebView);
                }
                WebView.WebViewTransport webViewTransport = (WebView.WebViewTransport)message.obj;
                webViewTransport.setWebView(webView2);
                message.sendToTarget();
                return true;
            }

            public void onCloseWindow(WebView webView2) {
                HippoLog.e("onCloseWindow", webView2 + "");
                webView.removeView((View)webView2);
                super.onCloseWindow(webView2);
            }

            public boolean onJsAlert(WebView webView2, String string2, String string3, JsResult jsResult) {
                HippoLog.e("URL onJsAlert", string2 + "");
                return super.onJsAlert(webView2, string2, string3, jsResult);
            }
        });
    }

    public void onClick(View view) {
        view.getId();
    }

    public void onBackPressed() {
        Intent intent = new Intent();
        intent.putExtras(new Bundle());
        this.setResult(0, intent);
        this.finish();
    }

    private boolean onOverrideUrlLoading(WebView webView, String string2) {
        HippoLog.e("URL", string2 + "");
        UrlQuerySanitizer urlQuerySanitizer = new UrlQuerySanitizer(string2);
        String string3 = "";
        String string4 = "";
        if (this.paymentMethod == PaymentConstants.PaymentValue.RAZORPAY.intValue) {
            string3 = urlQuerySanitizer.getValue("rzp_payment_id");
        } else if (this.paymentMethod == PaymentConstants.PaymentValue.BILLPLZ.intValue) {
            string3 = urlQuerySanitizer.getValue("billplz[id]");
            if (string3 != null) {
                if (this.paymentFor != PaymentConstants.PaymentForFlow.ORDER_PAYMENT.intValue && this.paymentFor != PaymentConstants.PaymentForFlow.REPAY_FROM_TASK_DETAILS.intValue) {
                    Bundle bundle = new Bundle();
                    bundle.putString("tr_id", string3);
                    Intent intent = new Intent();
                    intent.putExtras(bundle);
                    this.setResult(-1, intent);
                    this.finish();
                }
                return true;
            }
        } else if (this.paymentMethod == PaymentConstants.PaymentValue.PAYFORT.intValue) {
            string3 = urlQuerySanitizer.getValue("transactionId");
            string4 = urlQuerySanitizer.getValue("job_payment_detail_id");
        } else {
            string3 = urlQuerySanitizer.getValue("transactionId") != null ? urlQuerySanitizer.getValue("transactionId") : urlQuerySanitizer.getValue("transaction_id");
        }
        if (string2.startsWith("http:") || string2.startsWith("https:")) {
            webView.loadUrl(string2);
            if ((this.paymentMethod == PaymentConstants.PaymentValue.PAYMOB.intValue ? string2.contains("success.html") || string2.contains("Success.html") : string2.contains("success") || string2.contains("Success")) && string3 != null && !string3.isEmpty()) {
                Bundle bundle = new Bundle();
                bundle.putString("tr_id", string3);
                Intent intent = new Intent();
                intent.putExtras(bundle);
                this.setResult(-1, intent);
                new Handler().postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        ProcessingPaymentWebViewActivity.this.finish();
                    }
                }, 1500L);
            } else if (this.paymentMethod == PaymentConstants.PaymentValue.PAYMOB.intValue ? string2.contains("error.html") : string2.contains("error")) {
                Bundle bundle = new Bundle();
                if (string3 != null && !string3.isEmpty()) {
                    bundle.putString("tr_id", string3);
                }
                Intent intent = new Intent();
                intent.putExtras(bundle);
                this.setResult(200, intent);
                new Handler().postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        ProcessingPaymentWebViewActivity.this.finish();
                    }
                }, 1500L);
            }
        }
        return true;
    }

    private void showErrorDialog(String string2) {
        new AlertDialog.Builder((Context)this).setMessage((CharSequence)string2).setOnDismissListener(new DialogInterface.OnDismissListener(){

            public void onDismiss(DialogInterface dialogInterface) {
            }
        });
    }

    private class MyWebViewClient
    extends WebViewClient {
        private MyWebViewClient() {
        }

        public boolean shouldOverrideUrlLoading(WebView webView, WebResourceRequest webResourceRequest) {
            return ProcessingPaymentWebViewActivity.this.onOverrideUrlLoading(webView, webResourceRequest.getUrl().toString());
        }

        public boolean shouldOverrideUrlLoading(WebView webView, String string2) {
            return ProcessingPaymentWebViewActivity.this.onOverrideUrlLoading(webView, string2);
        }

        public void onPageStarted(WebView webView, String string2, Bitmap bitmap) {
            super.onPageStarted(webView, string2, bitmap);
        }

        public void onPageFinished(WebView webView, String string2) {
            super.onPageFinished(webView, string2);
        }
    }
}

