/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.customLayout;

import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.LinearSnapHelper;
import androidx.recyclerview.widget.OrientationHelper;
import androidx.recyclerview.widget.RecyclerView;

public class StartSnapHelper
extends LinearSnapHelper {
    private OrientationHelper mVerticalHelper;
    private OrientationHelper mHorizontalHelper;

    public void attachToRecyclerView(@Nullable RecyclerView recyclerView) throws IllegalStateException {
        super.attachToRecyclerView(recyclerView);
    }

    public int[] calculateDistanceToFinalSnap(@NonNull RecyclerView.LayoutManager layoutManager, @NonNull View view) {
        int[] nArray = new int[]{layoutManager.canScrollHorizontally() ? this.distanceToStart(view, this.getHorizontalHelper(layoutManager)) : 0, layoutManager.canScrollVertically() ? this.distanceToStart(view, this.getVerticalHelper(layoutManager)) : 0};
        return nArray;
    }

    public View findSnapView(RecyclerView.LayoutManager layoutManager) {
        if (layoutManager instanceof LinearLayoutManager) {
            if (layoutManager.canScrollHorizontally()) {
                return this.getStartView(layoutManager, this.getHorizontalHelper(layoutManager));
            }
            return this.getStartView(layoutManager, this.getVerticalHelper(layoutManager));
        }
        return super.findSnapView(layoutManager);
    }

    private int distanceToStart(View view, OrientationHelper orientationHelper) {
        return orientationHelper.getDecoratedStart(view) - orientationHelper.getStartAfterPadding();
    }

    private View getStartView(RecyclerView.LayoutManager layoutManager, OrientationHelper orientationHelper) {
        if (layoutManager instanceof LinearLayoutManager) {
            boolean bl;
            int n = ((LinearLayoutManager)layoutManager).findFirstVisibleItemPosition();
            boolean bl2 = bl = ((LinearLayoutManager)layoutManager).findLastCompletelyVisibleItemPosition() == layoutManager.getItemCount() - 1;
            if (n == -1 || bl) {
                return null;
            }
            View view = layoutManager.findViewByPosition(n);
            if (orientationHelper.getDecoratedEnd(view) >= orientationHelper.getDecoratedMeasurement(view) / 2 && orientationHelper.getDecoratedEnd(view) > 0) {
                return view;
            }
            if (((LinearLayoutManager)layoutManager).findLastCompletelyVisibleItemPosition() == layoutManager.getItemCount() - 1) {
                return null;
            }
            return layoutManager.findViewByPosition(n + 1);
        }
        return super.findSnapView(layoutManager);
    }

    private OrientationHelper getVerticalHelper(RecyclerView.LayoutManager layoutManager) {
        if (this.mVerticalHelper == null) {
            this.mVerticalHelper = OrientationHelper.createVerticalHelper((RecyclerView.LayoutManager)layoutManager);
        }
        return this.mVerticalHelper;
    }

    private OrientationHelper getHorizontalHelper(RecyclerView.LayoutManager layoutManager) {
        if (this.mHorizontalHelper == null) {
            this.mHorizontalHelper = OrientationHelper.createHorizontalHelper((RecyclerView.LayoutManager)layoutManager);
        }
        return this.mHorizontalHelper;
    }
}

