/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.agent.fragment;

import android.content.Context;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.recyclerview.widget.DividerItemDecoration;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.hippo.R;
import com.hippo.agent.AgentBroadcastActivity;
import com.hippo.agent.adapter.FleetListAdapter;
import com.hippo.agent.adapter.ListAdapter;
import com.hippo.agent.model.broadcastResponse.Tag;
import com.hippo.agent.model.broadcastResponse.User;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public class BroadcastFilterList
extends Fragment {
    private static final String TAG = BroadcastFilterList.class.getSimpleName();
    private ListAdapter teamAdapter;
    private FleetListAdapter fleetListAdapter;
    private int fragmentType;
    private ArrayList<Tag> pairBoolData = new ArrayList();
    private ArrayList<User> pairFleetData = new ArrayList();
    private Type taglistType = new TypeToken<List<Tag>>(){}.getType();
    private Type userlistType = new TypeToken<List<User>>(){}.getType();
    private RecyclerView recyclerView;
    private SwipeRefreshLayout refreshLayout;
    private Button applyBtn;
    private TextView selectedTeamName;
    private AgentBroadcastActivity activity;
    private String title = "";
    private String teamName = "";
    public int teamIdd = -2;
    public Tag teamTag;

    public void onCreate(@Nullable Bundle bundle) {
        super.onCreate(bundle);
        if (this.getArguments() != null) {
            this.fragmentType = this.getArguments().getInt("fragment_type", 1);
            String string2 = this.getArguments().getString("data");
            this.title = this.getArguments().getString("title", "Select Item");
            if (this.fragmentType == 1) {
                this.pairBoolData = (ArrayList)new Gson().fromJson(string2, this.taglistType);
            } else {
                this.pairFleetData = (ArrayList)new Gson().fromJson(string2, this.userlistType);
            }
            this.teamName = this.getArguments().getString("team_name", "");
        }
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater layoutInflater, @Nullable ViewGroup viewGroup, @Nullable Bundle bundle) {
        return layoutInflater.inflate(R.layout.hippo_list_fragment, viewGroup, false);
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle bundle) {
        super.onViewCreated(view, bundle);
        this.activity = (AgentBroadcastActivity)this.getActivity();
        this.applyBtn = (Button)view.findViewById(R.id.apply_btn);
        this.selectedTeamName = (TextView)view.findViewById(R.id.selected_team);
        this.selectedTeamName.setTypeface(null, 1);
        this.refreshLayout = (SwipeRefreshLayout)view.findViewById(R.id.swipe_refresh);
        this.refreshLayout.setEnabled(false);
        this.recyclerView = (RecyclerView)view.findViewById(R.id.list_view);
        LinearLayoutManager linearLayoutManager = new LinearLayoutManager((Context)this.getActivity());
        linearLayoutManager.setOrientation(1);
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)linearLayoutManager);
        DividerItemDecoration dividerItemDecoration = new DividerItemDecoration(this.recyclerView.getContext(), linearLayoutManager.getOrientation());
        this.recyclerView.addItemDecoration((RecyclerView.ItemDecoration)dividerItemDecoration);
        this.activity.updateToolBar(this.title);
        if (this.fragmentType == 1) {
            this.teamAdapter = new ListAdapter((Context)this.getActivity(), this.pairBoolData, new ListAdapter.SelectedId(){

                @Override
                public void selectedTeamId(int n, Tag tag) {
                    BroadcastFilterList.this.teamIdd = n;
                    BroadcastFilterList.this.teamTag = tag;
                }
            });
            this.recyclerView.setAdapter((RecyclerView.Adapter)this.teamAdapter);
            this.applyBtn.setVisibility(0);
        } else {
            this.fleetListAdapter = new FleetListAdapter((Context)this.getActivity(), this.fragmentType, this.pairFleetData);
            this.recyclerView.setAdapter((RecyclerView.Adapter)this.fleetListAdapter);
            if (this.fragmentType == 2) {
                this.selectedTeamName.setVisibility(0);
                this.selectedTeamName.setText((CharSequence)this.teamName);
                this.applyBtn.setVisibility(0);
            } else if (this.fragmentType == 3) {
                this.applyBtn.setVisibility(8);
            }
        }
        this.applyBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (BroadcastFilterList.this.fragmentType == 1) {
                    if (BroadcastFilterList.this.activity.getBroadcastFragment() != null) {
                        BroadcastFilterList.this.activity.getBroadcastFragment().selectedTeam(BroadcastFilterList.this.teamIdd, BroadcastFilterList.this.teamTag);
                    }
                    if (BroadcastFilterList.this.teamIdd > -1) {
                        User user = new User();
                        user.setUserId(-1);
                        user.setFullName(BroadcastFilterList.this.getString(R.string.hippo_all_agents) + " " + BroadcastFilterList.this.getString(R.string.hippo_display_name_for_customers));
                        if (BroadcastFilterList.this.teamIdd == -1) {
                            user.setSelected(true);
                        }
                        BroadcastFilterList.this.pairFleetData.add(user);
                        for (int j = 0; j < BroadcastFilterList.this.pairBoolData.size(); ++j) {
                            if (BroadcastFilterList.this.teamIdd != ((Tag)BroadcastFilterList.this.pairBoolData.get(j)).getTagId()) continue;
                            BroadcastFilterList.this.pairFleetData.addAll(((Tag)BroadcastFilterList.this.pairBoolData.get(j)).getUsers());
                            break;
                        }
                        String string2 = BroadcastFilterList.this.getString(R.string.hippo_select_string) + " " + BroadcastFilterList.this.getString(R.string.hippo_display_name_for_customers);
                        BroadcastFilterList.this.activity.updateToolBar(string2);
                        BroadcastFilterList.this.selectedTeamName.setVisibility(0);
                        BroadcastFilterList.this.selectedTeamName.setText((CharSequence)BroadcastFilterList.this.teamTag.getTagName());
                        BroadcastFilterList.this.fragmentType = 2;
                        BroadcastFilterList.this.fleetListAdapter = new FleetListAdapter((Context)BroadcastFilterList.this.getActivity(), BroadcastFilterList.this.fragmentType, BroadcastFilterList.this.pairFleetData);
                        BroadcastFilterList.this.recyclerView.setAdapter((RecyclerView.Adapter)BroadcastFilterList.this.fleetListAdapter);
                    } else {
                        BroadcastFilterList.this.activity.getSupportFragmentManager().popBackStack();
                    }
                } else {
                    if (BroadcastFilterList.this.activity.getBroadcastFragment() != null) {
                        BroadcastFilterList.this.activity.getBroadcastFragment().selectedFleet(BroadcastFilterList.this.pairFleetData);
                    }
                    BroadcastFilterList.this.activity.getSupportFragmentManager().popBackStack();
                }
            }
        });
    }

    public void onResume() {
        super.onResume();
    }

    public void onDestroyView() {
        super.onDestroyView();
    }

    public void onDestroy() {
        super.onDestroy();
    }

    public boolean onOptionsItemSelected(MenuItem menuItem) {
        switch (menuItem.getItemId()) {
            case 16908332: {
                this.activity.onBackPressed();
                return true;
            }
        }
        return super.onOptionsItemSelected(menuItem);
    }

    public void onCreateOptionsMenu(Menu menu2, MenuInflater menuInflater) {
        menuInflater.inflate(R.menu.fugu_empty_menu, menu2);
    }
}

