/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.agent.fragment;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.widget.NestedScrollView;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.google.gson.Gson;
import com.hippo.HippoColorConfig;
import com.hippo.R;
import com.hippo.agent.AgentBroadcastActivity;
import com.hippo.agent.AgentChatActivity;
import com.hippo.agent.Util.MessageMode;
import com.hippo.agent.Util.Utils;
import com.hippo.agent.adapter.BroadcastDetailAdapter;
import com.hippo.agent.database.AgentCommonData;
import com.hippo.agent.fragment.BaseFragment;
import com.hippo.agent.helper.BroadcastListenerHelper;
import com.hippo.agent.listeners.BroadcastListener;
import com.hippo.agent.listeners.OnItemClickListener;
import com.hippo.agent.model.LoginModel.UserData;
import com.hippo.agent.model.broadcastResponse.BroadcastModel;
import com.hippo.agent.model.broadcastStatus.BroadCastObjectModel;
import com.hippo.agent.model.broadcastStatus.BroadcastResponseModel;
import com.hippo.agent.model.broadcastStatus.BroadcastUser;
import com.hippo.agent.model.getConversationResponse.Conversation;
import com.hippo.database.CommonData;
import com.hippo.retrofit.CommonParams;
import com.hippo.utils.DateUtils;
import com.hippo.utils.loadingBox.LoadingBox;
import java.util.ArrayList;

public class BroadcastDetailsFragment
extends BaseFragment
implements BroadcastListener.BroadcastResponse,
OnItemClickListener {
    private static final String TAG = BroadcastDetailsFragment.class.getSimpleName();
    private BroadcastListener broadcastListener;
    private UserData userData;
    private HippoColorConfig hippoColorConfig;
    private AgentBroadcastActivity activity;
    private BroadcastDetailAdapter detailAdapter;
    private BroadCastObjectModel objectModel;
    private LinearLayoutManager layoutManager;
    private NestedScrollView nestedScrollView;
    private RecyclerView recyclerView;
    private RelativeLayout rlFallback;
    private RelativeLayout layoutType;
    private TextView textViewFrom;
    private TextView textViewDate;
    private TextView textViewTitle;
    private TextView textViewMsg;
    private TextView textViewFallback;
    private TextView textViewType;
    private TextView textViewFromValue;
    private TextView textViewDateValue;
    private TextView textViewTitleValue;
    private TextView textViewMsgValue;
    private TextView textViewFallbackValue;
    private TextView textViewTypeValue;
    private ArrayList<BroadcastUser> broadcastUsers = new ArrayList();
    private String STANDARD_DATE_FORMAT_TZ = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    private String OUTPUT_FORMAT = "MMM dd, yyyy, hh:mm a";
    private int pastVisiblesItems;
    private int visibleItemCount;
    private int totalItemCount;
    private boolean hasMorePages;
    private boolean isPagingApiInProgress;
    private int offset = 0;

    @Override
    public void onCreate(@Nullable Bundle bundle) {
        super.onCreate(bundle);
        if (this.getArguments() != null) {
            this.objectModel = (BroadCastObjectModel)this.getArguments().getSerializable("objectModel");
        }
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater layoutInflater, @Nullable ViewGroup viewGroup, @Nullable Bundle bundle) {
        return layoutInflater.inflate(R.layout.hippo_activity_broadcast_details, viewGroup, false);
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle bundle) {
        super.onViewCreated(view, bundle);
        this.broadcastListener = new BroadcastListenerHelper();
        this.activity = (AgentBroadcastActivity)this.getActivity();
        this.activity.updateToolBar(this.getResources().getString(R.string.hippo_broadcast_detail));
        this.hippoColorConfig = CommonData.getColorConfig();
        this.broadcastListener = new BroadcastListenerHelper();
        this.nestedScrollView = (NestedScrollView)view.findViewById(R.id.nestedScrollView);
        this.recyclerView = (RecyclerView)view.findViewById(R.id.recyclerView);
        this.rlFallback = (RelativeLayout)view.findViewById(R.id.rlFallback);
        this.layoutType = (RelativeLayout)view.findViewById(R.id.layoutType);
        this.initView(view);
        this.textViewFromValue.setText((CharSequence)this.objectModel.getFullName());
        String string2 = DateUtils.getInstance().convertToLocal(this.objectModel.getCreatedAt(), this.STANDARD_DATE_FORMAT_TZ, this.OUTPUT_FORMAT);
        this.textViewDateValue.setText((CharSequence)string2);
        this.textViewTitleValue.setText((CharSequence)this.objectModel.getBroadcastTitle());
        Utils.setColor((Context)this.getActivity(), this.textViewMsgValue, this.objectModel.getMessage());
        if (!TextUtils.isEmpty((CharSequence)this.objectModel.getFallbackText())) {
            this.textViewFallbackValue.setText((CharSequence)this.objectModel.getFallbackText());
            this.rlFallback.setVisibility(0);
        } else {
            this.rlFallback.setVisibility(8);
        }
        if (!TextUtils.isEmpty((CharSequence)this.objectModel.getBroadcastType())) {
            this.layoutType.setVisibility(0);
            if (this.objectModel.getBroadcastType().equalsIgnoreCase("email")) {
                this.textViewTypeValue.setText((CharSequence)"Email");
            } else {
                this.textViewTypeValue.setText((CharSequence)"In App");
            }
        } else {
            this.layoutType.setVisibility(8);
        }
        this.detailAdapter = new BroadcastDetailAdapter(this.recyclerView, this);
        this.layoutManager = new LinearLayoutManager((Context)this.getActivity());
        this.layoutManager.setOrientation(1);
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)this.layoutManager);
        this.recyclerView.setAdapter((RecyclerView.Adapter)this.detailAdapter);
        this.getBroadcastStatusList(0);
        this.nestedScrollView.setOnScrollChangeListener(new NestedScrollView.OnScrollChangeListener(){

            public void onScrollChange(NestedScrollView nestedScrollView, int n, int n2, int n3, int n4) {
                if (nestedScrollView.getChildAt(nestedScrollView.getChildCount() - 1) != null && n2 >= nestedScrollView.getChildAt(nestedScrollView.getChildCount() - 1).getMeasuredHeight() - nestedScrollView.getMeasuredHeight() && n2 > n4) {
                    BroadcastDetailsFragment.this.visibleItemCount = BroadcastDetailsFragment.this.layoutManager.getChildCount();
                    BroadcastDetailsFragment.this.totalItemCount = BroadcastDetailsFragment.this.layoutManager.getItemCount();
                    BroadcastDetailsFragment.this.pastVisiblesItems = BroadcastDetailsFragment.this.layoutManager.findFirstVisibleItemPosition();
                    if (!BroadcastDetailsFragment.this.isPagingApiInProgress && BroadcastDetailsFragment.this.hasMorePages && BroadcastDetailsFragment.this.visibleItemCount + BroadcastDetailsFragment.this.pastVisiblesItems >= BroadcastDetailsFragment.this.totalItemCount) {
                        BroadcastDetailsFragment.this.getBroadcastStatusList(BroadcastDetailsFragment.this.broadcastUsers.size());
                    }
                }
            }
        });
        this.recyclerView.addOnScrollListener(new RecyclerView.OnScrollListener(){

            public void onScrolled(RecyclerView recyclerView, int n, int n2) {
                super.onScrolled(recyclerView, n, n2);
                if (n2 > 0) {
                    BroadcastDetailsFragment.this.visibleItemCount = BroadcastDetailsFragment.this.layoutManager.getChildCount();
                    BroadcastDetailsFragment.this.totalItemCount = BroadcastDetailsFragment.this.layoutManager.getItemCount();
                    BroadcastDetailsFragment.this.pastVisiblesItems = BroadcastDetailsFragment.this.layoutManager.findFirstVisibleItemPosition();
                    if (!BroadcastDetailsFragment.this.isPagingApiInProgress && BroadcastDetailsFragment.this.hasMorePages && BroadcastDetailsFragment.this.visibleItemCount + BroadcastDetailsFragment.this.pastVisiblesItems >= BroadcastDetailsFragment.this.totalItemCount) {
                        BroadcastDetailsFragment.this.getBroadcastStatusList(BroadcastDetailsFragment.this.broadcastUsers.size());
                    }
                }
            }
        });
    }

    private void initView(View view) {
        this.textViewFrom = (TextView)view.findViewById(R.id.textViewFrom);
        this.textViewDate = (TextView)view.findViewById(R.id.textViewDate);
        this.textViewTitle = (TextView)view.findViewById(R.id.textViewTitle);
        this.textViewMsg = (TextView)view.findViewById(R.id.textViewMsg);
        this.textViewFallback = (TextView)view.findViewById(R.id.textViewFallback);
        this.textViewType = (TextView)view.findViewById(R.id.textViewType);
        this.textViewFromValue = (TextView)view.findViewById(R.id.textViewFromValue);
        this.textViewDateValue = (TextView)view.findViewById(R.id.textViewDateValue);
        this.textViewTitleValue = (TextView)view.findViewById(R.id.textViewTitleValue);
        this.textViewMsgValue = (TextView)view.findViewById(R.id.textViewMsgValue);
        this.textViewFallbackValue = (TextView)view.findViewById(R.id.textViewFallbackValue);
        this.textViewTypeValue = (TextView)view.findViewById(R.id.textViewTypeValue);
        this.textViewFrom.setTextColor(this.hippoColorConfig.getHippoTextColorSecondary());
        this.textViewDate.setTextColor(this.hippoColorConfig.getHippoTextColorSecondary());
        this.textViewTitle.setTextColor(this.hippoColorConfig.getHippoTextColorSecondary());
        this.textViewMsg.setTextColor(this.hippoColorConfig.getHippoTextColorSecondary());
        this.textViewFallback.setTextColor(this.hippoColorConfig.getHippoTextColorSecondary());
        this.textViewType.setTextColor(this.hippoColorConfig.getHippoTextColorSecondary());
        this.textViewFromValue.setTextColor(this.hippoColorConfig.getHippoTextColorPrimary());
        this.textViewDateValue.setTextColor(this.hippoColorConfig.getHippoTextColorPrimary());
        this.textViewTitleValue.setTextColor(this.hippoColorConfig.getHippoTextColorPrimary());
        this.textViewMsgValue.setTextColor(this.hippoColorConfig.getHippoTextColorPrimary());
        this.textViewFallbackValue.setTextColor(this.hippoColorConfig.getHippoTextColorPrimary());
        this.textViewTypeValue.setTextColor(this.hippoColorConfig.getHippoTextColorPrimary());
    }

    private void getBroadcastStatusList(int n) {
        this.offset = n;
        if (this.userData == null) {
            this.userData = AgentCommonData.getUserData();
        }
        String string2 = this.userData.getAccessToken();
        if (n != 0) {
            this.isPagingApiInProgress = true;
            this.detailAdapter.showPaginationProgressBar(true, true);
        } else {
            LoadingBox.showOn((Activity)this.getActivity());
        }
        CommonParams commonParams = new CommonParams.Builder().add("access_token", string2).add("channel_id", this.objectModel.getChannelId()).add("page_offset", n).build();
        this.broadcastListener.getBroadcastStatus(commonParams.getMap(), this);
    }

    public void onDestroyView() {
        super.onDestroyView();
        this.broadcastListener = null;
    }

    public void onHiddenChanged(boolean bl) {
        super.onHiddenChanged(bl);
        if (!bl) {
            this.activity.updateToolBar(this.getResources().getString(R.string.hippo_broadcast_detail));
        }
    }

    @Override
    public void groupingResponse(BroadcastModel broadcastModel) {
    }

    @Override
    public void sendBroadcastResponse(BroadcastResponseModel broadcastResponseModel) {
    }

    @Override
    public void broadcastListResponse(BroadcastResponseModel broadcastResponseModel) {
    }

    @Override
    public void broadcastStatusResponse(BroadcastResponseModel broadcastResponseModel) {
        LoadingBox.hide();
        if (this.offset != 0) {
            this.isPagingApiInProgress = false;
            this.detailAdapter.showPaginationProgressBar(false, true);
        }
        if (this.broadcastUsers == null) {
            this.broadcastUsers = new ArrayList();
        }
        if (this.offset == 0) {
            this.broadcastUsers.clear();
        }
        this.broadcastUsers.addAll(broadcastResponseModel.getData().getBroadcastUsers());
        this.detailAdapter.setData(this.broadcastUsers);
        this.hasMorePages = broadcastResponseModel.getData().getBroadcastUsers().size() == broadcastResponseModel.getData().getPageSize().intValue();
    }

    @Override
    public void onFailure(int n, String string2) {
    }

    @Override
    public void onClickItem(int n) {
        String string2 = this.broadcastUsers.get(n).getRepliedOn();
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            Conversation conversation = new Conversation();
            conversation.setChannelId(Long.parseLong(string2));
            conversation.setUserId(this.broadcastUsers.get(n).getUserId());
            conversation.setStatus(MessageMode.OPEN_CHAT.getOrdinal());
            conversation.setDisableReply(0);
            Intent intent = new Intent((Context)this.activity, AgentChatActivity.class);
            intent.putExtra("conversation", new Gson().toJson((Object)conversation, Conversation.class));
            this.startActivityForResult(intent, 100);
        }
    }
}

