/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.agent.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.LinearLayout;
import android.widget.RadioButton;
import android.widget.TextView;
import androidx.recyclerview.widget.RecyclerView;
import com.hippo.HippoColorConfig;
import com.hippo.R;
import com.hippo.agent.model.broadcastResponse.Tag;
import com.hippo.database.CommonData;
import java.util.List;

public class ListAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private List<Tag> arrayList;
    private LayoutInflater inflater;
    private SelectedId selectedId;
    private HippoColorConfig hippoColorConfig;

    public ListAdapter(Context context, List<Tag> list, SelectedId selectedId) {
        this.arrayList = list;
        this.selectedId = selectedId;
        this.inflater = LayoutInflater.from((Context)context);
        this.hippoColorConfig = CommonData.getColorConfig();
    }

    public ViewHolder onCreateViewHolder(ViewGroup viewGroup, int n) {
        View view = this.inflater.inflate(R.layout.hippo_textview_for_spinner, viewGroup, false);
        return new ViewHolder(view);
    }

    public void onBindViewHolder(ViewHolder viewHolder, int n) {
        Tag tag = this.arrayList.get(n);
        viewHolder.textView.setText((CharSequence)tag.getTagName());
        viewHolder.textView.setTextColor(this.hippoColorConfig.getHippoTextColorPrimary());
        viewHolder.radioButton.setChecked(tag.isSelected());
        viewHolder.textView.setTypeface(null, 0);
    }

    public int getItemCount() {
        return this.arrayList == null ? 0 : this.arrayList.size();
    }

    public static interface SelectedId {
        public void selectedTeamId(int var1, Tag var2);
    }

    class ViewHolder
    extends RecyclerView.ViewHolder {
        TextView textView;
        CheckBox checkBox;
        RadioButton radioButton;
        LinearLayout mainLayout;

        public ViewHolder(View view) {
            super(view);
            this.textView = (TextView)view.findViewById(R.id.item_textview);
            this.checkBox = (CheckBox)view.findViewById(R.id.cb_item_view);
            this.radioButton = (RadioButton)view.findViewById(R.id.rb_item_view);
            this.mainLayout = (LinearLayout)view.findViewById(R.id.main_layout);
            this.radioButton.setVisibility(0);
            this.checkBox.setVisibility(8);
            this.radioButton.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

                public void onCheckedChanged(CompoundButton compoundButton, boolean bl) {
                    if (compoundButton.isPressed()) {
                        ViewHolder.this.mainLayout.performClick();
                    }
                }
            });
            this.mainLayout.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    int n = ViewHolder.this.getAdapterPosition();
                    boolean bl = false;
                    int n2 = -2;
                    if (n == 0) {
                        bl = true;
                        if (((Tag)ListAdapter.this.arrayList.get(0)).isSelected()) {
                            bl = false;
                        }
                        for (int j = 0; j < ListAdapter.this.arrayList.size(); ++j) {
                            ((Tag)ListAdapter.this.arrayList.get(j)).setSelected(bl);
                        }
                        if (((Tag)ListAdapter.this.arrayList.get(0)).isSelected()) {
                            n2 = -1;
                        }
                        if (ListAdapter.this.selectedId != null) {
                            ListAdapter.this.selectedId.selectedTeamId(n2, (Tag)ListAdapter.this.arrayList.get(0));
                        }
                    } else {
                        if (((Tag)ListAdapter.this.arrayList.get(n)).isSelected()) {
                            if (((Tag)ListAdapter.this.arrayList.get(0)).isSelected()) {
                                bl = true;
                            }
                            for (int j = 0; j < ListAdapter.this.arrayList.size(); ++j) {
                                ((Tag)ListAdapter.this.arrayList.get(j)).setSelected(false);
                            }
                            if (bl) {
                                ((Tag)ListAdapter.this.arrayList.get(n)).setSelected(!((Tag)ListAdapter.this.arrayList.get(n)).isSelected());
                                n2 = ((Tag)ListAdapter.this.arrayList.get(n)).getTagId();
                            } else {
                                n2 = -2;
                            }
                        } else {
                            for (int j = 0; j < ListAdapter.this.arrayList.size(); ++j) {
                                ((Tag)ListAdapter.this.arrayList.get(j)).setSelected(false);
                            }
                            ((Tag)ListAdapter.this.arrayList.get(n)).setSelected(!((Tag)ListAdapter.this.arrayList.get(n)).isSelected());
                            n2 = ((Tag)ListAdapter.this.arrayList.get(n)).getTagId();
                        }
                        if (ListAdapter.this.selectedId != null) {
                            ListAdapter.this.selectedId.selectedTeamId(n2, (Tag)ListAdapter.this.arrayList.get(ViewHolder.this.getAdapterPosition()));
                        }
                    }
                    ListAdapter.this.notifyDataSetChanged();
                }
            });
        }
    }
}

