/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.agent.adapter;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.core.content.res.ResourcesCompat;
import androidx.recyclerview.widget.RecyclerView;
import com.hippo.HippoColorConfig;
import com.hippo.R;
import com.hippo.agent.Util.ProgressBarDisplayRunnable;
import com.hippo.agent.Util.Utils;
import com.hippo.agent.listeners.OnItemClickListener;
import com.hippo.agent.model.broadcastStatus.BroadCastObjectModel;
import com.hippo.database.CommonData;
import com.hippo.utils.DateUtils;
import java.util.ArrayList;

public class BroadcastStatusAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private static final String TAG = BroadcastStatusAdapter.class.getSimpleName();
    private Context context;
    private ArrayList<BroadCastObjectModel> arrayList = new ArrayList();
    private static final int VIEW_TYPE = 1;
    private static final int VIEW_TYPE_LOADING = 2;
    private RecyclerView recyclerView;
    private String STANDARD_DATE_FORMAT_TZ = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    private String OUTPUT_FORMAT = "MMM dd, yyyy, hh:mm aa";
    private OnItemClickListener onItemClickListener;
    private HippoColorConfig hippoColorConfig;
    private ProgressBarDisplayRunnable progressBarDisplayRunnable;

    public BroadcastStatusAdapter(RecyclerView recyclerView, OnItemClickListener onItemClickListener) {
        this.recyclerView = recyclerView;
        this.onItemClickListener = onItemClickListener;
    }

    public void setData(ArrayList<BroadCastObjectModel> arrayList) {
        this.arrayList = arrayList;
        this.notifyDataSetChanged();
    }

    @NonNull
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int n) {
        this.context = viewGroup.getContext();
        this.hippoColorConfig = CommonData.getColorConfig();
        if (n == 2) {
            return new LoadMoreHolder(LayoutInflater.from((Context)viewGroup.getContext()).inflate(R.layout.hippo_layout_loaddata, viewGroup, false));
        }
        return new ViewHolder(LayoutInflater.from((Context)this.context).inflate(R.layout.hippo_item_broadcast_status, viewGroup, false));
    }

    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder viewHolder, int n) {
        if (viewHolder instanceof ViewHolder) {
            ViewHolder viewHolder2 = (ViewHolder)viewHolder;
            BroadCastObjectModel broadCastObjectModel = this.arrayList.get(n);
            viewHolder2.textViewFromValue.setText((CharSequence)broadCastObjectModel.getFullName());
            String string2 = DateUtils.getInstance().convertToLocal(broadCastObjectModel.getCreatedAt(), this.STANDARD_DATE_FORMAT_TZ, this.OUTPUT_FORMAT);
            viewHolder2.textViewDateValue.setText((CharSequence)string2);
            viewHolder2.textViewTitleValue.setText((CharSequence)broadCastObjectModel.getBroadcastTitle());
            Utils.setColor(this.context, viewHolder2.textViewMsgValue, broadCastObjectModel.getMessage());
            if (!TextUtils.isEmpty((CharSequence)broadCastObjectModel.getFallbackText())) {
                viewHolder2.textViewFallbackValue.setText((CharSequence)broadCastObjectModel.getFallbackText());
                viewHolder2.rlFallback.setVisibility(0);
            } else {
                viewHolder2.rlFallback.setVisibility(8);
            }
            if (!TextUtils.isEmpty((CharSequence)broadCastObjectModel.getBroadcastType())) {
                viewHolder2.layoutType.setVisibility(0);
                if (broadCastObjectModel.getBroadcastType().equalsIgnoreCase("email")) {
                    viewHolder2.textViewTypeValue.setText((CharSequence)"Email");
                } else {
                    viewHolder2.textViewTypeValue.setText((CharSequence)"In App");
                }
            } else {
                viewHolder2.layoutType.setVisibility(8);
            }
        }
    }

    public int getItemCount() {
        return this.arrayList == null ? 0 : this.arrayList.size();
    }

    public int getItemViewType(int n) {
        try {
            if (this.arrayList.get(n).getChannelId().equals(-1)) {
                return 2;
            }
            return 1;
        }
        catch (Exception exception) {
            return 1;
        }
    }

    public void applyThemeToDrawable(int n, ImageView imageView) {
        Resources.Theme theme = this.context.getResources().newTheme();
        Drawable drawable2 = ResourcesCompat.getDrawable((Resources)this.context.getResources(), (int)R.drawable.hippo_ic_arrow, (Resources.Theme)theme);
        if (drawable2 != null) {
            PorterDuffColorFilter porterDuffColorFilter = new PorterDuffColorFilter(n, PorterDuff.Mode.SRC_ATOP);
            drawable2.setColorFilter((ColorFilter)porterDuffColorFilter);
        }
        imageView.setImageDrawable(drawable2);
    }

    public void showPaginationProgressBar(boolean bl, boolean bl2) {
        boolean bl3;
        if (this.arrayList == null || this.arrayList.size() == 0) {
            return;
        }
        boolean bl4 = bl3 = this.arrayList.get(this.arrayList.size() - 1).getChannelId() != null && this.arrayList.get(this.arrayList.size() - 1).getChannelId() == -1;
        if (bl) {
            if (!bl3) {
                this.arrayList.add(ProgressBarModel.getInstance());
                if (bl2) {
                    this.recyclerView.post((Runnable)this.getProgressDisplayRunnable(true, this.arrayList.size()));
                }
            }
        } else if (this.arrayList.remove(ProgressBarModel.getInstance()) && bl2) {
            this.recyclerView.post((Runnable)this.getProgressDisplayRunnable(false, this.arrayList.size()));
        }
    }

    private ProgressBarDisplayRunnable getProgressDisplayRunnable(boolean bl, int n) {
        if (this.progressBarDisplayRunnable == null) {
            this.progressBarDisplayRunnable = new ProgressBarDisplayRunnable(this);
        }
        this.progressBarDisplayRunnable.setInsert(bl);
        this.progressBarDisplayRunnable.setPosition(n);
        return this.progressBarDisplayRunnable;
    }

    private static class ProgressBarModel {
        private static BroadCastObjectModel progressBarModel;

        private ProgressBarModel() {
        }

        public static BroadCastObjectModel getInstance() {
            if (progressBarModel == null) {
                progressBarModel = new BroadCastObjectModel(-1);
            }
            return progressBarModel;
        }
    }

    public class LoadMoreHolder
    extends RecyclerView.ViewHolder {
        public LoadMoreHolder(View view) {
            super(view);
        }
    }

    public class ViewHolder
    extends RecyclerView.ViewHolder {
        private ImageView arrow;
        private RelativeLayout relative;
        private RelativeLayout rlFallback;
        private RelativeLayout layoutType;
        private TextView textViewFrom;
        private TextView textViewDate;
        private TextView textViewTitle;
        private TextView textViewMsg;
        private TextView textViewFallback;
        private TextView textViewType;
        private TextView textViewFromValue;
        private TextView textViewDateValue;
        private TextView textViewTitleValue;
        private TextView textViewMsgValue;
        private TextView textViewFallbackValue;
        private TextView textViewTypeValue;

        public ViewHolder(@NonNull View view) {
            super(view);
            this.arrow = (ImageView)view.findViewById(R.id.arrow);
            this.relative = (RelativeLayout)view.findViewById(R.id.relative);
            this.rlFallback = (RelativeLayout)view.findViewById(R.id.rlFallback);
            this.layoutType = (RelativeLayout)view.findViewById(R.id.layoutType);
            this.textViewFrom = (TextView)view.findViewById(R.id.textViewFrom);
            this.textViewDate = (TextView)view.findViewById(R.id.textViewDate);
            this.textViewTitle = (TextView)view.findViewById(R.id.textViewTitle);
            this.textViewMsg = (TextView)view.findViewById(R.id.textViewMsg);
            this.textViewFallback = (TextView)view.findViewById(R.id.textViewFallback);
            this.textViewType = (TextView)view.findViewById(R.id.textViewType);
            this.textViewFromValue = (TextView)view.findViewById(R.id.textViewFromValue);
            this.textViewDateValue = (TextView)view.findViewById(R.id.textViewDateValue);
            this.textViewTitleValue = (TextView)view.findViewById(R.id.textViewTitleValue);
            this.textViewMsgValue = (TextView)view.findViewById(R.id.textViewMsgValue);
            this.textViewFallbackValue = (TextView)view.findViewById(R.id.textViewFallbackValue);
            this.textViewTypeValue = (TextView)view.findViewById(R.id.textViewTypeValue);
            this.textViewFrom.setTextColor(BroadcastStatusAdapter.this.hippoColorConfig.getHippoTextColorSecondary());
            this.textViewDate.setTextColor(BroadcastStatusAdapter.this.hippoColorConfig.getHippoTextColorSecondary());
            this.textViewTitle.setTextColor(BroadcastStatusAdapter.this.hippoColorConfig.getHippoTextColorSecondary());
            this.textViewMsg.setTextColor(BroadcastStatusAdapter.this.hippoColorConfig.getHippoTextColorSecondary());
            this.textViewFallback.setTextColor(BroadcastStatusAdapter.this.hippoColorConfig.getHippoTextColorSecondary());
            this.textViewType.setTextColor(BroadcastStatusAdapter.this.hippoColorConfig.getHippoTextColorSecondary());
            this.textViewFromValue.setTextColor(BroadcastStatusAdapter.this.hippoColorConfig.getHippoTextColorPrimary());
            this.textViewDateValue.setTextColor(BroadcastStatusAdapter.this.hippoColorConfig.getHippoTextColorPrimary());
            this.textViewTitleValue.setTextColor(BroadcastStatusAdapter.this.hippoColorConfig.getHippoTextColorPrimary());
            this.textViewMsgValue.setTextColor(BroadcastStatusAdapter.this.hippoColorConfig.getHippoTextColorPrimary());
            this.textViewFallbackValue.setTextColor(BroadcastStatusAdapter.this.hippoColorConfig.getHippoTextColorPrimary());
            this.textViewTypeValue.setTextColor(BroadcastStatusAdapter.this.hippoColorConfig.getHippoTextColorPrimary());
            BroadcastStatusAdapter.this.applyThemeToDrawable(BroadcastStatusAdapter.this.hippoColorConfig.getHippoThemeColorPrimary(), this.arrow);
            this.relative.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    if (BroadcastStatusAdapter.this.onItemClickListener != null) {
                        BroadcastStatusAdapter.this.onItemClickListener.onClickItem(ViewHolder.this.getAdapterPosition());
                    }
                }
            });
        }
    }
}

