/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.agent.Util.tagview;

import android.animation.ValueAnimator;
import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.graphics.Region;
import android.graphics.Typeface;
import android.os.Build;
import android.text.TextUtils;
import android.view.MotionEvent;
import android.view.View;
import com.hippo.agent.Util.TagContainerLayout;
import com.hippo.agent.Util.Utils;

public class TagView
extends View {
    private float mBorderWidth;
    private float mBorderRadius;
    private float mTextSize;
    private int mHorizontalPadding;
    private int mVerticalPadding;
    private int mBorderColor;
    private int mBackgroundColor;
    private int mTextColor;
    private boolean isViewClickable;
    private int mTagMaxLength;
    private OnTagClickListener mOnTagClickListener;
    private int mMoveSlop = 5;
    private int mSlopThreshold = 4;
    private int mLongPressTime = 500;
    private int mTextDirection = 3;
    private float bdDistance;
    private boolean mTagSupportLettersRTL = false;
    private Paint mPaint;
    private Paint mRipplePaint;
    private RectF mRectF;
    private String mAbstractText;
    private String mOriginText;
    private boolean isUp;
    private boolean isMoved;
    private boolean isExecLongClick;
    private int mLastX;
    private int mLastY;
    private float fontH;
    private float fontW;
    private float mTouchX;
    private float mTouchY;
    private int mRippleDuration = 1000;
    private float mRippleRadius;
    private int mRippleColor;
    private int mRippleAlpha;
    private Path mPath;
    private Typeface mTypeface;
    private ValueAnimator mRippleValueAnimator;
    private boolean mEnableCross;
    private float mCrossAreaWidth;
    private float mCrossAreaPadding;
    private int mCrossColor;
    private float mCrossLineWidth;
    private boolean unSupportedClipPath = false;
    private Runnable mLongClickHandle = new Runnable(){

        @Override
        public void run() {
            int n;
            if (!TagView.this.isMoved && !TagView.this.isUp && (n = ((TagContainerLayout)TagView.this.getParent()).getTagViewState()) == 0) {
                TagView.this.isExecLongClick = true;
                TagView.this.mOnTagClickListener.onTagLongClick((Integer)TagView.this.getTag(), TagView.this.getText());
            }
        }
    };

    public TagView(Context context, String string2) {
        super(context);
        this.init(context, string2);
    }

    private void init(Context context, String string2) {
        this.mPaint = new Paint(1);
        this.mRipplePaint = new Paint(1);
        this.mRipplePaint.setStyle(Paint.Style.FILL);
        this.mRectF = new RectF();
        this.mPath = new Path();
        this.mOriginText = string2 == null ? "" : string2;
        this.mMoveSlop = (int)Utils.dp2px(context, this.mMoveSlop);
        this.mSlopThreshold = (int)Utils.dp2px(context, this.mSlopThreshold);
    }

    private void onDealText() {
        this.mAbstractText = !TextUtils.isEmpty((CharSequence)this.mOriginText) ? (this.mOriginText.length() <= this.mTagMaxLength ? this.mOriginText : this.mOriginText.substring(0, this.mTagMaxLength - 3) + "...") : "";
        this.mPaint.setTypeface(this.mTypeface);
        this.mPaint.setTextSize(this.mTextSize);
        Paint.FontMetrics fontMetrics = this.mPaint.getFontMetrics();
        this.fontH = fontMetrics.descent - fontMetrics.ascent;
        if (this.mTextDirection == 4) {
            this.fontW = 0.0f;
            for (char c2 : this.mAbstractText.toCharArray()) {
                String string2 = String.valueOf(c2);
                this.fontW += this.mPaint.measureText(string2);
            }
        } else {
            this.fontW = this.mPaint.measureText(this.mAbstractText);
        }
    }

    protected void onMeasure(int n, int n2) {
        super.onMeasure(n, n2);
        int n3 = this.mVerticalPadding * 2 + (int)this.fontH;
        int n4 = this.mHorizontalPadding * 2 + (int)this.fontW + (this.isEnableCross() ? n3 : 0);
        this.mCrossAreaWidth = Math.min(Math.max(this.mCrossAreaWidth, (float)n3), (float)n4);
        this.setMeasuredDimension(n4, n3);
    }

    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        super.onSizeChanged(n, n2, n3, n4);
        this.mRectF.set(this.mBorderWidth, this.mBorderWidth, (float)n - this.mBorderWidth, (float)n2 - this.mBorderWidth);
    }

    protected void onDraw(Canvas canvas) {
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setColor(this.mBackgroundColor);
        canvas.drawRoundRect(this.mRectF, this.mBorderRadius, this.mBorderRadius, this.mPaint);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setStrokeWidth(this.mBorderWidth);
        this.mPaint.setColor(this.mBorderColor);
        canvas.drawRoundRect(this.mRectF, this.mBorderRadius, this.mBorderRadius, this.mPaint);
        this.drawRipple(canvas);
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setColor(this.mTextColor);
        if (this.mTextDirection == 4) {
            if (this.mTagSupportLettersRTL) {
                float f2 = (float)((this.isEnableCross() ? this.getWidth() + this.getHeight() : this.getWidth()) / 2) + this.fontW / 2.0f;
                for (char c2 : this.mAbstractText.toCharArray()) {
                    String string2 = String.valueOf(c2);
                    canvas.drawText(string2, f2 -= this.mPaint.measureText(string2), (float)(this.getHeight() / 2) + this.fontH / 2.0f - this.bdDistance, this.mPaint);
                }
            } else {
                canvas.drawText(this.mAbstractText, (this.isEnableCross() ? (float)this.getWidth() + this.fontW : (float)this.getWidth()) / 2.0f - this.fontW / 2.0f, (float)(this.getHeight() / 2) + this.fontH / 2.0f - this.bdDistance, this.mPaint);
            }
        } else {
            canvas.drawText(this.mAbstractText, (float)((this.isEnableCross() ? this.getWidth() - this.getHeight() : this.getWidth()) / 2) - this.fontW / 2.0f, (float)(this.getHeight() / 2) + this.fontH / 2.0f - this.bdDistance, this.mPaint);
        }
        this.drawCross(canvas);
    }

    public boolean dispatchTouchEvent(MotionEvent motionEvent) {
        if (this.isViewClickable) {
            int n = (int)motionEvent.getY();
            int n2 = (int)motionEvent.getX();
            int n3 = motionEvent.getAction();
            switch (n3) {
                case 0: {
                    if (this.getParent() != null) {
                        this.getParent().requestDisallowInterceptTouchEvent(true);
                    }
                    this.mLastY = n;
                    this.mLastX = n2;
                    break;
                }
                case 2: {
                    if (Math.abs(this.mLastY - n) <= this.mSlopThreshold && Math.abs(this.mLastX - n2) <= this.mSlopThreshold) break;
                    if (this.getParent() != null) {
                        this.getParent().requestDisallowInterceptTouchEvent(false);
                    }
                    this.isMoved = true;
                    return false;
                }
            }
        }
        return super.dispatchTouchEvent(motionEvent);
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        int n = motionEvent.getAction();
        if (n == 0) {
            this.mRippleRadius = 0.0f;
            this.mTouchX = motionEvent.getX();
            this.mTouchY = motionEvent.getY();
            this.splashRipple();
        }
        if (this.isEnableCross() && this.isClickCrossArea(motionEvent) && this.mOnTagClickListener != null) {
            if (n == 1) {
                this.mOnTagClickListener.onTagCrossClick((Integer)this.getTag());
            }
            return true;
        }
        if (this.isViewClickable && this.mOnTagClickListener != null) {
            int n2 = (int)motionEvent.getX();
            int n3 = (int)motionEvent.getY();
            switch (n) {
                case 0: {
                    this.mLastY = n3;
                    this.mLastX = n2;
                    this.isMoved = false;
                    this.isUp = false;
                    this.isExecLongClick = false;
                    this.postDelayed(this.mLongClickHandle, this.mLongPressTime);
                    break;
                }
                case 2: {
                    if (this.isMoved || Math.abs(this.mLastX - n2) <= this.mMoveSlop && Math.abs(this.mLastY - n3) <= this.mMoveSlop) break;
                    this.isMoved = true;
                    break;
                }
                case 1: {
                    this.isUp = true;
                    if (this.isExecLongClick || this.isMoved) break;
                    this.mOnTagClickListener.onTagClick((Integer)this.getTag(), this.getText());
                }
            }
            return true;
        }
        return super.onTouchEvent(motionEvent);
    }

    private boolean isClickCrossArea(MotionEvent motionEvent) {
        if (this.mTextDirection == 4) {
            return motionEvent.getX() <= this.mCrossAreaWidth;
        }
        return motionEvent.getX() >= (float)this.getWidth() - this.mCrossAreaWidth;
    }

    private void drawCross(Canvas canvas) {
        if (this.isEnableCross()) {
            this.mCrossAreaPadding = this.mCrossAreaPadding > (float)(this.getHeight() / 2) ? (float)(this.getHeight() / 2) : this.mCrossAreaPadding;
            int n = this.mTextDirection == 4 ? (int)this.mCrossAreaPadding : (int)((float)(this.getWidth() - this.getHeight()) + this.mCrossAreaPadding);
            int n2 = this.mTextDirection == 4 ? (int)this.mCrossAreaPadding : (int)this.mCrossAreaPadding;
            int n3 = this.mTextDirection == 4 ? (int)this.mCrossAreaPadding : (int)((float)(this.getWidth() - this.getHeight()) + this.mCrossAreaPadding);
            int n4 = this.mTextDirection == 4 ? (int)((float)this.getHeight() - this.mCrossAreaPadding) : (int)((float)this.getHeight() - this.mCrossAreaPadding);
            int n5 = this.mTextDirection == 4 ? (int)((float)this.getHeight() - this.mCrossAreaPadding) : (int)((float)this.getWidth() - this.mCrossAreaPadding);
            int n6 = this.mTextDirection == 4 ? (int)this.mCrossAreaPadding : (int)this.mCrossAreaPadding;
            int n7 = this.mTextDirection == 4 ? (int)((float)this.getHeight() - this.mCrossAreaPadding) : (int)((float)this.getWidth() - this.mCrossAreaPadding);
            int n8 = this.mTextDirection == 4 ? (int)((float)this.getHeight() - this.mCrossAreaPadding) : (int)((float)this.getHeight() - this.mCrossAreaPadding);
            this.mPaint.setStyle(Paint.Style.STROKE);
            this.mPaint.setColor(this.mCrossColor);
            this.mPaint.setStrokeWidth(this.mCrossLineWidth);
            canvas.drawLine((float)n, (float)n2, (float)n7, (float)n8, this.mPaint);
            canvas.drawLine((float)n3, (float)n4, (float)n5, (float)n6, this.mPaint);
        }
    }

    @TargetApi(value=11)
    private void drawRipple(Canvas canvas) {
        if (this.isViewClickable && Build.VERSION.SDK_INT >= 11 && canvas != null && !this.unSupportedClipPath) {
            if (Build.VERSION.SDK_INT < 18) {
                this.setLayerType(1, null);
            }
            try {
                canvas.save();
                this.mPath.reset();
                canvas.clipPath(this.mPath);
                this.mPath.addRoundRect(this.mRectF, this.mBorderRadius, this.mBorderRadius, Path.Direction.CCW);
                try {
                    if (Build.VERSION.SDK_INT >= 28) {
                        canvas.clipPath(this.mPath);
                    } else {
                        canvas.clipPath(this.mPath, Region.Op.INTERSECT);
                    }
                }
                catch (Exception exception) {
                    canvas.clipPath(this.mPath);
                }
                canvas.drawCircle(this.mTouchX, this.mTouchY, this.mRippleRadius, this.mRipplePaint);
                canvas.restore();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                this.unSupportedClipPath = true;
            }
            catch (Exception exception) {
                this.unSupportedClipPath = true;
            }
        }
    }

    @TargetApi(value=11)
    private void splashRipple() {
        if (Build.VERSION.SDK_INT >= 11 && this.mTouchX > 0.0f && this.mTouchY > 0.0f) {
            this.mRipplePaint.setColor(this.mRippleColor);
            this.mRipplePaint.setAlpha(this.mRippleAlpha);
            final float f2 = Math.max(Math.max(Math.max(this.mTouchX, this.mTouchY), Math.abs((float)this.getMeasuredWidth() - this.mTouchX)), Math.abs((float)this.getMeasuredHeight() - this.mTouchY));
            this.mRippleValueAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, f2}).setDuration((long)this.mRippleDuration);
            this.mRippleValueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator valueAnimator) {
                    float f22 = ((Float)valueAnimator.getAnimatedValue()).floatValue();
                    TagView.this.mRippleRadius = f22 >= f2 ? 0.0f : f22;
                    TagView.this.postInvalidate();
                }
            });
            this.mRippleValueAnimator.start();
        }
    }

    public String getText() {
        return this.mOriginText;
    }

    public boolean getIsViewClickable() {
        return this.isViewClickable;
    }

    public void setTagMaxLength(int n) {
        this.mTagMaxLength = n;
        this.onDealText();
    }

    public void setOnTagClickListener(OnTagClickListener onTagClickListener) {
        this.mOnTagClickListener = onTagClickListener;
    }

    public void setTagBackgroundColor(int n) {
        this.mBackgroundColor = n;
    }

    public void setTagBorderColor(int n) {
        this.mBorderColor = n;
    }

    public void setTagTextColor(int n) {
        this.mTextColor = n;
    }

    public void setBorderWidth(float f2) {
        this.mBorderWidth = f2;
    }

    public void setBorderRadius(float f2) {
        this.mBorderRadius = f2;
    }

    public void setTextSize(float f2) {
        this.mTextSize = f2;
        this.onDealText();
    }

    public void setHorizontalPadding(int n) {
        this.mHorizontalPadding = n;
    }

    public void setVerticalPadding(int n) {
        this.mVerticalPadding = n;
    }

    public void setIsViewClickable(boolean bl) {
        this.isViewClickable = bl;
    }

    public int getTextDirection() {
        return this.mTextDirection;
    }

    public void setTextDirection(int n) {
        this.mTextDirection = n;
    }

    public void setTypeface(Typeface typeface) {
        this.mTypeface = typeface;
        this.onDealText();
    }

    public void setRippleAlpha(int n) {
        this.mRippleAlpha = n;
    }

    public void setRippleColor(int n) {
        this.mRippleColor = n;
    }

    public void setRippleDuration(int n) {
        this.mRippleDuration = n;
    }

    public void setBdDistance(float f2) {
        this.bdDistance = f2;
    }

    public boolean isEnableCross() {
        return this.mEnableCross;
    }

    public void setEnableCross(boolean bl) {
        this.mEnableCross = bl;
    }

    public float getCrossAreaWidth() {
        return this.mCrossAreaWidth;
    }

    public void setCrossAreaWidth(float f2) {
        this.mCrossAreaWidth = f2;
    }

    public float getCrossLineWidth() {
        return this.mCrossLineWidth;
    }

    public void setCrossLineWidth(float f2) {
        this.mCrossLineWidth = f2;
    }

    public float getCrossAreaPadding() {
        return this.mCrossAreaPadding;
    }

    public void setCrossAreaPadding(float f2) {
        this.mCrossAreaPadding = f2;
    }

    public int getCrossColor() {
        return this.mCrossColor;
    }

    public void setCrossColor(int n) {
        this.mCrossColor = n;
    }

    public boolean isTagSupportLettersRTL() {
        return this.mTagSupportLettersRTL;
    }

    public void setTagSupportLettersRTL(boolean bl) {
        this.mTagSupportLettersRTL = bl;
    }

    public static interface OnTagClickListener {
        public void onTagClick(int var1, String var2);

        public void onTagLongClick(int var1, String var2);

        public void onTagCrossClick(int var1);
    }
}

