/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.agent.Util;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.appcompat.widget.AppCompatSpinner;
import androidx.recyclerview.widget.DefaultItemAnimator;
import androidx.recyclerview.widget.RecyclerView;
import com.hippo.R;
import com.hippo.agent.Util.SpinnerListener;
import com.hippo.agent.Util.WrapContentLinearLayoutManager;
import com.hippo.agent.model.broadcastResponse.Tag;
import com.hippo.agent.model.broadcastResponse.User;
import java.util.List;

public class MultiSpinnerSearch
extends AppCompatSpinner
implements DialogInterface.OnCancelListener {
    private static final String TAG = MultiSpinnerSearch.class.getSimpleName();
    private int LIST_TYPE = 0;
    private List<Tag> items;
    private List<User> userArray;
    private String defaultText = "";
    private String spinnerTitle = "";
    private SpinnerListener listener;
    public static AlertDialog.Builder builder;
    public static AlertDialog ad;
    private ListAdapter teamAdapter;
    private FleetListAdapter fleetListAdapter;

    public MultiSpinnerSearch(Context context) {
        super(context);
    }

    public MultiSpinnerSearch(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.MultiSpinnerSearch);
        for (int j = 0; j < typedArray.getIndexCount(); ++j) {
            int n = typedArray.getIndex(j);
            if (n == R.styleable.MultiSpinnerSearch_hintText) {
                this.defaultText = this.spinnerTitle = typedArray.getString(n);
            }
            if (n != R.styleable.MultiSpinnerSearch_listType) continue;
            this.LIST_TYPE = typedArray.getInt(n, 0);
            break;
        }
        typedArray.recycle();
    }

    public MultiSpinnerSearch(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
    }

    public void onCancel(DialogInterface dialogInterface) {
        if (this.LIST_TYPE == 0) {
            this.listener.onItemsSelected(this.items);
        }
    }

    public boolean performClick() {
        builder = new AlertDialog.Builder(this.getContext(), R.style.dialog);
        builder.setTitle((CharSequence)this.spinnerTitle);
        LayoutInflater layoutInflater = (LayoutInflater)this.getContext().getSystemService("layout_inflater");
        View view = layoutInflater.inflate(R.layout.fugu_alert_dialog_listview, null);
        builder.setView(view);
        RecyclerView recyclerView = (RecyclerView)view.findViewById(R.id.alertSearchListView);
        WrapContentLinearLayoutManager wrapContentLinearLayoutManager = new WrapContentLinearLayoutManager(this.getContext(), 1, false);
        recyclerView.setLayoutManager((RecyclerView.LayoutManager)wrapContentLinearLayoutManager);
        recyclerView.setItemAnimator((RecyclerView.ItemAnimator)new DefaultItemAnimator());
        recyclerView.setHasFixedSize(false);
        recyclerView.setDescendantFocusability(131072);
        recyclerView.requestFocus();
        if (this.LIST_TYPE == 0) {
            this.teamAdapter = new ListAdapter(this.getContext(), this.items);
            recyclerView.setAdapter((RecyclerView.Adapter)this.teamAdapter);
        } else {
            this.fleetListAdapter = new FleetListAdapter(this.getContext(), this.userArray);
            recyclerView.setAdapter((RecyclerView.Adapter)this.fleetListAdapter);
        }
        builder.setPositiveButton(17039370, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n) {
                dialogInterface.cancel();
            }
        });
        builder.setNegativeButton(0x1040000, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n) {
                dialogInterface.cancel();
            }
        });
        builder.setOnCancelListener((DialogInterface.OnCancelListener)this);
        ad = builder.show();
        return true;
    }

    public void setItems(List<Tag> list, SpinnerListener spinnerListener) {
        this.LIST_TYPE = 0;
        this.items = list;
        this.listener = spinnerListener;
    }

    public void setFleetItems(List<User> list, SpinnerListener spinnerListener) {
        this.LIST_TYPE = 1;
        this.userArray = list;
        this.listener = spinnerListener;
    }

    class ViewHolder
    extends RecyclerView.ViewHolder {
        TextView textView;
        CheckBox checkBox;
        RelativeLayout mainLayout;

        public ViewHolder(View view) {
            super(view);
            this.textView = (TextView)view.findViewById(R.id.alertTextView);
            this.checkBox = (CheckBox)view.findViewById(R.id.alertCheckbox);
            this.mainLayout = (RelativeLayout)view.findViewById(R.id.main_layout);
            this.mainLayout.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    int n = ViewHolder.this.getAdapterPosition();
                    if (MultiSpinnerSearch.this.LIST_TYPE == 0) {
                        if (n == 0) {
                            for (int j = 0; j < MultiSpinnerSearch.this.items.size(); ++j) {
                                ((Tag)MultiSpinnerSearch.this.items.get(j)).setSelected(!((Tag)MultiSpinnerSearch.this.items.get(j)).isSelected());
                            }
                        } else {
                            ((Tag)MultiSpinnerSearch.this.items.get(n)).setSelected(!((Tag)MultiSpinnerSearch.this.items.get(n)).isSelected());
                            if (!((Tag)MultiSpinnerSearch.this.items.get(n)).isSelected()) {
                                ((Tag)MultiSpinnerSearch.this.items.get(0)).setSelected(false);
                            } else {
                                for (int j = 1; j < MultiSpinnerSearch.this.items.size(); ++j) {
                                    if (!((Tag)MultiSpinnerSearch.this.items.get(j)).isSelected()) {
                                        ((Tag)MultiSpinnerSearch.this.items.get(0)).setSelected(false);
                                        break;
                                    }
                                    ((Tag)MultiSpinnerSearch.this.items.get(0)).setSelected(true);
                                }
                            }
                        }
                        MultiSpinnerSearch.this.teamAdapter.notifyDataSetChanged();
                    }
                }
            });
        }
    }

    public class FleetListAdapter
    extends RecyclerView.Adapter<ViewHolder> {
        private List<User> arrayList;
        private LayoutInflater inflater;

        public FleetListAdapter(Context context, List<User> list) {
            this.arrayList = list;
            this.inflater = LayoutInflater.from((Context)context);
        }

        public ViewHolder onCreateViewHolder(ViewGroup viewGroup, int n) {
            View view = this.inflater.inflate(R.layout.hippo_textview_for_spinner, viewGroup, false);
            return new ViewHolder(view);
        }

        public void onBindViewHolder(ViewHolder viewHolder, int n) {
            User user = this.arrayList.get(n);
            viewHolder.textView.setText((CharSequence)user.getFullName());
            viewHolder.textView.setTypeface(null, 0);
            viewHolder.checkBox.setChecked(user.isSelected());
        }

        public int getItemCount() {
            return this.arrayList == null ? 0 : this.arrayList.size();
        }
    }

    public class ListAdapter
    extends RecyclerView.Adapter<ViewHolder> {
        private List<Tag> arrayList;
        private LayoutInflater inflater;

        public ListAdapter(Context context, List<Tag> list) {
            this.arrayList = list;
            this.inflater = LayoutInflater.from((Context)context);
        }

        public ViewHolder onCreateViewHolder(ViewGroup viewGroup, int n) {
            View view = this.inflater.inflate(R.layout.hippo_textview_for_spinner, viewGroup, false);
            return new ViewHolder(view);
        }

        public void onBindViewHolder(ViewHolder viewHolder, int n) {
            Tag tag = this.arrayList.get(n);
            viewHolder.textView.setText((CharSequence)tag.getTagName());
            viewHolder.textView.setTypeface(null, 0);
            viewHolder.checkBox.setChecked(tag.isSelected());
        }

        public int getItemCount() {
            return this.arrayList == null ? 0 : this.arrayList.size();
        }
    }
}

