/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.agent;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.style.ForegroundColorSpan;
import android.text.style.RelativeSizeSpan;
import android.text.style.StyleSpan;
import android.util.Log;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.Toolbar;
import androidx.fragment.app.Fragment;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import androidx.viewpager.widget.ViewPager;
import com.google.android.material.tabs.TabLayout;
import com.google.gson.Gson;
import com.hippo.HippoColorConfig;
import com.hippo.HippoConfig;
import com.hippo.R;
import com.hippo.agent.AgentBaseActivity;
import com.hippo.agent.AgentBroadcastActivity;
import com.hippo.agent.AgentChatActivity;
import com.hippo.agent.AgentConnectionManager;
import com.hippo.agent.Util.ConversationMode;
import com.hippo.agent.Util.FragmentType;
import com.hippo.agent.adapter.PagerAdapter;
import com.hippo.agent.database.AgentCommonData;
import com.hippo.agent.fragment.AllChatFragment;
import com.hippo.agent.fragment.MyChatFragment;
import com.hippo.agent.listeners.AgentConnectionListener;
import com.hippo.agent.listeners.UnreadListener;
import com.hippo.agent.model.GetConversationResponse;
import com.hippo.agent.model.LoginModel.UserData;
import com.hippo.agent.model.getConversationResponse.Conversation;
import com.hippo.database.CommonData;
import com.hippo.retrofit.APIError;
import com.hippo.retrofit.CommonParams;
import com.hippo.retrofit.ResponseResolver;
import com.hippo.retrofit.RestClient;
import com.hippo.utils.HippoLog;
import com.hippo.utils.loadingBox.LoadingBox;
import com.hippo.utils.loadingBox.ProgressWheel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import retrofit2.Callback;

public class AgentListActivity
extends AgentBaseActivity
implements AgentConnectionListener {
    private static final String TAG = AgentListActivity.class.getSimpleName();
    private TabLayout tabLayout;
    private ViewPager viewPager;
    private PagerAdapter pagerAdapter;
    ArrayList<Fragment> pagerFragments = new ArrayList();
    String[] titles = new String[2];
    public UserData userData;
    private HippoColorConfig hippoColorConfig;
    private TextView tvPoweredBy;
    private LinearLayout fragmentView;
    private boolean skipFirstResume;
    private ImageView ivViewInfo;
    private ImageView ivViewBroadcast;
    private Toolbar myToolbar;
    private LinearLayout retryLayout;
    private TextView btnRetry;
    private ProgressWheel progressWheel;
    private int[] typeIntArray = new int[]{ConversationMode.DEFAULT.getOrdinal()};
    public boolean myChatFlag;
    public boolean allChatFlag;
    private BroadcastReceiver mMessageReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            switch (intent.getAction()) {
                case "network_state_changed": {
                    HippoLog.d(TAG, "Network connectivity change " + intent.getBooleanExtra("isConnected", false));
                    if (!intent.getBooleanExtra("isConnected", false)) break;
                    AgentConnectionManager.getInstance().setNetworkStatus(true);
                    AgentListActivity.this.setConnectionManager();
                }
            }
        }
    };

    @Override
    protected void onCreate(@Nullable Bundle bundle) {
        super.onCreate(bundle);
        this.setContentView(R.layout.hippo_activity_chatlist);
        HippoConfig.getInstance().setChannelActivity(true);
        this.setConnectionManager();
        this.initView();
        LocalBroadcastManager.getInstance((Context)this).registerReceiver(this.mMessageReceiver, this.getIntentFilter());
        this.checkAutoUpload();
    }

    private void setConnectionManager() {
        this.userData = AgentCommonData.getUserData();
        AgentConnectionManager.getInstance().setUserData(this.userData);
        AgentConnectionManager.getInstance().setUpFayeConnection();
        AgentConnectionManager.getInstance().setConnectionListener(this);
    }

    private void initView() {
        this.myToolbar = (Toolbar)this.findViewById(R.id.my_toolbar);
        this.setSupportActionBar(this.myToolbar);
        this.ivViewInfo = (ImageView)this.findViewById(R.id.ivViewInfo);
        this.ivViewBroadcast = (ImageView)this.findViewById(R.id.ivViewBroadcast);
        this.ivViewInfo.setVisibility(8);
        this.btnRetry = (TextView)this.findViewById(R.id.btnRetry);
        this.progressWheel = (ProgressWheel)this.findViewById(R.id.retry_loader);
        this.retryLayout = (LinearLayout)this.findViewById(R.id.retry_layout);
        this.tvPoweredBy = (TextView)this.findViewById(R.id.tvPoweredBy);
        this.viewPager = (ViewPager)this.findViewById(R.id.view_pager);
        this.tabLayout = (TabLayout)this.findViewById(R.id.sliding_tabs);
        this.pagerFragments = new ArrayList();
        this.hippoColorConfig = CommonData.getColorConfig();
        this.fragmentView = (LinearLayout)this.findViewById(R.id.fragment_view);
        this.skipFirstResume = true;
        String string2 = "";
        if (this.getIntent().hasExtra("transaction_id")) {
            string2 = this.getIntent().getStringExtra("transaction_id");
        }
        if (this.getIntent().hasExtra("user_unique_key")) {
            String string3 = this.getIntent().getStringExtra("user_unique_key");
            this.openUserUniqueChat(string3, string2);
        } else {
            this.openPagerScreen();
        }
        this.setTabColor();
        this.setPoweredByText();
        this.ivViewBroadcast.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Intent intent = new Intent((Context)AgentListActivity.this, AgentBroadcastActivity.class);
                intent.putExtra("title", "Broadcast Message");
                AgentListActivity.this.startActivity(intent);
            }
        });
    }

    private void openPagerScreen() {
        this.setToolbar(this.myToolbar, AgentCommonData.getMainTitle());
        this.fragmentView.setVisibility(8);
        this.ivViewInfo.setVisibility(8);
        this.ivViewBroadcast.setImageResource(R.drawable.hippo_ic_broadcast);
        try {
            if (CommonData.getAttributes().isBroadcastEnabled()) {
                this.ivViewBroadcast.setVisibility(0);
            } else {
                this.ivViewBroadcast.setVisibility(8);
            }
        }
        catch (Exception exception) {
            this.ivViewBroadcast.setVisibility(8);
        }
        this.viewPager.setVisibility(0);
        this.tabLayout.setVisibility(0);
        this.pagerFragments = new ArrayList();
        AgentCommonData.clearTotalUnreadCount();
        boolean bl = AgentCommonData.getPagerOrder();
        if (bl) {
            this.pagerFragments.add(new AllChatFragment());
            this.pagerFragments.add(new MyChatFragment());
            this.titles[0] = "All Chat";
            this.titles[1] = "My Chat";
        } else {
            this.pagerFragments.add(new MyChatFragment());
            this.pagerFragments.add(new AllChatFragment());
            this.titles[0] = "My Chat";
            this.titles[1] = "All Chat";
        }
        this.pagerAdapter = new PagerAdapter(this.getSupportFragmentManager(), this.pagerFragments, this.titles);
        this.viewPager.setAdapter((androidx.viewpager.widget.PagerAdapter)this.pagerAdapter);
        this.tabLayout.setupWithViewPager(this.viewPager);
    }

    private void setTabColor() {
        this.tabLayout.setSelectedTabIndicatorColor(this.hippoColorConfig.getHippoSelectedTabIndicatorColor());
        this.tabLayout.setTabTextColors(this.hippoColorConfig.getHippoTabTextColor(), this.hippoColorConfig.getHippoTabSelectedTextColor());
    }

    protected void onStart() {
        super.onStart();
    }

    protected void onStop() {
        super.onStop();
    }

    @Override
    protected void onResume() {
        super.onResume();
        if (!this.skipFirstResume) {
            AgentConnectionManager.getInstance().onRefreshData();
        }
        this.skipFirstResume = false;
    }

    @Override
    protected void onPause() {
        super.onPause();
        this.skipFirstResume = false;
    }

    public void onBackPressed() {
        super.onBackPressed();
    }

    protected void onDestroy() {
        for (UnreadListener unreadListener : HippoConfig.getInstance().getUIListeners(UnreadListener.class)) {
            if (unreadListener == null) continue;
            unreadListener.sendTotalUnreadCount();
            unreadListener.getUnreadCount();
        }
        HippoConfig.getInstance().setChannelActivity(false);
        AgentConnectionManager.getInstance().onDestroy();
        LocalBroadcastManager.getInstance((Context)this).unregisterReceiver(this.mMessageReceiver);
        super.onDestroy();
    }

    private void openUserUniqueChat(final String string2, String string3) {
        this.setToolbar(this.myToolbar, "");
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string2);
        if (this.userData == null) {
            this.userData = AgentCommonData.getUserData();
        }
        if (!this.isNetworkAvailable()) {
            this.setToolbar(this.myToolbar, this.getIntent().getStringExtra("title"));
            return;
        }
        LoadingBox.showOn((Activity)this);
        String string4 = String.valueOf(this.userData.getEnUserId());
        String string5 = this.userData.getAccessToken();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("en_user_id", string4);
        hashMap.put("access_token", string5);
        hashMap.put("status", "[1]");
        hashMap.put("device_type", 1);
        hashMap.put("type", Arrays.toString(this.typeIntArray));
        hashMap.put("search_user_unique_key", new Gson().toJson(arrayList));
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            hashMap.put("transaction_id", string3);
        }
        CommonParams commonParams = new CommonParams.Builder().addAll(hashMap).build(2);
        RestClient.getAgentApiInterface().getConversation(commonParams.getMap()).enqueue((Callback)new ResponseResolver<GetConversationResponse>(){

            @Override
            public void success(GetConversationResponse getConversationResponse) {
                AgentListActivity.this.fragmentView.setVisibility(0);
                AgentListActivity.this.viewPager.setVisibility(8);
                AgentListActivity.this.tabLayout.setVisibility(8);
                LoadingBox.hide();
                ArrayList arrayList = (ArrayList)getConversationResponse.getData().getConversation();
                if (arrayList != null && arrayList.size() == 0) {
                    AgentListActivity.this.openp2pConversation(string2, AgentListActivity.this.getIntent().getStringExtra("title"));
                } else if (arrayList != null && arrayList.size() == 1) {
                    Conversation conversation = (Conversation)arrayList.get(0);
                    Intent intent = new Intent((Context)AgentListActivity.this, AgentChatActivity.class);
                    intent.putExtra("conversation", new Gson().toJson((Object)conversation, Conversation.class));
                    intent.putExtra("create_chat", true);
                    intent.putExtra("fragment_type", FragmentType.USER_CHAT.getOrdinal());
                    AgentListActivity.this.startActivity(intent);
                    AgentListActivity.this.overridePendingTransition(0, 0);
                    AgentListActivity.this.finish();
                } else {
                    AgentListActivity.this.setToolbar(AgentListActivity.this.myToolbar, AgentListActivity.this.getIntent().getStringExtra("title"));
                    String string22 = new Gson().toJson((Object)getConversationResponse, GetConversationResponse.class);
                    MyChatFragment myChatFragment = new MyChatFragment();
                    Bundle bundle = new Bundle();
                    int n = FragmentType.USER_CHAT.getOrdinal();
                    bundle.putString("user_unique_key", string2);
                    bundle.putString("conversation", string22);
                    bundle.putInt("fragment_type", n);
                    myChatFragment.setArguments(bundle);
                    AgentListActivity.this.getSupportFragmentManager().beginTransaction().add(R.id.fragment_view, (Fragment)myChatFragment, MyChatFragment.class.getName()).commitAllowingStateLoss();
                    AgentListActivity.this.ivViewInfo.setVisibility(0);
                    AgentListActivity.this.ivViewBroadcast.setVisibility(8);
                    AgentListActivity.this.ivViewInfo.setImageResource(R.drawable.ic_hippo_chat_info);
                    AgentListActivity.this.ivViewInfo.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View view) {
                            AgentListActivity.this.openPagerScreen();
                            AgentListActivity.this.ivViewInfo.setVisibility(8);
                        }
                    });
                }
            }

            @Override
            public void failure(APIError aPIError) {
                LoadingBox.hide();
                Log.e((String)TAG, (String)("Error: " + aPIError.getMessage()));
            }
        });
    }

    private void setPoweredByText() {
        UserData userData = AgentCommonData.getUserData();
        this.tvPoweredBy.setVisibility(8);
    }

    private void poweredByView(String string2, String string3, HippoColorConfig hippoColorConfig) throws Exception {
        String string4 = string3 != null ? string3 : "Hippo";
        String string5 = string2 + " " + string4;
        Log.v((String)TAG, (String)("totalString = " + string5));
        SpannableString spannableString = new SpannableString((CharSequence)string5);
        spannableString.setSpan((Object)new StyleSpan(1), String.valueOf(string2).length(), string5.length(), 0);
        spannableString.setSpan((Object)new ForegroundColorSpan(hippoColorConfig.getFuguRunsOnColor()), String.valueOf(string2).length(), string5.length(), 0);
        spannableString.setSpan((Object)new RelativeSizeSpan(0.8f), 0, String.valueOf(string2).length(), 0);
        this.tvPoweredBy.setText((CharSequence)spannableString);
        this.tvPoweredBy.setBackgroundDrawable((Drawable)HippoColorConfig.makeSelector(hippoColorConfig.getHippoChannelItemBg(), hippoColorConfig.getHippoChannelItemBgPressed()));
    }

    private void openp2pConversation(String string2, String string3) {
        Conversation conversation = new Conversation();
        conversation.setChannelId(-1L);
        conversation.setChannelName("dummyChannelName");
        conversation.setStatus(-2);
        conversation.setAgentId(-2);
        conversation.setUserUniqueKeys(string2);
        conversation.setLabel(string3);
        conversation.setUnreadCount(0);
        Intent intent = new Intent((Context)this, AgentChatActivity.class);
        intent.putExtra("conversation", new Gson().toJson((Object)conversation, Conversation.class));
        intent.putExtra("create_chat", true);
        intent.putExtra("fragment_type", FragmentType.USER_CHAT.getOrdinal());
        this.startActivity(intent);
        this.overridePendingTransition(0, 0);
        this.finish();
    }

    public void setConnectionMessage(int n) {
        if (this.isNetworkAvailable()) {
            switch (n) {
                case 0: {
                    this.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            AgentListActivity.this.retryLayout.setVisibility(8);
                        }
                    });
                    break;
                }
                case 1: {
                    this.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            AgentListActivity.this.retryLayout.setVisibility(0);
                            AgentListActivity.this.progressWheel.setVisibility(0);
                            AgentListActivity.this.btnRetry.setText((CharSequence)AgentListActivity.this.getString(R.string.hippo_fetching_messages));
                            AgentListActivity.this.retryLayout.setBackgroundColor(AgentListActivity.this.hippoColorConfig.getHippoConnected());
                        }
                    });
                    break;
                }
                case 2: {
                    this.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            AgentListActivity.this.retryLayout.setVisibility(0);
                            AgentListActivity.this.progressWheel.setVisibility(8);
                            AgentListActivity.this.btnRetry.setText((CharSequence)AgentListActivity.this.getString(R.string.hippo_server_disconnect));
                            AgentListActivity.this.retryLayout.setBackgroundColor(AgentListActivity.this.hippoColorConfig.getHippoNotConnected());
                        }
                    });
                    break;
                }
                case 3: {
                    this.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            AgentListActivity.this.retryLayout.setVisibility(0);
                            AgentListActivity.this.progressWheel.setVisibility(8);
                            AgentListActivity.this.btnRetry.setText((CharSequence)AgentListActivity.this.getString(R.string.hippo_no_network_connected));
                            AgentListActivity.this.retryLayout.setBackgroundColor(AgentListActivity.this.hippoColorConfig.getHippoNotConnected());
                        }
                    });
                    break;
                }
                case 4: {
                    this.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            AgentListActivity.this.retryLayout.setVisibility(0);
                            AgentListActivity.this.progressWheel.setVisibility(8);
                            AgentListActivity.this.btnRetry.setText((CharSequence)AgentListActivity.this.getString(R.string.hippo_server_connecting));
                            AgentListActivity.this.retryLayout.setBackgroundColor(AgentListActivity.this.hippoColorConfig.getHippoConnected());
                        }
                    });
                    break;
                }
            }
        } else {
            this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    AgentListActivity.this.retryLayout.setVisibility(0);
                    AgentListActivity.this.progressWheel.setVisibility(8);
                    AgentListActivity.this.btnRetry.setText((CharSequence)AgentListActivity.this.getString(R.string.hippo_no_network_connected));
                    AgentListActivity.this.retryLayout.setBackgroundColor(AgentListActivity.this.hippoColorConfig.getHippoNotConnected());
                }
            });
        }
    }

    @Override
    public void onConnectionStatus(String string2, int n) {
        if (n == 0 && !this.myChatFlag && !this.allChatFlag) {
            this.setConnectionMessage(n);
        } else {
            this.setConnectionMessage(n);
        }
    }

    private IntentFilter getIntentFilter() {
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("network_state_changed");
        return intentFilter;
    }

    public void hideLoader(int n) {
        if (n == 1) {
            this.myChatFlag = true;
        }
        if (n == 2) {
            this.allChatFlag = true;
        }
        if (this.myChatFlag && this.allChatFlag) {
            this.setConnectionMessage(0);
        }
    }
}

