/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.agent;

import android.os.Handler;
import android.os.HandlerThread;
import android.text.TextUtils;
import com.hippo.HippoConfig;
import com.hippo.agent.listeners.AgentConnectionListener;
import com.hippo.agent.listeners.OnUserChannelListener;
import com.hippo.agent.model.LoginModel.UserData;
import com.hippo.database.CommonData;
import com.hippo.utils.HippoLog;
import faye.FayeAgentListener;
import faye.FayeClient;
import faye.MetaMessage;
import org.json.JSONException;
import org.json.JSONObject;

public class AgentConnectionManager
implements FayeAgentListener {
    private static final String TAG = AgentConnectionManager.class.getSimpleName();
    public static AgentConnectionManager instance;
    private UserData userData;
    private MetaMessage meta = new MetaMessage();
    private FayeClient mClient;
    private AgentConnectionListener connectionListener;
    private Handler handler = new Handler();
    private static final Integer RECONNECTION_TIME;
    private boolean networkStatus = true;
    boolean firstTimeSkip = false;
    boolean fayeDisconnect = true;
    boolean fayeConnecting = false;
    Runnable runnable = new Runnable(){

        @Override
        public void run() {
            try {
                if (AgentConnectionManager.this.fayeDisconnect) {
                    AgentConnectionManager.this.connectAgainToServer();
                    if (AgentConnectionManager.this.connectionListener != null) {
                        AgentConnectionManager.this.connectionListener.onConnectionStatus("Server connecting...", 1);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    };

    public void setConnectionListener(AgentConnectionListener agentConnectionListener) {
        this.connectionListener = agentConnectionListener;
    }

    private AgentConnectionManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static AgentConnectionManager getInstance() {
        if (instance != null) return instance;
        Class<AgentConnectionManager> clazz = AgentConnectionManager.class;
        synchronized (AgentConnectionManager.class) {
            if (instance != null) return instance;
            instance = new AgentConnectionManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void onDestroy() {
        this.stopFayeClient();
        this.userData = null;
        this.firstTimeSkip = false;
    }

    public void stopFayeClient() {
        try {
            HandlerThread handlerThread = new HandlerThread("TerminateThread");
            handlerThread.start();
            new Handler(handlerThread.getLooper()).post(new Runnable(){

                @Override
                public void run() {
                    AgentConnectionManager.this.handler.removeCallbacks(AgentConnectionManager.this.runnable);
                    if (AgentConnectionManager.this.mClient != null && AgentConnectionManager.this.mClient.isConnectedServer()) {
                        AgentConnectionManager.this.mClient.disconnectServer();
                    }
                    AgentConnectionManager.this.mClient = null;
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setUserData(UserData userData) {
        this.userData = userData;
    }

    public void setUpFayeConnection() {
        if (this.mClient == null) {
            this.meta = new MetaMessage();
            JSONObject jSONObject = new JSONObject();
            try {
                if (this.userData != null) {
                    jSONObject.put("user_id", (Object)this.userData.getUserId());
                    jSONObject.put("device_type", 1);
                    jSONObject.put("source", 2);
                }
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
            this.meta.setAllExt(jSONObject.toString());
            this.mClient = CommonData.getServerUrl().equals("https://api.hippochat.io") ? new FayeClient(CommonData.getServerUrl() + ":3002/faye", this.meta) : (CommonData.getServerUrl().equals("https://hippo-api-dev.fuguchat.com:3002") || CommonData.getServerUrl().equals("https://beta-live-api.fuguchat.com") ? new FayeClient("https://hippo-api-dev.fuguchat.com:3002/faye", this.meta) : (CommonData.getServerUrl().equals("https://hippo-api-dev.fuguchat.com:3011") ? new FayeClient("https://hippo-api-dev.fuguchat.com:3012/faye", this.meta) : (CommonData.getServerUrl().equals("https://beta-hippo.fuguchat.com") ? new FayeClient("https://beta-hippo.fuguchat.com:3001/faye", this.meta) : new FayeClient("https://api.hippochat.io:3002/faye", this.meta))));
        }
        this.mClient.setAgentListener(this);
        this.mClient.connectServer();
    }

    @Override
    public void onConnectedServer(FayeClient fayeClient2) {
        HippoLog.v(TAG, "******************** in onConnectedServer ***********");
        this.handler.removeCallbacks(this.runnable);
        if (this.userData != null && !TextUtils.isEmpty((CharSequence)this.userData.getUserChannel())) {
            fayeClient2.subscribeChannel("/" + String.valueOf(this.userData.getUserChannel()));
        }
        if (this.connectionListener != null) {
            this.connectionListener.onConnectionStatus("Connected", 0);
        }
        if (this.firstTimeSkip) {
            for (OnUserChannelListener onUserChannelListener : HippoConfig.getInstance().getUIListeners(OnUserChannelListener.class)) {
                if (onUserChannelListener == null) continue;
                onUserChannelListener.onRefreshData();
            }
        }
        this.firstTimeSkip = true;
    }

    @Override
    public void onDisconnectedServer(FayeClient fayeClient2) {
        this.fayeDisconnect = true;
        try {
            if (this.getNetworkStatus() && this.fayeConnecting) {
                this.handler.postDelayed(this.runnable, (long)RECONNECTION_TIME.intValue());
            }
            if (this.connectionListener != null) {
                this.connectionListener.onConnectionStatus("Server disconnected", 2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void onReceivedMessage(FayeClient fayeClient2, String string2, String string3) {
        try {
            HippoLog.v(TAG, "User channel Message: " + string2);
            JSONObject jSONObject = new JSONObject(string2);
            if (jSONObject.optInt("notification_type") == 1) {
                for (OnUserChannelListener onUserChannelListener : HippoConfig.getInstance().getUIListeners(OnUserChannelListener.class)) {
                    if (onUserChannelListener != null) {
                        onUserChannelListener.onControlChannelData(jSONObject);
                    }
                    HippoLog.v(TAG, "msg = " + string2);
                }
                return;
            }
            if (jSONObject.optInt("notification_type") == 3) {
                for (OnUserChannelListener onUserChannelListener : HippoConfig.getInstance().getUIListeners(OnUserChannelListener.class)) {
                    if (onUserChannelListener == null) continue;
                    onUserChannelListener.onAssignChat(jSONObject);
                }
                return;
            }
            if (jSONObject.optInt("notification_type") == 11 || jSONObject.optInt("notification_type") == 10) {
                this.onRefreshData();
                return;
            }
            if (jSONObject.optInt("notification_type") != 6) return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void onPongReceived() {
        if (this.connectionListener != null) {
            this.connectionListener.onConnectionStatus("Connected", 0);
        }
    }

    @Override
    public void onWebSocketError() {
        this.fayeDisconnect = true;
        try {
            if (this.getNetworkStatus() && this.fayeConnecting) {
                this.handler.postDelayed(this.runnable, (long)RECONNECTION_TIME.intValue());
            }
            if (this.connectionListener != null) {
                this.connectionListener.onConnectionStatus("Server disconnected", 2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onRefreshData() {
        for (OnUserChannelListener onUserChannelListener : HippoConfig.getInstance().getUIListeners(OnUserChannelListener.class)) {
            if (onUserChannelListener == null) continue;
            onUserChannelListener.onRefreshData();
        }
    }

    private void connectAgainToServer() throws Exception {
        if (!this.fayeConnecting) {
            this.fayeConnecting = true;
            this.handler.removeCallbacks(this.runnable);
            this.mClient.setAgentListener(this);
            this.mClient.connectServer();
        }
        HandlerThread handlerThread = new HandlerThread("FayeReconnect");
        handlerThread.start();
        try {
            new Handler(handlerThread.getLooper()).postDelayed(new Runnable(){

                @Override
                public void run() {
                    AgentConnectionManager.this.fayeConnecting = false;
                }
            }, 2000L);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.fayeConnecting = false;
        }
    }

    public void setNetworkStatus(boolean bl) {
        this.networkStatus = bl;
    }

    public boolean getNetworkStatus() {
        return this.networkStatus;
    }

    static {
        RECONNECTION_TIME = 2500;
    }
}

