/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.agent;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.Toolbar;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.hippo.R;
import com.hippo.agent.AgentBaseActivity;
import com.hippo.agent.Util.DialogPop;
import com.hippo.agent.Util.MessageMode;
import com.hippo.agent.Util.PhoneFunctions;
import com.hippo.agent.Util.TagContainerLayout;
import com.hippo.agent.database.AgentCommonData;
import com.hippo.agent.model.ApiResponseFlags;
import com.hippo.agent.model.GetConversationResponse;
import com.hippo.agent.model.TagData;
import com.hippo.agent.model.getConversationResponse.Conversation;
import com.hippo.agent.model.user_details.UserDetailsResponse;
import com.hippo.retrofit.APIError;
import com.hippo.retrofit.CommonParams;
import com.hippo.retrofit.ResponseResolver;
import com.hippo.retrofit.RestClient;
import com.hippo.utils.DateUtils;
import com.hippo.utils.HippoLog;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import retrofit2.Callback;

public class AgentChatOptions
extends AgentBaseActivity {
    private static final String TAG = AgentChatOptions.class.getSimpleName();
    private RelativeLayout rlAgentName;
    private RelativeLayout rlTag;
    private TextView tvCloseConversation;
    private TextView agentName;
    private TextView tvCustomerName;
    private TextView tvCustomerActivationTime;
    private TextView etCustomerEmail;
    private TextView etCustomerPhone;
    private TextView tvCustomAttributes;
    private TextView etCustomerLocation;
    private View viewCustomerDetails;
    private TagContainerLayout tagLayout;
    private LinearLayout llName;
    private LinearLayout llOtherView;
    private ImageView ivCustomerImage;
    private Conversation conversation;
    private ArrayList<TagData> tagData = new ArrayList();
    private Type listType = new TypeToken<List<TagData>>(){}.getType();
    boolean isO2OChat;
    public ArrayList<String> tagList = new ArrayList();
    public ArrayList<Integer> colorsTag = new ArrayList();
    private int status;

    @Override
    protected void onCreate(@Nullable Bundle bundle) {
        super.onCreate(bundle);
        this.setContentView(R.layout.hippo_activity_agent_detail);
        this.initView();
        this.conversation = (Conversation)new Gson().fromJson(this.getIntent().getStringExtra("conversation"), Conversation.class);
        this.tagData = (ArrayList)new Gson().fromJson(this.getIntent().getStringExtra("tag_data"), this.listType);
        this.isO2OChat = this.getIntent().getBooleanExtra("is_o2o_chat", false);
        if (this.isO2OChat) {
            this.llOtherView.setVisibility(8);
        }
        if (this.conversation.getStatus() != null) {
            this.status = this.conversation.getStatus().equals(MessageMode.OPEN_CHAT.getOrdinal()) ? MessageMode.CLOSED_CHAT.getOrdinal() : MessageMode.OPEN_CHAT.getOrdinal();
        }
        Toolbar toolbar = (Toolbar)this.findViewById(R.id.my_toolbar);
        this.setSupportActionBar(toolbar);
        this.setToolbar(toolbar, "Info");
        this.setData();
    }

    private void initView() {
        this.tvCloseConversation = (TextView)this.findViewById(R.id.tvCloseConversation);
        this.rlAgentName = (RelativeLayout)this.findViewById(R.id.rlAgentName);
        this.agentName = (TextView)this.findViewById(R.id.tvAgentName);
        this.rlTag = (RelativeLayout)this.findViewById(R.id.rlTag);
        this.tagLayout = (TagContainerLayout)this.findViewById(R.id.tagLayout);
        this.tagLayout.setBackgroundColor(-1);
        this.tagLayout.setTagTextColor(-1);
        this.llName = (LinearLayout)this.findViewById(R.id.llName);
        this.llOtherView = (LinearLayout)this.findViewById(R.id.llOtherView);
        this.tvCustomerName = (TextView)this.findViewById(R.id.tvCustomerName);
        this.tvCustomerActivationTime = (TextView)this.findViewById(R.id.tvCustomerActivationTime);
        this.ivCustomerImage = (ImageView)this.findViewById(R.id.ivCustomerImage);
        this.etCustomerEmail = (TextView)this.findViewById(R.id.etCustomerEmail);
        this.etCustomerPhone = (TextView)this.findViewById(R.id.etCustomerPhone);
        this.tvCustomAttributes = (TextView)this.findViewById(R.id.tvCustomAttributes);
        this.etCustomerLocation = (TextView)this.findViewById(R.id.etCustomerLocation);
        this.viewCustomerDetails = this.findViewById(R.id.viewCustomerDetails);
        this.etCustomerEmail.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                AgentChatOptions.this.goToGmail(AgentChatOptions.this.etCustomerEmail.getText().toString());
            }
        });
        this.etCustomerPhone.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                AgentChatOptions.this.goToPhone(AgentChatOptions.this.etCustomerPhone.getText().toString());
            }
        });
    }

    private void setData() {
        this.agentName.setText((CharSequence)this.conversation.getAgentName());
        if (this.conversation.getStatus().equals(MessageMode.OPEN_CHAT.getOrdinal())) {
            this.tvCloseConversation.setText((CharSequence)this.getResources().getString(R.string.fugu_close_conversation));
        } else {
            this.tvCloseConversation.setText((CharSequence)this.getResources().getString(R.string.fugu_reopen_conversation));
        }
        this.tvCloseConversation.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                AgentChatOptions.this.performMarkConversation();
            }
        });
        this.setTags();
        this.setChannelData();
    }

    private void setChannelData() {
        String string2 = this.conversation.getCustomerName();
        String string3 = this.conversation.getCustomerPhone();
        String string4 = this.conversation.getCustomerEmail();
        if (TextUtils.isEmpty((CharSequence)string2) && TextUtils.isEmpty((CharSequence)string3) && TextUtils.isEmpty((CharSequence)string4)) {
            if (this.conversation.getUserId() != null && this.conversation.getUserId() > 0) {
                this.getUserData();
            }
            return;
        }
        this.tvCustomerName.setText((CharSequence)string2);
        if (TextUtils.isEmpty((CharSequence)string3)) {
            this.etCustomerPhone.setVisibility(8);
        } else {
            String string5;
            this.etCustomerPhone.setVisibility(0);
            this.etCustomerPhone.setText((CharSequence)string3);
            PhoneFunctions phoneFunctions = new PhoneFunctions();
            String string6 = "";
            if (string3.substring(0, 1).equals("+")) {
                string6 = string3.substring(1, string3.length());
            }
            if ((string5 = phoneFunctions.getCountry(this.getResources().getStringArray(R.array.FuguCountryCodes), string6)) != null && !string5.isEmpty()) {
                this.etCustomerPhone.setText((CharSequence)("+" + string5 + "-" + string3.substring(string5.length() + 1)));
            }
        }
        if (TextUtils.isEmpty((CharSequence)string4)) {
            this.etCustomerEmail.setVisibility(8);
        } else {
            this.etCustomerEmail.setVisibility(0);
            this.etCustomerEmail.setText((CharSequence)string4);
        }
        if (TextUtils.isEmpty((CharSequence)string3) && TextUtils.isEmpty((CharSequence)string4)) {
            this.viewCustomerDetails.setVisibility(8);
        }
    }

    public void setTags() {
        if (this.tagData == null || this.tagData.size() == 0) {
            this.tagLayout.setVisibility(8);
        } else {
            this.tagLayout.setVisibility(0);
        }
        this.tagLayout.removeAllTags();
        for (int j = 0; j < this.tagData.size(); ++j) {
            this.tagList.add(this.tagData.get(j).getTag_name());
            this.colorsTag.add(Color.parseColor((String)this.tagData.get(j).getColor_code().toLowerCase()));
        }
        this.tagLayout.setTags(this.tagList, this.colorsTag);
    }

    @Override
    protected void onResume() {
        super.onResume();
    }

    @Override
    protected void onPause() {
        super.onPause();
    }

    protected void onStart() {
        super.onStart();
    }

    protected void onStop() {
        super.onStop();
    }

    public void onBackPressed() {
        super.onBackPressed();
    }

    private void goToGmail(String string2) {
        Intent intent = new Intent("android.intent.action.SENDTO", Uri.fromParts((String)"mailto", (String)string2, null));
        this.startActivity(Intent.createChooser((Intent)intent, (CharSequence)"Send email..."));
    }

    private void goToPhone(String string2) {
        try {
            Intent intent = new Intent("android.intent.action.DIAL");
            intent.setData(Uri.parse((String)("tel:" + string2)));
            this.startActivity(intent);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void onDestroy() {
        super.onDestroy();
    }

    private void getUserData() {
        if (this.isNetworkAvailable()) {
            CommonParams commonParams = new CommonParams.Builder().add("access_token", AgentCommonData.getUserData().getAccessToken()).add("user_id", this.conversation.getUserId()).build(2);
            RestClient.getAgentApiInterface().getUserDetails(commonParams.getMap()).enqueue((Callback)new ResponseResolver<UserDetailsResponse>((Activity)this, Boolean.valueOf(true), Boolean.valueOf(true)){

                @Override
                public void success(UserDetailsResponse userDetailsResponse) {
                    try {
                        AgentChatOptions.this.tvCustomerName.setText((CharSequence)userDetailsResponse.getData().get(0).getFullName());
                        TextView textView = AgentChatOptions.this.tvCustomerActivationTime;
                        StringBuilder stringBuilder = new StringBuilder().append("Active ");
                        DateUtils.getInstance();
                        textView.setText((CharSequence)stringBuilder.append(DateUtils.getTimeToDisplay(userDetailsResponse.getData().get(0).getLastSeen())).toString());
                        if (userDetailsResponse.getData().get(0).getPhoneNumber() == null || userDetailsResponse.getData().get(0).getPhoneNumber().isEmpty() || userDetailsResponse.getData().get(0).getPhoneNumber().equals("")) {
                            AgentChatOptions.this.etCustomerPhone.setVisibility(8);
                        } else {
                            String string2;
                            AgentChatOptions.this.etCustomerPhone.setVisibility(0);
                            AgentChatOptions.this.etCustomerPhone.setText((CharSequence)userDetailsResponse.getData().get(0).getPhoneNumber());
                            PhoneFunctions phoneFunctions = new PhoneFunctions();
                            String string3 = "";
                            if (userDetailsResponse.getData().get(0).getPhoneNumber().substring(0, 1).equals("+")) {
                                string3 = userDetailsResponse.getData().get(0).getPhoneNumber().substring(1, userDetailsResponse.getData().get(0).getPhoneNumber().length());
                            }
                            if ((string2 = phoneFunctions.getCountry(AgentChatOptions.this.getResources().getStringArray(R.array.FuguCountryCodes), string3)) != null && !string2.isEmpty()) {
                                AgentChatOptions.this.etCustomerPhone.setText((CharSequence)("+" + string2 + "-" + userDetailsResponse.getData().get(0).getPhoneNumber().substring(string2.length() + 1)));
                            }
                        }
                        if (userDetailsResponse.getData().get(0).getEmail() == null || userDetailsResponse.getData().get(0).getEmail().isEmpty() || userDetailsResponse.getData().get(0).getEmail().equals("")) {
                            AgentChatOptions.this.etCustomerEmail.setVisibility(8);
                        } else {
                            AgentChatOptions.this.etCustomerEmail.setVisibility(0);
                            AgentChatOptions.this.etCustomerEmail.setText((CharSequence)userDetailsResponse.getData().get(0).getEmail());
                        }
                        if ((userDetailsResponse.getData().get(0).getPhoneNumber() == null || userDetailsResponse.getData().get(0).getPhoneNumber().isEmpty() || userDetailsResponse.getData().get(0).getPhoneNumber().equals("")) && (userDetailsResponse.getData().get(0).getEmail() == null || userDetailsResponse.getData().get(0).getEmail().isEmpty() || userDetailsResponse.getData().get(0).getEmail().equals(""))) {
                            AgentChatOptions.this.viewCustomerDetails.setVisibility(8);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }

                @Override
                public void failure(APIError aPIError) {
                    HippoLog.e("error", "error");
                }
            });
        } else {
            Toast.makeText((Context)this, (CharSequence)this.getString(R.string.fugu_unable_to_connect_internet), (int)0).show();
        }
    }

    private void performMarkConversation() {
        String string2 = this.status == MessageMode.OPEN_CHAT.getOrdinal() ? this.getResources().getString(R.string.fugu_reopen_chat_message) : this.getResources().getString(R.string.fugu_close_chat_message);
        String string3 = this.status == MessageMode.OPEN_CHAT.getOrdinal() ? this.getResources().getString(R.string.fugu_reopen_caps) : this.getResources().getString(R.string.fugu_close);
        DialogPop dialogPop = new DialogPop();
        dialogPop.alertPopupWithTwoButton((Context)this, "", string2, string3, this.getResources().getString(R.string.fugu_cancel), new DialogPop.Callback(){

            @Override
            public void onPositiveClick() {
                AgentChatOptions.this.apiMarkConversation();
            }

            @Override
            public void onNegativeClick() {
            }
        });
    }

    private void apiMarkConversation() {
        if (this.isNetworkAvailable()) {
            CommonParams.Builder builder = new CommonParams.Builder();
            builder.add("access_token", AgentCommonData.getUserData().getAccessToken());
            builder.add("channel_id", String.valueOf(this.conversation.getChannelId()));
            builder.add("en_user_id", AgentCommonData.getUserData().getEnUserId());
            builder.add("status", String.valueOf(this.status));
            builder.add("created_by", AgentCommonData.getUserData().getFullName());
            CommonParams commonParams = builder.build(2);
            RestClient.getAgentApiInterface().markConversation(commonParams.getMap()).enqueue((Callback)new ResponseResolver<GetConversationResponse>((Activity)this, Boolean.valueOf(true), Boolean.valueOf(true)){

                @Override
                public void success(GetConversationResponse getConversationResponse) {
                    try {
                        if (ApiResponseFlags.ACTION_COMPLETE.getOrdinal() == getConversationResponse.getStatusCode().intValue()) {
                            Bundle bundle = new Bundle();
                            bundle.putString("channel_id", String.valueOf(AgentChatOptions.this.conversation.getChannelId()));
                            Intent intent = new Intent();
                            intent.putExtras(bundle);
                            if (AgentChatOptions.this.conversation.getStatus().intValue() == MessageMode.OPEN_CHAT.getOrdinal()) {
                                AgentChatOptions.this.setResult(MessageMode.CLOSED_CHAT.getOrdinal(), intent);
                            } else {
                                AgentChatOptions.this.setResult(MessageMode.OPEN_CHAT.getOrdinal(), intent);
                            }
                            AgentChatOptions.this.onBackPressed();
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }

                @Override
                public void failure(APIError aPIError) {
                    HippoLog.e("error", "error");
                }
            });
        } else {
            Toast.makeText((Context)this, (CharSequence)this.getString(R.string.fugu_unable_to_connect_internet), (int)0).show();
        }
    }
}

