/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.adapter;

import android.content.Context;
import android.graphics.PorterDuff;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentStatePagerAdapter;
import com.hippo.R;
import java.util.ArrayList;
import java.util.List;

public class TabAdapter
extends FragmentStatePagerAdapter {
    private final List<Fragment> mFragmentList = new ArrayList<Fragment>();
    private final List<String> mFragmentTitleList = new ArrayList<String>();
    private final List<Integer> mFragmentIconList = new ArrayList<Integer>();
    private Context context;

    public TabAdapter(FragmentManager fragmentManager, Context context) {
        super(fragmentManager);
        this.context = context;
    }

    public Fragment getItem(int n) {
        return this.mFragmentList.get(n);
    }

    public void addFragment(Fragment fragment, String string2, int n) {
        this.mFragmentList.add(fragment);
        this.mFragmentTitleList.add(string2);
        this.mFragmentIconList.add(n);
    }

    @Nullable
    public CharSequence getPageTitle(int n) {
        return null;
    }

    public int getCount() {
        return this.mFragmentList.size();
    }

    public View getTabView(int n) {
        View view = LayoutInflater.from((Context)this.context).inflate(R.layout.custom_tab_layout, null);
        TextView textView = (TextView)view.findViewById(R.id.tabTextView);
        textView.setText((CharSequence)this.mFragmentTitleList.get(n));
        ImageView imageView = (ImageView)view.findViewById(R.id.tabImageView);
        imageView.setImageResource(this.mFragmentIconList.get(n).intValue());
        textView.setTextColor(ContextCompat.getColor((Context)this.context, (int)R.color.tabUnselectedIconColor));
        imageView.setColorFilter(ContextCompat.getColor((Context)this.context, (int)R.color.tabUnselectedIconColor), PorterDuff.Mode.SRC_ATOP);
        return view;
    }

    public View getSelectedTabView(int n) {
        View view = LayoutInflater.from((Context)this.context).inflate(R.layout.custom_tab_layout, null);
        TextView textView = (TextView)view.findViewById(R.id.tabTextView);
        textView.setText((CharSequence)this.mFragmentTitleList.get(n));
        textView.setTextColor(-16777216);
        ImageView imageView = (ImageView)view.findViewById(R.id.tabImageView);
        imageView.setImageResource(this.mFragmentIconList.get(n).intValue());
        imageView.setColorFilter(ContextCompat.getColor((Context)this.context, (int)R.color.tabSelectedIconColor), PorterDuff.Mode.SRC_ATOP);
        return view;
    }
}

