/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.adapter;

import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CompoundButton;
import android.widget.RadioButton;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.google.gson.Gson;
import com.hippo.HippoColorConfig;
import com.hippo.R;
import com.hippo.adapter.OnPaymentListener;
import com.hippo.model.HippoPayment;
import com.hippo.model.Message;
import com.hippo.utils.HippoLog;
import java.util.ArrayList;

public class PaymentAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private OnPaymentListener listener;
    private ArrayList<HippoPayment> hippoPayments;
    private Message message;
    private HippoColorConfig hippoColorConfig;
    private String selectedId;
    private int position;

    public PaymentAdapter(Message message, ArrayList<HippoPayment> arrayList, OnPaymentListener onPaymentListener, HippoColorConfig hippoColorConfig, String string2, int n) {
        this.listener = onPaymentListener;
        this.message = message;
        this.hippoPayments = arrayList;
        this.hippoColorConfig = hippoColorConfig;
        this.selectedId = string2;
        this.position = n;
    }

    @NonNull
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int n) {
        return new ViewHolder(LayoutInflater.from((Context)viewGroup.getContext()).inflate(R.layout.hippo_customer_payment_item, viewGroup, false));
    }

    public void onBindViewHolder(@NonNull ViewHolder viewHolder, int n) {
        viewHolder.line.setVisibility(0);
        if (this.hippoPayments.size() == 1) {
            viewHolder.radioBtn.setVisibility(8);
        } else {
            viewHolder.radioBtn.setVisibility(0);
        }
        viewHolder.title.setText((CharSequence)this.hippoPayments.get(n).getTitle());
        if (!TextUtils.isEmpty((CharSequence)this.hippoPayments.get(n).getDescription())) {
            viewHolder.description.setVisibility(0);
            viewHolder.description.setText((CharSequence)this.hippoPayments.get(n).getDescription());
        } else {
            viewHolder.description.setVisibility(8);
        }
        String string2 = this.hippoPayments.get(n).getCurrencySymbol();
        viewHolder.amount.setText((CharSequence)(string2 + "" + this.hippoPayments.get(n).getAmount()));
        viewHolder.radioBtn.setChecked(this.hippoPayments.get(n).isSelected());
        viewHolder.title.setTextColor(this.hippoColorConfig.getHippoPaymentTitle());
        viewHolder.description.setTextColor(this.hippoColorConfig.getHippoPaymentDescription());
        viewHolder.amount.setTextColor(this.hippoColorConfig.getHippoPaymentAmount());
        viewHolder.paymentLayout.setBackgroundColor(this.hippoColorConfig.getHippoPaymentBg());
        if (!TextUtils.isEmpty((CharSequence)this.selectedId) && this.hippoPayments.get(n).getId().equalsIgnoreCase(this.selectedId)) {
            viewHolder.paid.setVisibility(0);
            viewHolder.paid.setTextColor(this.hippoColorConfig.getHippoPaymentTitle());
        }
    }

    public int getItemCount() {
        return this.hippoPayments.size();
    }

    public class ViewHolder
    extends RecyclerView.ViewHolder {
        private TextView title;
        private TextView description;
        private TextView amount;
        private View line;
        private RelativeLayout paymentLayout;
        private RadioButton radioBtn;
        private TextView paid;

        public ViewHolder(@NonNull View view) {
            super(view);
            this.paymentLayout = (RelativeLayout)view.findViewById(R.id.paymentLayout);
            this.title = (TextView)view.findViewById(R.id.title);
            this.description = (TextView)view.findViewById(R.id.description);
            this.amount = (TextView)view.findViewById(R.id.amount);
            this.line = view.findViewById(R.id.line);
            this.radioBtn = (RadioButton)view.findViewById(R.id.radioBtn);
            this.paid = (TextView)view.findViewById(R.id.paid);
            this.radioBtn.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

                public void onCheckedChanged(CompoundButton compoundButton, boolean bl) {
                    if (compoundButton.isPressed()) {
                        ViewHolder.this.paymentLayout.performClick();
                    }
                }
            });
            this.paymentLayout.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    int n = ViewHolder.this.getAdapterPosition();
                    if (!((HippoPayment)PaymentAdapter.this.hippoPayments.get(n)).isSelected()) {
                        for (int j = 0; j < PaymentAdapter.this.hippoPayments.size(); ++j) {
                            if (j == n) {
                                ((HippoPayment)PaymentAdapter.this.hippoPayments.get(j)).setSelected(true);
                                try {
                                    if (PaymentAdapter.this.listener == null) continue;
                                    PaymentAdapter.this.listener.onPaymentViewClicked(PaymentAdapter.this.message, (HippoPayment)PaymentAdapter.this.hippoPayments.get(j), j, ((HippoPayment)PaymentAdapter.this.hippoPayments.get(j)).getPaymentUrl(), PaymentAdapter.this.position);
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                }
                                continue;
                            }
                            ((HippoPayment)PaymentAdapter.this.hippoPayments.get(j)).setSelected(false);
                        }
                        HippoLog.v("demo", "data = " + new Gson().toJson((Object)PaymentAdapter.this.hippoPayments));
                        PaymentAdapter.this.notifyDataSetChanged();
                    }
                }
            });
        }
    }
}

