/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.LinearLayout;
import android.widget.RadioButton;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.hippo.HippoColorConfig;
import com.hippo.R;
import com.hippo.interfaces.OnMultiSelectionListener;
import com.hippo.model.MultiSelectButtons;
import java.util.ArrayList;

public class MultiSelectionAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private Context context;
    private ArrayList<MultiSelectButtons> selectButtons;
    private boolean isMultiSelected;
    private int maxSelection = 0;
    private int selectedCount = 0;
    private boolean isSelectable = true;
    private HippoColorConfig colorConfig;
    private OnMultiSelectionListener listener;

    public MultiSelectionAdapter(ArrayList<MultiSelectButtons> arrayList, boolean bl, int n, boolean bl2, HippoColorConfig hippoColorConfig, OnMultiSelectionListener onMultiSelectionListener) {
        this.selectButtons = arrayList;
        this.isMultiSelected = bl;
        this.maxSelection = n;
        this.isSelectable = bl2;
        this.colorConfig = hippoColorConfig;
        this.listener = onMultiSelectionListener;
    }

    @NonNull
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int n) {
        this.context = viewGroup.getContext();
        return new ViewHolder(LayoutInflater.from((Context)this.context).inflate(R.layout.hippo_item_multi_selection, viewGroup, false), this.isMultiSelected);
    }

    public void onBindViewHolder(@NonNull ViewHolder viewHolder, int n) {
        MultiSelectButtons multiSelectButtons = this.selectButtons.get(n);
        viewHolder.textView.setText((CharSequence)multiSelectButtons.getTitle());
        if (this.colorConfig != null) {
            viewHolder.textView.setTextColor(this.colorConfig.getHippoPrimaryTextMsgYou());
        }
        if (this.isMultiSelected) {
            viewHolder.radioButton.setVisibility(8);
            viewHolder.checkBox.setVisibility(0);
        } else {
            viewHolder.checkBox.setVisibility(8);
            viewHolder.radioButton.setVisibility(0);
        }
        if (multiSelectButtons.getStatus() == 1) {
            viewHolder.checkBox.setChecked(true);
            viewHolder.radioButton.setChecked(true);
            viewHolder.mainLayout.setBackground(this.context.getDrawable(R.drawable.hippo_mullti_selector_bg));
        } else {
            viewHolder.mainLayout.setBackground(this.context.getDrawable(R.drawable.hippo_multi_normal_bg));
            viewHolder.checkBox.setChecked(false);
            viewHolder.radioButton.setChecked(false);
        }
        if (this.isSelectable) {
            viewHolder.checkBox.setEnabled(!this.isSelectable);
            viewHolder.radioButton.setEnabled(!this.isSelectable);
        }
    }

    public int getItemCount() {
        return this.selectButtons.size();
    }

    public class ViewHolder
    extends RecyclerView.ViewHolder {
        private TextView textView;
        private CheckBox checkBox;
        private RadioButton radioButton;
        private LinearLayout mainLayout;

        public ViewHolder(@NonNull View view, final boolean bl) {
            super(view);
            this.textView = (TextView)view.findViewById(R.id.item_textview);
            this.checkBox = (CheckBox)view.findViewById(R.id.cb_item_view);
            this.radioButton = (RadioButton)view.findViewById(R.id.rb_item_view);
            this.mainLayout = (LinearLayout)view.findViewById(R.id.main_layout);
            this.radioButton.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

                public void onCheckedChanged(CompoundButton compoundButton, boolean bl) {
                    if (compoundButton.isPressed()) {
                        ViewHolder.this.mainLayout.performClick();
                    }
                }
            });
            this.checkBox.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

                public void onCheckedChanged(CompoundButton compoundButton, boolean bl) {
                    if (compoundButton.isPressed()) {
                        if (MultiSelectionAdapter.this.maxSelection > 0 && MultiSelectionAdapter.this.selectedCount == MultiSelectionAdapter.this.maxSelection && bl) {
                            ViewHolder.this.checkBox.setChecked(!bl);
                            return;
                        }
                        ViewHolder.this.mainLayout.performClick();
                    }
                }
            });
            this.mainLayout.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    if (MultiSelectionAdapter.this.isSelectable) {
                        return;
                    }
                    if (bl) {
                        if (((MultiSelectButtons)MultiSelectionAdapter.this.selectButtons.get(ViewHolder.this.getAdapterPosition())).getStatus() == 0) {
                            if (MultiSelectionAdapter.this.maxSelection > 0 && MultiSelectionAdapter.this.selectedCount == MultiSelectionAdapter.this.maxSelection) {
                                MultiSelectionAdapter.this.notifyItemChanged(ViewHolder.this.getAdapterPosition());
                                return;
                            }
                            ((MultiSelectButtons)MultiSelectionAdapter.this.selectButtons.get(ViewHolder.this.getAdapterPosition())).setStatus(1);
                            MultiSelectionAdapter.this.selectedCount = MultiSelectionAdapter.this.selectedCount + 1;
                        } else {
                            ((MultiSelectButtons)MultiSelectionAdapter.this.selectButtons.get(ViewHolder.this.getAdapterPosition())).setStatus(0);
                            MultiSelectionAdapter.this.selectedCount = MultiSelectionAdapter.this.selectedCount - 1;
                        }
                        MultiSelectionAdapter.this.notifyItemChanged(ViewHolder.this.getAdapterPosition());
                    } else {
                        for (int j = 0; j < MultiSelectionAdapter.this.selectButtons.size(); ++j) {
                            ((MultiSelectButtons)MultiSelectionAdapter.this.selectButtons.get(j)).setStatus(0);
                        }
                        ((MultiSelectButtons)MultiSelectionAdapter.this.selectButtons.get(ViewHolder.this.getAdapterPosition())).setStatus(1);
                        MultiSelectionAdapter.this.notifyDataSetChanged();
                    }
                    if (MultiSelectionAdapter.this.listener != null) {
                        MultiSelectionAdapter.this.listener.onItemClicked(MultiSelectionAdapter.this.selectButtons);
                    }
                }
            });
        }
    }
}

