/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.adapter;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.PorterDuff;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.text.Html;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.request.BaseRequestOptions;
import com.bumptech.glide.request.RequestOptions;
import com.hippo.HippoColorConfig;
import com.hippo.HippoConfig;
import com.hippo.R;
import com.hippo.constant.FuguAppConstant;
import com.hippo.database.CommonData;
import com.hippo.datastructure.ChannelStatus;
import com.hippo.model.FuguConversation;
import com.hippo.utils.ColorGenerator;
import com.hippo.utils.DateUtils;
import com.hippo.utils.HippoLog;
import com.hippo.utils.TextDrawable;
import java.util.ArrayList;

public class HippoChannelsAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private LayoutInflater inflater;
    private ArrayList<Object> fuguConversationList = new ArrayList();
    private Activity activity;
    private String userName;
    private String businessName;
    private Long userId = -1L;
    private String enUserId = "";
    private HippoColorConfig hippoColorConfig;
    private Callback callback;
    private RequestOptions options;
    private static final int TYPE_ITEM = 1;
    public static final int ITEM_PROGRESS_BAR = 3;

    public HippoChannelsAdapter(Activity activity, ArrayList<Object> arrayList, String string2, Long l, String string3, Callback callback, String string4) {
        this.inflater = LayoutInflater.from((Context)activity.getApplicationContext());
        this.hippoColorConfig = CommonData.getColorConfig();
        this.fuguConversationList = arrayList;
        this.activity = activity;
        this.userName = string2;
        this.businessName = string3;
        this.userId = l;
        this.callback = callback;
        this.enUserId = string4;
    }

    private RequestOptions getRequestOptions(String string2) {
        ColorGenerator colorGenerator = ColorGenerator.MATERIAL;
        int n = colorGenerator.getColor(string2.trim());
        Resources resources = this.activity.getResources();
        float f2 = TypedValue.applyDimension((int)1, (float)20.0f, (DisplayMetrics)resources.getDisplayMetrics());
        char c2 = string2.trim().charAt(0);
        TextDrawable textDrawable = TextDrawable.builder().buildRoundRect((c2 + "").toUpperCase(), n, Math.round(f2));
        if (this.options == null) {
            this.options = (RequestOptions)((RequestOptions)((RequestOptions)new RequestOptions().circleCrop()).dontAnimate()).diskCacheStrategy(DiskCacheStrategy.ALL);
        }
        this.options.placeholder((Drawable)textDrawable);
        this.options.error((Drawable)textDrawable);
        return this.options;
    }

    public void updateList(ArrayList<Object> arrayList) {
        this.fuguConversationList = arrayList;
        this.notifyDataSetChanged();
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup viewGroup, int n) {
        if (n == 3) {
            View view = LayoutInflater.from((Context)viewGroup.getContext()).inflate(R.layout.hippo_custom_loading_list_item, viewGroup, false);
            return new ProgressBarViewHolder(view);
        }
        View view = this.inflater.inflate(R.layout.fugu_item_channels, viewGroup, false);
        return new ChannelViewHolder(view);
    }

    @SuppressLint(value={"SetTextI18n"})
    public void onBindViewHolder(RecyclerView.ViewHolder viewHolder, int n) {
        if (viewHolder instanceof ChannelViewHolder) {
            try {
                final ChannelViewHolder channelViewHolder = (ChannelViewHolder)viewHolder;
                final FuguConversation fuguConversation = (FuguConversation)this.fuguConversationList.get(n);
                channelViewHolder.tvChannelName.setText((CharSequence)fuguConversation.getLabel());
                channelViewHolder.tvChannelName.setTextColor(this.hippoColorConfig.getHippoTextColorPrimary());
                channelViewHolder.tvMessage.setTextColor(this.hippoColorConfig.getHippoTextColorPrimary());
                if (fuguConversation.getMessage_type() == 18) {
                    channelViewHolder.ivMessageState.setVisibility(8);
                    channelViewHolder.tvMessage.setText((CharSequence)Html.fromHtml((String)this.getMessageData(fuguConversation)));
                } else if (TextUtils.isEmpty((CharSequence)fuguConversation.getMessage())) {
                    if (!TextUtils.isEmpty((CharSequence)fuguConversation.getLast_sent_by_full_name())) {
                        if (HippoConfig.getInstance().getUserData().getUserId().compareTo(fuguConversation.getLast_sent_by_id()) == 0) {
                            if (fuguConversation.getMessage_type() == 10) {
                                channelViewHolder.tvMessage.setText((CharSequence)("You: " + this.activity.getString(R.string.fugu_attachment)));
                            } else if (fuguConversation.getMessage_type() == 11) {
                                channelViewHolder.tvMessage.setText((CharSequence)("You: " + this.activity.getString(R.string.hippo_attachment_file)));
                            } else {
                                channelViewHolder.tvMessage.setText((CharSequence)"You sent a message");
                            }
                            channelViewHolder.ivMessageState.setVisibility(0);
                            if (fuguConversation.getLast_message_status() == 3) {
                                channelViewHolder.ivMessageState.setImageDrawable(ContextCompat.getDrawable((Context)this.activity, (int)R.drawable.fugu_tick_double));
                            } else if (fuguConversation.getLast_message_status() == 4 || fuguConversation.getLast_message_status() == 5) {
                                channelViewHolder.ivMessageState.setImageDrawable(ContextCompat.getDrawable((Context)this.activity, (int)R.drawable.fugu_ic_waiting));
                            } else {
                                channelViewHolder.ivMessageState.setImageDrawable(ContextCompat.getDrawable((Context)this.activity, (int)R.drawable.fugu_tick_single));
                            }
                        } else {
                            if (fuguConversation.getMessage_type() == 10) {
                                channelViewHolder.tvMessage.setText((CharSequence)(fuguConversation.getLast_sent_by_full_name().trim() + ": " + this.activity.getString(R.string.fugu_attachment)));
                            } else if (fuguConversation.getMessage_type() == 11) {
                                channelViewHolder.tvMessage.setText((CharSequence)(fuguConversation.getLast_sent_by_full_name().trim() + ": " + this.activity.getString(R.string.hippo_attachment_file)));
                            } else {
                                channelViewHolder.tvMessage.setText((CharSequence)(fuguConversation.getLast_sent_by_full_name().trim() + " sent a message"));
                            }
                            channelViewHolder.ivMessageState.setVisibility(8);
                        }
                    }
                } else if (fuguConversation.getMessage().contains("\n")) {
                    channelViewHolder.tvMessage.setText((CharSequence)Html.fromHtml((String)fuguConversation.getMessage().replaceAll("\n", " ")));
                    if (!TextUtils.isEmpty((CharSequence)fuguConversation.getLast_sent_by_full_name())) {
                        HippoLog.e("error", HippoConfig.getInstance().getUserData().getUserId() + "");
                        HippoLog.e("error", fuguConversation.getUserId() + "");
                        if (HippoConfig.getInstance().getUserData().getUserId().compareTo(fuguConversation.getLast_sent_by_id()) == 0) {
                            channelViewHolder.tvMessage.setText((CharSequence)Html.fromHtml((String)("You: " + fuguConversation.getMessage())));
                            channelViewHolder.ivMessageState.setVisibility(0);
                            if (fuguConversation.getLast_message_status() == 3) {
                                channelViewHolder.ivMessageState.setImageDrawable(ContextCompat.getDrawable((Context)this.activity, (int)R.drawable.fugu_tick_double));
                            } else if (fuguConversation.getLast_message_status() == 4 || fuguConversation.getLast_message_status() == 5) {
                                channelViewHolder.ivMessageState.setImageDrawable(ContextCompat.getDrawable((Context)this.activity, (int)R.drawable.fugu_ic_waiting));
                            } else {
                                channelViewHolder.ivMessageState.setImageDrawable(ContextCompat.getDrawable((Context)this.activity, (int)R.drawable.fugu_tick_single));
                            }
                        } else {
                            channelViewHolder.tvMessage.setText((CharSequence)Html.fromHtml((String)(fuguConversation.getLast_sent_by_full_name().trim() + ": " + fuguConversation.getMessage())));
                            channelViewHolder.ivMessageState.setVisibility(8);
                        }
                    } else if (fuguConversation.getUserId().equals(HippoConfig.getInstance().getUserData().getUserId())) {
                        channelViewHolder.tvMessage.setText((CharSequence)Html.fromHtml((String)("You: " + fuguConversation.getMessage())));
                        channelViewHolder.ivMessageState.setVisibility(0);
                        if (fuguConversation.getLast_message_status() == 3) {
                            channelViewHolder.ivMessageState.setImageDrawable(ContextCompat.getDrawable((Context)this.activity, (int)R.drawable.fugu_tick_double));
                        } else if (fuguConversation.getLast_message_status() == 4) {
                            channelViewHolder.ivMessageState.setImageDrawable(ContextCompat.getDrawable((Context)this.activity, (int)R.drawable.fugu_ic_waiting));
                        } else {
                            channelViewHolder.ivMessageState.setImageDrawable(ContextCompat.getDrawable((Context)this.activity, (int)R.drawable.fugu_tick_single));
                        }
                    } else {
                        channelViewHolder.tvMessage.setText((CharSequence)Html.fromHtml((String)fuguConversation.getMessage()));
                        channelViewHolder.ivMessageState.setVisibility(8);
                    }
                } else if (!TextUtils.isEmpty((CharSequence)fuguConversation.getLast_sent_by_full_name())) {
                    HippoLog.e("error", HippoConfig.getInstance().getUserData().getUserId() + "");
                    HippoLog.e("error", fuguConversation.getUserId() + "");
                    if (HippoConfig.getInstance().getUserData().getUserId().compareTo(fuguConversation.getLast_sent_by_id()) == 0) {
                        channelViewHolder.tvMessage.setText((CharSequence)Html.fromHtml((String)("You: " + fuguConversation.getMessage())));
                        channelViewHolder.ivMessageState.setVisibility(0);
                        if (fuguConversation.getLast_message_status() == 3) {
                            channelViewHolder.ivMessageState.setImageDrawable(ContextCompat.getDrawable((Context)this.activity, (int)R.drawable.fugu_tick_double));
                        } else if (fuguConversation.getLast_message_status() == 4 || fuguConversation.getLast_message_status() == 5) {
                            channelViewHolder.ivMessageState.setImageDrawable(ContextCompat.getDrawable((Context)this.activity, (int)R.drawable.fugu_ic_waiting));
                        } else {
                            channelViewHolder.ivMessageState.setImageDrawable(ContextCompat.getDrawable((Context)this.activity, (int)R.drawable.fugu_tick_single));
                        }
                    } else {
                        channelViewHolder.tvMessage.setText((CharSequence)Html.fromHtml((String)(fuguConversation.getLast_sent_by_full_name().trim() + ": " + fuguConversation.getMessage())));
                        channelViewHolder.ivMessageState.setVisibility(8);
                    }
                } else if (fuguConversation.getUserId().equals(HippoConfig.getInstance().getUserData().getUserId())) {
                    channelViewHolder.tvMessage.setText((CharSequence)Html.fromHtml((String)("You: " + fuguConversation.getMessage())));
                    channelViewHolder.ivMessageState.setVisibility(0);
                    if (fuguConversation.getLast_message_status() == 3) {
                        channelViewHolder.ivMessageState.setImageDrawable(ContextCompat.getDrawable((Context)this.activity, (int)R.drawable.fugu_tick_double));
                    } else if (fuguConversation.getLast_message_status() == 4) {
                        channelViewHolder.ivMessageState.setImageDrawable(ContextCompat.getDrawable((Context)this.activity, (int)R.drawable.fugu_ic_waiting));
                    } else {
                        channelViewHolder.ivMessageState.setImageDrawable(ContextCompat.getDrawable((Context)this.activity, (int)R.drawable.fugu_tick_single));
                    }
                } else {
                    channelViewHolder.tvMessage.setText((CharSequence)Html.fromHtml((String)fuguConversation.getMessage()));
                    channelViewHolder.ivMessageState.setVisibility(8);
                }
                if (fuguConversation.getUnreadCount() > 0) {
                    channelViewHolder.tvChannelName.setTypeface(Typeface.DEFAULT_BOLD);
                    channelViewHolder.tvMessage.setTypeface(Typeface.DEFAULT_BOLD);
                    channelViewHolder.circularTvMessageCount.setVisibility(0);
                    channelViewHolder.circularTvMessageCount.setText((CharSequence)String.valueOf(fuguConversation.getUnreadCount()));
                    channelViewHolder.tvDate.setTextColor(this.hippoColorConfig.getHippoTextColorPrimary());
                } else {
                    channelViewHolder.tvChannelName.setTypeface(Typeface.DEFAULT);
                    channelViewHolder.tvMessage.setTypeface(Typeface.DEFAULT);
                    channelViewHolder.circularTvMessageCount.setVisibility(8);
                    channelViewHolder.tvDate.setTextColor(this.hippoColorConfig.getHippoChannelDateText());
                }
                if (fuguConversation.getChannelImage() == null || fuguConversation.getChannelImage().trim().isEmpty()) {
                    channelViewHolder.ivChannelIcon.setVisibility(8);
                    channelViewHolder.tvChannelIcon.setText((CharSequence)fuguConversation.getLabel().trim().substring(0, 1).toUpperCase());
                    channelViewHolder.tvChannelIcon.setVisibility(0);
                    Glide.with((Activity)this.activity).clear((View)channelViewHolder.ivChannelIcon);
                    channelViewHolder.ivChannelIcon.setImageDrawable(ContextCompat.getDrawable((Context)this.activity, (int)R.drawable.hippo_ring_grey));
                    channelViewHolder.ivChannelIcon.getDrawable().setColorFilter(this.hippoColorConfig.getHippoChannelDateText(), PorterDuff.Mode.SRC_ATOP);
                    channelViewHolder.tvChannelIcon.setTextColor(this.hippoColorConfig.getHippoChannelItemBg());
                    GradientDrawable gradientDrawable = (GradientDrawable)channelViewHolder.tvChannelIcon.getBackground();
                    gradientDrawable.setColor(this.hippoColorConfig.getHippoChannelDateText());
                } else {
                    String string2 = fuguConversation.getLabel().trim().substring(0, 1).toUpperCase();
                    Glide.with((Activity)this.activity).asBitmap().apply((BaseRequestOptions)this.getRequestOptions(string2)).load(fuguConversation.getChannelImage()).into(channelViewHolder.ivChannelIcon);
                    channelViewHolder.ivChannelIcon.setVisibility(0);
                    channelViewHolder.tvChannelIcon.setVisibility(8);
                }
                try {
                    if (fuguConversation.getChannelId() == null || fuguConversation.getChannelId().intValue() < 0) {
                        channelViewHolder.tvDate.setVisibility(8);
                    } else {
                        channelViewHolder.tvDate.setText((CharSequence)DateUtils.getRelativeDate(DateUtils.getInstance().convertToLocal(fuguConversation.getDateTime()), true));
                        channelViewHolder.tvDate.setVisibility(0);
                    }
                }
                catch (Exception exception) {
                    channelViewHolder.tvDate.setVisibility(8);
                }
                if (fuguConversation.getChannelStatus() == ChannelStatus.CLOSED.getOrdinal() && fuguConversation.getLabelId() < 0L) {
                    channelViewHolder.vClosed.setVisibility(0);
                } else {
                    channelViewHolder.vClosed.setVisibility(8);
                }
                channelViewHolder.rlRoot.setBackgroundDrawable((Drawable)HippoColorConfig.makeSelector(this.hippoColorConfig.getHippoChannelItemBg(), this.hippoColorConfig.getHippoChannelItemBgPressed()));
                channelViewHolder.rlRoot.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        channelViewHolder.circularTvMessageCount.setVisibility(8);
                        fuguConversation.setUnreadCount(0);
                        FuguConversation fuguConversation2 = new FuguConversation();
                        fuguConversation2.setLabel(fuguConversation.getLabel());
                        fuguConversation2.setChannelId(fuguConversation.getChannelId());
                        fuguConversation2.setLabelId(fuguConversation.getLabelId());
                        fuguConversation2.setDefaultMessage(fuguConversation.getMessage());
                        fuguConversation2.setChannelStatus(fuguConversation.getChannelStatus());
                        fuguConversation2.setChannelImage(fuguConversation.getChannelImage());
                        fuguConversation2.setBusinessName(HippoChannelsAdapter.this.businessName);
                        fuguConversation2.setUserId(HippoChannelsAdapter.this.userId);
                        fuguConversation2.setEnUserId(HippoChannelsAdapter.this.enUserId);
                        fuguConversation2.setOpenChat(true);
                        fuguConversation2.setUserName(HippoChannelsAdapter.this.userName);
                        fuguConversation2.setIsTimeSet(1);
                        fuguConversation2.setChatType(fuguConversation.getChatType());
                        fuguConversation2.setStatus(fuguConversation.getStatus());
                        fuguConversation2.setLast_sent_by_id(fuguConversation.getLast_sent_by_id());
                        HippoChannelsAdapter.this.callback.onClick(fuguConversation2);
                    }
                });
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public int getItemCount() {
        if (this.fuguConversationList == null || this.fuguConversationList.size() == 0) {
            return 0;
        }
        return this.fuguConversationList.size();
    }

    public int getItemViewType(int n) {
        if (this.fuguConversationList.get(n) instanceof ProgressBarItem) {
            return 3;
        }
        return 1;
    }

    private String getMessageData(FuguConversation fuguConversation) {
        String string2 = "The video call ended";
        String string3 = "video";
        if (!TextUtils.isEmpty((CharSequence)fuguConversation.getCallType()) && fuguConversation.getCallType().equalsIgnoreCase(FuguAppConstant.CallType.AUDIO.toString())) {
            string3 = "voice";
        }
        string2 = fuguConversation.getMessageState() != null && fuguConversation.getMessageState() == 2 ? (fuguConversation.getLast_sent_by_id().equals(HippoConfig.getInstance().getUserData().getUserId()) ? "Customer missed a " + string3 + " call with you" : "You missed a " + string3 + " call with " + fuguConversation.getLast_sent_by_full_name()) : "The " + string3 + " call ended";
        return string2;
    }

    private static class ProgressBarViewHolder
    extends RecyclerView.ViewHolder {
        public ProgressBarViewHolder(View view) {
            super(view);
        }
    }

    public static class ProgressBarItem {
    }

    public static interface Callback {
        public void onClick(FuguConversation var1);
    }

    class ChannelViewHolder
    extends RecyclerView.ViewHolder {
        private RelativeLayout rlRoot;
        private TextView tvChannelName;
        private TextView tvMessage;
        private TextView tvDate;
        private TextView tvChannelIcon;
        private ImageView ivChannelIcon;
        private ImageView ivMessageState;
        private TextView circularTvMessageCount;
        private View vClosed;

        ChannelViewHolder(View view) {
            super(view);
            this.rlRoot = (RelativeLayout)view.findViewById(R.id.rlRoot);
            this.tvChannelName = (TextView)view.findViewById(R.id.tvChannelName);
            this.tvMessage = (TextView)view.findViewById(R.id.tvMessage);
            this.tvDate = (TextView)view.findViewById(R.id.tvDate);
            this.ivChannelIcon = (ImageView)view.findViewById(R.id.ivChannelIcon);
            this.ivMessageState = (ImageView)view.findViewById(R.id.ivMessageState);
            this.circularTvMessageCount = (TextView)view.findViewById(R.id.circularTvMessageCount);
            this.vClosed = view.findViewById(R.id.vClosed);
        }
    }
}

