/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.adapter;

import android.animation.ObjectAnimator;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.recyclerview.widget.RecyclerView;
import com.hippo.R;
import com.hippo.constant.FuguAppConstant;
import com.hippo.model.FuguAttachmentModel;
import java.util.ArrayList;

public class FuguAttachmentAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder>
implements FuguAppConstant {
    private LayoutInflater inflater;
    private ArrayList<FuguAttachmentModel> attachmentList = new ArrayList();
    private Context context;
    private OnAttachListener mOnAttach;
    private boolean showDocs;
    private boolean isOneToOne;
    private boolean showEmpty;

    public FuguAttachmentAdapter(Context context, boolean bl, boolean bl2) {
        this.inflater = LayoutInflater.from((Context)context);
        this.showDocs = bl;
        this.isOneToOne = bl2;
        this.context = context;
        this.attachmentList.add(new FuguAttachmentModel(R.drawable.hippo_ic_gallery_camera, context.getResources().getString(R.string.fugu_camera), 514, R.drawable.hippo_ring_white, true));
        this.attachmentList.add(new FuguAttachmentModel(R.drawable.hippo_ic_gallery, context.getResources().getString(R.string.fugu_gallery), 515, R.drawable.hippo_ring_blue, true));
        this.attachmentList.add(new FuguAttachmentModel(R.drawable.hippo_ic_gallery_video, "Video", 519, R.drawable.hippo_ring_orange, true));
        this.attachmentList.add(new FuguAttachmentModel(R.drawable.hippo_ic_gallery_music, context.getResources().getString(R.string.fugu_audio), 518, R.drawable.hippo_ring_red, true));
        this.attachmentList.add(new FuguAttachmentModel(R.drawable.hippo_ic_gallery_file, context.getResources().getString(R.string.fugu_document), 516, R.drawable.hippo_ring_purple, true));
        if (bl2) {
            this.attachmentList.add(new FuguAttachmentModel(R.drawable.hippo_ic_payment, context.getResources().getString(R.string.fugu_payment), 520, R.drawable.hippo_ring_blue, true));
        }
    }

    public void setOnAttachListener(OnAttachListener onAttachListener) {
        this.mOnAttach = onAttachListener;
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup viewGroup, int n) {
        View view = this.inflater.inflate(R.layout.fugu_item_dialog_attach, viewGroup, false);
        AttachmentViewHolder attachmentViewHolder = new AttachmentViewHolder(view);
        return attachmentViewHolder;
    }

    public void onBindViewHolder(RecyclerView.ViewHolder viewHolder, int n) {
        AttachmentViewHolder attachmentViewHolder = (AttachmentViewHolder)viewHolder;
        final FuguAttachmentModel fuguAttachmentModel = this.attachmentList.get(n);
        attachmentViewHolder.tvAttachmentType.setText((CharSequence)fuguAttachmentModel.getText());
        if (n == 0) {
            attachmentViewHolder.ivImageBig.setImageResource(fuguAttachmentModel.getImageIcon());
            attachmentViewHolder.llImageBg.setVisibility(8);
            attachmentViewHolder.ivImageBig.setVisibility(0);
        } else {
            attachmentViewHolder.ivImage.setImageResource(fuguAttachmentModel.getImageIcon());
            attachmentViewHolder.llImageBg.setVisibility(0);
            attachmentViewHolder.ivImageBig.setVisibility(8);
        }
        attachmentViewHolder.llImageBg.setBackgroundResource(fuguAttachmentModel.getColor());
        attachmentViewHolder.itemView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (FuguAttachmentAdapter.this.mOnAttach != null) {
                    FuguAttachmentAdapter.this.mOnAttach.onAttach(fuguAttachmentModel.getAction());
                }
            }
        });
        switch (n) {
            case 0: 
            case 3: {
                ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)viewHolder.itemView, (String)"scaleX", (float[])new float[]{0.5f, 1.05f, 1.0f});
                objectAnimator.setDuration(500L);
                objectAnimator.start();
                ObjectAnimator objectAnimator2 = ObjectAnimator.ofFloat((Object)viewHolder.itemView, (String)"scaleY", (float[])new float[]{0.5f, 1.05f, 1.0f});
                objectAnimator2.setDuration(500L);
                objectAnimator2.start();
                break;
            }
            case 1: 
            case 4: {
                ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)viewHolder.itemView, (String)"scaleX", (float[])new float[]{0.5f, 1.05f, 1.0f});
                objectAnimator.setDuration(600L);
                objectAnimator.start();
                ObjectAnimator objectAnimator3 = ObjectAnimator.ofFloat((Object)viewHolder.itemView, (String)"scaleY", (float[])new float[]{0.5f, 1.05f, 1.0f});
                objectAnimator3.setDuration(600L);
                objectAnimator3.start();
                break;
            }
            case 2: 
            case 5: {
                ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)viewHolder.itemView, (String)"scaleX", (float[])new float[]{0.5f, 1.05f, 1.0f});
                objectAnimator.setDuration(700L);
                objectAnimator.start();
                ObjectAnimator objectAnimator4 = ObjectAnimator.ofFloat((Object)viewHolder.itemView, (String)"scaleY", (float[])new float[]{0.5f, 1.05f, 1.0f});
                objectAnimator4.setDuration(700L);
                objectAnimator4.start();
            }
        }
    }

    public int getItemCount() {
        return this.attachmentList.size();
    }

    class AttachmentViewHolder
    extends RecyclerView.ViewHolder {
        private TextView tvAttachmentType;
        private ImageView ivImage;
        private ImageView ivImageBig;
        private LinearLayout llImageBg;

        public AttachmentViewHolder(View view) {
            super(view);
            this.tvAttachmentType = (TextView)view.findViewById(R.id.tvAttachmentType);
            this.ivImage = (ImageView)view.findViewById(R.id.ivImage);
            this.ivImageBig = (ImageView)view.findViewById(R.id.ivImageBig);
            this.llImageBg = (LinearLayout)view.findViewById(R.id.llImageBg);
        }
    }

    public static interface OnAttachListener {
        public void onAttach(int var1);
    }
}

