/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.adapter;

import android.content.Context;
import android.graphics.drawable.GradientDrawable;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.appcompat.widget.AppCompatButton;
import androidx.fragment.app.FragmentManager;
import androidx.recyclerview.widget.RecyclerView;
import com.google.android.material.textfield.TextInputEditText;
import com.hippo.HippoColorConfig;
import com.hippo.R;
import com.hippo.constant.FuguAppConstant;
import com.hippo.database.CommonData;
import com.hippo.interfaces.CustomerInitalListener;
import com.hippo.model.Button;
import com.hippo.model.Field;
import com.hippo.support.Utils.Constants;
import com.hippo.utils.Utils;
import com.hippo.utils.countrypicker.Country;
import com.hippo.utils.countrypicker.CountryPicker;
import com.hippo.utils.countrypicker.OnCountryPickerListener;
import java.util.ArrayList;

public class CustomerInitalAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder>
implements FuguAppConstant {
    private static final String TAG = CustomerInitalAdapter.class.getSimpleName();
    private ArrayList<Object> arrayList = new ArrayList();
    private static final int FIELD_TYPE = 1;
    private static final int BUTTON_TYPE = 2;
    private Context mContext;
    private HippoColorConfig hippoColorConfig = CommonData.getColorConfig();
    private FragmentManager fragmentManager;
    private CustomerInitalListener initalListener;
    private boolean hasFocus = false;

    public CustomerInitalAdapter(ArrayList<Object> arrayList, FragmentManager fragmentManager, CustomerInitalListener customerInitalListener) {
        this.arrayList = arrayList;
        this.fragmentManager = fragmentManager;
        this.initalListener = customerInitalListener;
        this.hasFocus = false;
    }

    public void setDataSet(ArrayList<Object> arrayList) {
        this.arrayList = arrayList;
        this.notifyDataSetChanged();
    }

    @NonNull
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int n) {
        this.mContext = viewGroup.getContext();
        if (n == 1) {
            return new Fields(LayoutInflater.from((Context)this.mContext).inflate(R.layout.layout_fields_list, viewGroup, false), new MyFormEditTextListener());
        }
        return new Buttons(LayoutInflater.from((Context)this.mContext).inflate(R.layout.layout_button_list, viewGroup, false));
    }

    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder viewHolder, int n) {
        int n2 = this.getItemViewType(n);
        switch (n2) {
            case 1: {
                Fields fields = (Fields)viewHolder;
                Field field = (Field)this.arrayList.get(n);
                fields.title.setText((CharSequence)field.getTitle());
                if (field.getType().toLowerCase().equalsIgnoreCase("LABEL")) {
                    fields.rlFeild.setVisibility(8);
                    fields.description.setVisibility(0);
                    fields.description.setText((CharSequence)field.getDescription());
                    fields.tvError.setVisibility(8);
                } else {
                    fields.rlFeild.setVisibility(0);
                    fields.description.setVisibility(8);
                    if (!TextUtils.isEmpty((CharSequence)field.getTextValue())) {
                        fields.editText.setText((CharSequence)field.getTextValue());
                    } else {
                        fields.editText.setText((CharSequence)"");
                    }
                    fields.myCustomEditTextListener.updatePosition(field, n, fields.tvError);
                    fields.editText.setHint((CharSequence)field.getPlaceholder());
                    fields.countryView.setVisibility(8);
                    this.setFieldInputType(field, fields.editText, fields.countryView, field.getValidationType(), n);
                    if (!TextUtils.isEmpty((CharSequence)field.getErrorText())) {
                        fields.tvError.setVisibility(0);
                        fields.tvError.setText((CharSequence)field.getErrorText());
                        if (!this.hasFocus) {
                            fields.editText.requestFocus();
                            this.hasFocus = true;
                        }
                    } else {
                        fields.tvError.setVisibility(8);
                    }
                }
                fields.title.setTextColor(this.hippoColorConfig.getHippoTextColorPrimary());
                fields.description.setTextColor(this.hippoColorConfig.getHippoTextColorSecondary());
                fields.editText.setTextColor(this.hippoColorConfig.getHippoTextColorPrimary());
                break;
            }
            case 2: {
                Buttons buttons = (Buttons)viewHolder;
                Button button = (Button)this.arrayList.get(n);
                buttons.compatButton.setText((CharSequence)button.getTitle());
                buttons.compatButton.setTextColor(this.hippoColorConfig.getHippoActionBarText());
                int n3 = (int)Constants.convertDpToPixel(1.0f);
                GradientDrawable gradientDrawable = (GradientDrawable)buttons.compatButton.getBackground();
                gradientDrawable.setStroke(n3, this.hippoColorConfig.getHippoActionBarText());
                gradientDrawable.setColor(this.hippoColorConfig.getHippoActionBarBg());
            }
        }
    }

    public int getItemCount() {
        return this.arrayList == null ? 0 : this.arrayList.size();
    }

    public int getItemViewType(int n) {
        if (this.arrayList.get(n) instanceof Field) {
            return 1;
        }
        return 2;
    }

    public boolean checkValidValues() {
        boolean bl = true;
        boolean bl2 = true;
        String string2 = null;
        block12: for (int j = 0; j < this.arrayList.size(); ++j) {
            if (!(this.arrayList.get(j) instanceof Field)) continue;
            Field field = (Field)this.arrayList.get(j);
            String string3 = field.getTextValue();
            if (!TextUtils.isEmpty((CharSequence)string3)) {
                string3 = string3.trim();
            }
            String string4 = field.getValidationType();
            if (field.getType().toLowerCase().equalsIgnoreCase("label")) continue;
            if (field.getIsRequired().booleanValue() && TextUtils.isEmpty((CharSequence)string3)) {
                field.setErrorText("Field can't be empty");
                bl2 = false;
                continue;
            }
            field.setErrorText("");
            switch (string4.toLowerCase()) {
                case "Number": 
                case "number": {
                    bl = Utils.isNumeric(string3);
                    String string5 = string2 = bl ? null : "Enter numeric values only";
                    if (bl) continue block12;
                    bl2 = false;
                    field.setErrorText(string2);
                    continue block12;
                }
                case "email": {
                    String string6 = "email";
                    if (!TextUtils.isEmpty((CharSequence)field.getTitle())) {
                        string6 = field.getTitle().toLowerCase();
                    }
                    String string7 = string2 = (bl = Utils.isEmailValid(string3)) ? null : "Enter valid " + string6;
                    if (bl) continue block12;
                    bl2 = false;
                    field.setErrorText(string2);
                    continue block12;
                }
                case "phone_number": 
                case "phone": {
                    String string8 = "phone number";
                    if (!TextUtils.isEmpty((CharSequence)field.getTitle())) {
                        string8 = field.getTitle().toLowerCase();
                    }
                    String string9 = string2 = (bl = Utils.isValidPhoneNumber(string3)) ? null : "Enter valid " + string8;
                    if (bl) continue block12;
                    bl2 = false;
                    field.setErrorText(string2);
                    continue block12;
                }
            }
        }
        return bl2;
    }

    private void setFieldInputType(Field field, TextInputEditText textInputEditText, TextView textView, String string2, int n) {
        switch (string2.toLowerCase()) {
            case "Number": 
            case "number": {
                textInputEditText.setInputType(8194);
                textInputEditText.setSingleLine(true);
                break;
            }
            case "email": {
                textInputEditText.setInputType(33);
                break;
            }
            case "phone_number": 
            case "phone": {
                textInputEditText.setInputType(3);
                if (field.getType().equalsIgnoreCase("TEXTFIELD")) {
                    textView.setVisibility(8);
                    break;
                }
                textView.setVisibility(0);
                if (!TextUtils.isEmpty((CharSequence)field.getCountryCode())) {
                    textView.setText((CharSequence)field.getCountryCode());
                    break;
                }
                String string3 = this.getDefaultCode();
                string3 = !TextUtils.isEmpty((CharSequence)string3) ? string3 : "+1";
                textView.setText((CharSequence)string3);
                ((Field)this.arrayList.get(n)).setCountryCode(string3);
                break;
            }
            default: {
                textInputEditText.setInputType(16385);
            }
        }
    }

    private String getDefaultCode() {
        try {
            CountryPicker countryPicker = new CountryPicker.Builder().with(this.mContext).build();
            return countryPicker.getCountryFromSIM().getDialCode();
        }
        catch (Exception exception) {
            return "";
        }
    }

    private void openPicker(final TextView textView, final EditText editText, final int n) {
        CountryPicker countryPicker = new CountryPicker.Builder().with(this.mContext).sortBy(1).canSearch(true).listener(new OnCountryPickerListener(){

            @Override
            public void onSelectCountry(Country country) {
                textView.setText((CharSequence)country.getDialCode());
                ((Field)CustomerInitalAdapter.this.arrayList.get(n)).setCountryCode(country.getDialCode());
                editText.requestFocus();
            }
        }).build();
        countryPicker.showDialog(this.fragmentManager);
    }

    public class MyFormEditTextListener
    implements TextWatcher {
        private Field field;
        private int position;
        private TextView errorView;

        public void updatePosition(Field field, int n, TextView textView) {
            this.field = field;
            this.position = n;
            this.errorView = textView;
        }

        public void beforeTextChanged(CharSequence charSequence, int n, int n2, int n3) {
        }

        public void onTextChanged(CharSequence charSequence, int n, int n2, int n3) {
            if (charSequence.length() > 0 && this.field != null && this.errorView.getVisibility() == 0) {
                this.errorView.setVisibility(8);
                ((Field)CustomerInitalAdapter.this.arrayList.get(this.position)).setErrorText("");
            }
        }

        public void afterTextChanged(Editable editable) {
            if (this.field != null) {
                ((Field)CustomerInitalAdapter.this.arrayList.get(this.position)).setTextValue(editable.toString());
            }
        }
    }

    public class Buttons
    extends RecyclerView.ViewHolder {
        private AppCompatButton compatButton;

        public Buttons(@NonNull View view) {
            super(view);
            this.compatButton = (AppCompatButton)view.findViewById(R.id.button_view);
            this.compatButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    if (CustomerInitalAdapter.this.checkValidValues()) {
                        if (CustomerInitalAdapter.this.initalListener != null) {
                            CustomerInitalAdapter.this.initalListener.onButtonClicked(CustomerInitalAdapter.this.arrayList);
                        }
                    } else {
                        CustomerInitalAdapter.this.hasFocus = false;
                        if (CustomerInitalAdapter.this.initalListener != null) {
                            CustomerInitalAdapter.this.initalListener.onNotifyAdapter(CustomerInitalAdapter.this.arrayList);
                        }
                    }
                }
            });
        }
    }

    public class Fields
    extends RecyclerView.ViewHolder {
        private RelativeLayout rlFeild;
        private MyFormEditTextListener myCustomEditTextListener;
        private TextInputEditText editText;
        private TextView title;
        private TextView description;
        private TextView countryView;
        private TextView tvError;

        public Fields(@NonNull View view, MyFormEditTextListener myFormEditTextListener) {
            super(view);
            this.rlFeild = (RelativeLayout)view.findViewById(R.id.rlFeild);
            this.editText = (TextInputEditText)view.findViewById(R.id.field_view);
            this.title = (TextView)view.findViewById(R.id.title_view);
            this.description = (TextView)view.findViewById(R.id.title_description);
            this.countryView = (TextView)view.findViewById(R.id.country_picker);
            this.tvError = (TextView)view.findViewById(R.id.tvError);
            this.myCustomEditTextListener = myFormEditTextListener;
            this.editText.addTextChangedListener((TextWatcher)myFormEditTextListener);
            this.countryView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    CustomerInitalAdapter.this.openPicker(Fields.this.countryView, (EditText)Fields.this.editText, Fields.this.getAdapterPosition());
                }
            });
            this.editText.setOnEditorActionListener(new TextView.OnEditorActionListener(){

                public boolean onEditorAction(TextView textView, int n, KeyEvent keyEvent) {
                    if (n == 5) {
                        View view = textView.focusSearch(2);
                        return view != null && !textView.requestFocus(2);
                    }
                    return false;
                }
            });
        }
    }
}

