/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.adapter;

import android.content.Context;
import android.graphics.drawable.GradientDrawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import androidx.appcompat.widget.AppCompatButton;
import androidx.recyclerview.widget.RecyclerView;
import com.hippo.HippoColorConfig;
import com.hippo.R;
import com.hippo.activity.FuguChatActivity;
import com.hippo.agent.AgentChatActivity;
import com.hippo.database.CommonData;
import com.hippo.model.ActionButtonModel;
import com.hippo.support.Utils.Constants;
import java.util.ArrayList;

public class CustomActionButtonsAdapter
extends RecyclerView.Adapter<ActionButtonViewHolder> {
    private Context mContext;
    private LayoutInflater mLayoutInflater;
    private ArrayList<ActionButtonModel> mActionButtons;
    private boolean disAbleClick;
    private HippoColorConfig hippoColorConfig;

    public CustomActionButtonsAdapter(Context context, ArrayList<ActionButtonModel> arrayList) {
        this.mContext = context;
        this.mLayoutInflater = LayoutInflater.from((Context)context);
        this.mActionButtons = arrayList;
    }

    public CustomActionButtonsAdapter(Context context, ArrayList<ActionButtonModel> arrayList, boolean bl) {
        this.mContext = context;
        this.mLayoutInflater = LayoutInflater.from((Context)context);
        this.mActionButtons = arrayList;
        this.disAbleClick = bl;
        this.hippoColorConfig = CommonData.getColorConfig();
    }

    public ActionButtonViewHolder onCreateViewHolder(ViewGroup viewGroup, int n) {
        View view = this.mLayoutInflater.inflate(R.layout.hippo_list_item_action_button, viewGroup, false);
        return new ActionButtonViewHolder(view);
    }

    public void onBindViewHolder(ActionButtonViewHolder actionButtonViewHolder, int n) {
        int n2 = actionButtonViewHolder.getAdapterPosition();
        ActionButtonModel actionButtonModel = this.mActionButtons.get(n2);
        actionButtonViewHolder.btnAction.setText((CharSequence)actionButtonModel.getButtonText());
    }

    public int getItemCount() {
        return this.mActionButtons.size();
    }

    class ActionButtonViewHolder
    extends RecyclerView.ViewHolder {
        AppCompatButton btnAction;
        RelativeLayout rlButton;

        ActionButtonViewHolder(View view) {
            super(view);
            this.btnAction = (AppCompatButton)view.findViewById(R.id.btnAction);
            this.rlButton = (RelativeLayout)view.findViewById(R.id.rl_button);
            this.btnAction.setTextColor(CustomActionButtonsAdapter.this.hippoColorConfig.getHippoActionBarText());
            int n = (int)Constants.convertDpToPixel(1.0f);
            GradientDrawable gradientDrawable = (GradientDrawable)this.rlButton.getBackground();
            gradientDrawable.setStroke(n, CustomActionButtonsAdapter.this.hippoColorConfig.getHippoActionBarText());
            gradientDrawable.setColor(CustomActionButtonsAdapter.this.hippoColorConfig.getHippoActionBarBg());
            this.btnAction.setEnabled(!CustomActionButtonsAdapter.this.disAbleClick);
            this.btnAction.setClickable(!CustomActionButtonsAdapter.this.disAbleClick);
            this.btnAction.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    if (!CustomActionButtonsAdapter.this.disAbleClick) {
                        if (CustomActionButtonsAdapter.this.mContext instanceof FuguChatActivity) {
                            ((FuguChatActivity)CustomActionButtonsAdapter.this.mContext).onCustomActionClicked(((ActionButtonModel)CustomActionButtonsAdapter.this.mActionButtons.get(ActionButtonViewHolder.this.getAdapterPosition())).getButtonAction());
                        } else if (CustomActionButtonsAdapter.this.mContext instanceof AgentChatActivity) {
                            ((AgentChatActivity)CustomActionButtonsAdapter.this.mContext).onCustomActionClicked(((ActionButtonModel)CustomActionButtonsAdapter.this.mActionButtons.get(ActionButtonViewHolder.this.getAdapterPosition())).getButtonAction());
                        }
                    }
                }
            });
        }
    }
}

