/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.adapter;

import android.app.Activity;
import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Typeface;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.Transformation;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.request.BaseRequestOptions;
import com.bumptech.glide.request.RequestOptions;
import com.hippo.HippoColorConfig;
import com.hippo.HippoConfig;
import com.hippo.R;
import com.hippo.agent.Util.ProgressBarDisplayRunnable;
import com.hippo.database.CommonData;
import com.hippo.interfaces.OnItemClickListener;
import com.hippo.model.promotional.Data;
import com.hippo.utils.DateUtils;
import com.hippo.utils.RoundedCornersTransformation;
import java.util.ArrayList;

public class CampaignAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private Context mContext;
    private OnItemClickListener itemClickListener;
    private HippoColorConfig hippoColorConfig;
    private ArrayList<Data> arrayList;
    private RecyclerView recyclerView;
    private static final int VIEW_TYPE = 1;
    private static final int VIEW_TYPE_LOADING = 2;
    private String outputFormat = "dd MMM, yy h:mm a";
    private Typeface customBold;
    private Typeface customNormal;
    private ProgressBarDisplayRunnable progressBarDisplayRunnable;

    public CampaignAdapter(Activity activity, ArrayList<Data> arrayList, RecyclerView recyclerView, OnItemClickListener onItemClickListener) {
        this.arrayList = arrayList;
        this.recyclerView = recyclerView;
        this.itemClickListener = onItemClickListener;
        this.hippoColorConfig = CommonData.getColorConfig();
        if (HippoConfig.getInstance().getMobileCampaignBuilder() != null && !TextUtils.isEmpty((CharSequence)HippoConfig.getInstance().getMobileCampaignBuilder().getParseFormat())) {
            this.outputFormat = HippoConfig.getInstance().getMobileCampaignBuilder().getParseFormat();
        }
        this.customBold = Typeface.createFromAsset((AssetManager)activity.getAssets(), (String)"fonts/montserrat_semibold.otf");
        this.customNormal = Typeface.createFromAsset((AssetManager)activity.getAssets(), (String)"fonts/montserrat_regular.otf");
    }

    public void setData(ArrayList<Data> arrayList) {
        this.arrayList = arrayList;
        this.notifyDataSetChanged();
    }

    @NonNull
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int n) {
        this.mContext = viewGroup.getContext();
        if (n == 2) {
            return new LoadMoreHolder(LayoutInflater.from((Context)this.mContext).inflate(R.layout.hippo_layout_loaddata, viewGroup, false));
        }
        return new ViewHolder(LayoutInflater.from((Context)this.mContext).inflate(R.layout.hippo_item_campaign, viewGroup, false));
    }

    private static int countLines(String string2) {
        String[] stringArray = string2.split("\r\n|\r|\n");
        return stringArray.length;
    }

    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder viewHolder, int n) {
        if (viewHolder instanceof ViewHolder) {
            ViewHolder viewHolder2 = (ViewHolder)viewHolder;
            viewHolder2.title.setText((CharSequence)this.arrayList.get(n).getTitle());
            String string2 = this.arrayList.get(n).getDescription();
            int n2 = CampaignAdapter.countLines(string2);
            viewHolder2.description.setText((CharSequence)string2);
            viewHolder2.tvMsg.setText((CharSequence)string2);
            if (this.arrayList.get(n).getShowMore() == 2) {
                viewHolder2.readStatus.setText(R.string.hippo_read_less);
                viewHolder2.tvMsg.setVisibility(8);
                viewHolder2.description.setVisibility(0);
                viewHolder2.readStatus.setVisibility(0);
            } else {
                viewHolder2.readStatus.setText(R.string.hippo_read_more);
                if (n2 > 0 && string2.length() < 160) {
                    viewHolder2.description.setVisibility(0);
                    viewHolder2.tvMsg.setVisibility(8);
                    viewHolder2.readStatus.setVisibility(8);
                } else {
                    viewHolder2.readStatus.setVisibility(0);
                    viewHolder2.tvMsg.setVisibility(0);
                    viewHolder2.description.setVisibility(8);
                }
            }
            String string3 = DateUtils.getInstance().convertToLocal(this.arrayList.get(n).getCreatedAt(), this.outputFormat);
            viewHolder2.dateTime.setText((CharSequence)string3);
            String string4 = "";
            try {
                string4 = this.arrayList.get(n).getCustomAttributes().getImage().getImageUrl();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (TextUtils.isEmpty((CharSequence)string4)) {
                viewHolder2.imageView.setVisibility(8);
            } else {
                viewHolder2.imageView.setVisibility(0);
                RequestOptions requestOptions = (RequestOptions)((RequestOptions)((RequestOptions)((RequestOptions)((RequestOptions)RequestOptions.bitmapTransform((Transformation)new RoundedCornersTransformation(this.mContext, 4, 1)).placeholder(ContextCompat.getDrawable((Context)this.mContext, (int)R.drawable.hippo_placeholder))).fitCenter()).dontAnimate()).diskCacheStrategy(DiskCacheStrategy.ALL)).error(ContextCompat.getDrawable((Context)this.mContext, (int)R.drawable.hippo_placeholder));
                Glide.with((Context)this.mContext).load(string4).apply((BaseRequestOptions)requestOptions).into(viewHolder2.imageView);
            }
            viewHolder2.title.setTypeface(this.customBold);
            viewHolder2.description.setTypeface(this.customNormal);
            viewHolder2.tvMsg.setTypeface(this.customNormal);
            viewHolder2.dateTime.setTypeface(this.customNormal);
        }
    }

    public int getItemCount() {
        return this.arrayList == null ? 0 : this.arrayList.size();
    }

    public int getItemViewType(int n) {
        try {
            if (this.arrayList.get(n).getUserId() == -3) {
                return 2;
            }
            return 1;
        }
        catch (Exception exception) {
            return 1;
        }
    }

    public void showPaginationProgressBar(boolean bl, boolean bl2) {
        boolean bl3;
        if (this.arrayList == null || this.arrayList.size() == 0) {
            return;
        }
        boolean bl4 = bl3 = this.arrayList.get(this.arrayList.size() - 1).getUserId() == -3;
        if (bl) {
            if (!bl3) {
                this.arrayList.add(ProgressBarModel.getInstance());
                if (bl2) {
                    this.recyclerView.post((Runnable)this.getProgressDisplayRunnable(true, this.arrayList.size()));
                }
            }
        } else if (this.arrayList.remove(ProgressBarModel.getInstance()) && bl2) {
            this.recyclerView.post((Runnable)this.getProgressDisplayRunnable(false, this.arrayList.size()));
        }
    }

    private ProgressBarDisplayRunnable getProgressDisplayRunnable(boolean bl, int n) {
        if (this.progressBarDisplayRunnable == null) {
            this.progressBarDisplayRunnable = new ProgressBarDisplayRunnable(this);
        }
        this.progressBarDisplayRunnable.setInsert(bl);
        this.progressBarDisplayRunnable.setPosition(n);
        return this.progressBarDisplayRunnable;
    }

    private static class ProgressBarModel {
        private static Data progressBarModel;

        private ProgressBarModel() {
        }

        public static Data getInstance() {
            if (progressBarModel == null) {
                progressBarModel = new Data(-3);
            }
            return progressBarModel;
        }
    }

    public class ViewHolder
    extends RecyclerView.ViewHolder {
        private LinearLayout mainLayout;
        private ImageView imageView;
        private TextView title;
        private TextView description;
        private TextView dateTime;
        private TextView tvMsg;
        private TextView readStatus;

        public ViewHolder(@NonNull View view) {
            super(view);
            this.mainLayout = (LinearLayout)view.findViewById(R.id.mainLayout);
            this.imageView = (ImageView)view.findViewById(R.id.ivImage);
            this.title = (TextView)view.findViewById(R.id.tvTitle);
            this.description = (TextView)view.findViewById(R.id.tvDescription);
            this.tvMsg = (TextView)view.findViewById(R.id.tvMsg);
            this.readStatus = (TextView)view.findViewById(R.id.readStatus);
            this.dateTime = (TextView)view.findViewById(R.id.tvDateTime);
            this.title.setTextColor(CampaignAdapter.this.hippoColorConfig.getHippoListTextColorPrimary());
            this.dateTime.setTextColor(CampaignAdapter.this.hippoColorConfig.getHippoChannelDateText());
            this.mainLayout.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    if (CampaignAdapter.this.itemClickListener != null) {
                        CampaignAdapter.this.itemClickListener.onClickListener(ViewHolder.this.getAdapterPosition());
                    }
                }
            });
            this.readStatus.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    if (ViewHolder.this.description.getVisibility() == 0) {
                        ((Data)CampaignAdapter.this.arrayList.get(ViewHolder.this.getAdapterPosition())).setShowMore(1);
                    } else {
                        ((Data)CampaignAdapter.this.arrayList.get(ViewHolder.this.getAdapterPosition())).setShowMore(2);
                    }
                    CampaignAdapter.this.notifyItemChanged(ViewHolder.this.getAdapterPosition());
                }
            });
        }
    }

    public class LoadMoreHolder
    extends RecyclerView.ViewHolder {
        public LoadMoreHolder(View view) {
            super(view);
        }
    }
}

