/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.activity;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.view.MenuItem;
import android.view.View;
import android.widget.MediaController;
import android.widget.Toast;
import android.widget.VideoView;
import androidx.annotation.NonNull;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.widget.Toolbar;
import com.hippo.R;
import com.hippo.activity.FuguBaseActivity;
import com.hippo.utils.easypermissions.AfterPermissionGranted;
import com.hippo.utils.easypermissions.AppSettingsDialog;
import com.hippo.utils.easypermissions.EasyPermissions;
import com.hippo.utils.fileUpload.FileManager;
import com.hippo.utils.fileUpload.FileuploadModel;
import java.util.List;

public class VideoPlayerActivity
extends FuguBaseActivity
implements EasyPermissions.PermissionCallbacks {
    private static final String TAG = VideoPlayerActivity.class.getSimpleName();
    private VideoView videoView;
    private Toolbar myToolbar;

    @Override
    protected void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.setContentView(R.layout.activity_video_player);
        this.myToolbar = (Toolbar)this.findViewById(R.id.my_toolbar);
        this.setSupportActionBar(this.myToolbar);
        this.videoView = (VideoView)this.findViewById(R.id.videoView);
        this.readExternalStorage();
        String string2 = TextUtils.isEmpty((CharSequence)this.getIntent().getStringExtra("title")) ? "Video" : this.getIntent().getStringExtra("title");
        this.setToolbar(this.myToolbar, string2);
    }

    private void permissionGranted() {
        MediaController mediaController = new MediaController((Context)this);
        mediaController.setAnchorView((View)this.videoView);
        mediaController.setMediaPlayer((MediaController.MediaPlayerControl)this.videoView);
        mediaController.setEnabled(true);
        this.videoView.setMediaController(mediaController);
        this.videoView.setVideoURI(Uri.parse((String)this.getIntent().getStringExtra("url")));
        this.videoView.requestFocus();
        this.videoView.setOnPreparedListener(new MediaPlayer.OnPreparedListener(){

            public void onPrepared(MediaPlayer mediaPlayer) {
                mediaPlayer.start();
            }
        });
        this.videoView.setOnErrorListener(new MediaPlayer.OnErrorListener(){

            public boolean onError(MediaPlayer mediaPlayer, int n, int n2) {
                VideoPlayerActivity.this.showErrorMessage("File type not supported! Do you want to open with other apps?", "OK", VideoPlayerActivity.this.getIntent().getStringExtra("url"));
                return true;
            }
        });
    }

    public void showErrorMessage(final String string2, final String string3, final String string4) {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                new AlertDialog.Builder((Context)VideoPlayerActivity.this).setMessage((CharSequence)string2).setPositiveButton((CharSequence)string3, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialogInterface, int n) {
                        VideoPlayerActivity.this.openFile(string4);
                        dialogInterface.dismiss();
                    }
                }).setNegativeButton((CharSequence)"Cancel", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialogInterface, int n) {
                        VideoPlayerActivity.this.finish();
                    }
                }).setCancelable(false).show();
            }
        });
    }

    private void openFile(String string2) {
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            FileManager.getInstance().openFileInDevice((Context)this, string2, new FileManager.FileCopyListener(){

                @Override
                public void onCopingFile(boolean bl, FileuploadModel fileuploadModel) {
                }

                @Override
                public void largeFileSize() {
                }

                @Override
                public void onError() {
                    Toast.makeText((Context)VideoPlayerActivity.this, (CharSequence)VideoPlayerActivity.this.getString(R.string.no_handler), (int)1).show();
                    VideoPlayerActivity.this.finish();
                }
            });
        }
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem menuItem) {
        if (menuItem.getItemId() == 16908332) {
            this.onBackPressed();
        }
        return super.onOptionsItemSelected(menuItem);
    }

    public void onBackPressed() {
        super.onBackPressed();
    }

    public void onRequestPermissionsResult(int n, @NonNull String[] stringArray, @NonNull int[] nArray) {
        super.onRequestPermissionsResult(n, stringArray, nArray);
        EasyPermissions.onRequestPermissionsResult(n, stringArray, nArray, this);
    }

    @AfterPermissionGranted(value=123)
    private void readExternalStorage() {
        boolean bl = EasyPermissions.hasPermissions((Context)this, "android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE");
        if (bl) {
            this.permissionGranted();
        } else {
            EasyPermissions.requestPermissions((Activity)this, this.getString(R.string.vw_rationale_storage), 123, "android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE");
        }
    }

    @Override
    public void onPermissionsGranted(int n, List<String> list) {
        Log.d((String)TAG, (String)("onPermissionsGranted:" + n + ":" + list.size()));
        this.permissionGranted();
    }

    @Override
    public void onPermissionsDenied(int n, List<String> list) {
        Log.d((String)TAG, (String)("onPermissionsDenied:" + n + ":" + list.size()));
        if (EasyPermissions.somePermissionPermanentlyDenied((Activity)this, list)) {
            new AppSettingsDialog.Builder((Activity)this).build().show();
        } else {
            this.finish();
        }
    }

    protected void onActivityResult(int n, int n2, Intent intent) {
        super.onActivityResult(n, n2, intent);
        if (n == 16061) {
            if (EasyPermissions.hasPermissions((Context)this, "android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE")) {
                this.permissionGranted();
            } else {
                this.finish();
            }
        }
    }
}

