/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.activity;

import android.animation.ObjectAnimator;
import android.app.DownloadManager;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.text.TextUtils;
import android.text.format.DateUtils;
import android.util.Property;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.FragmentActivity;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.request.BaseRequestOptions;
import com.bumptech.glide.request.RequestOptions;
import com.bumptech.glide.request.target.CustomViewTarget;
import com.bumptech.glide.request.target.Target;
import com.bumptech.glide.request.transition.Transition;
import com.hippo.R;
import com.hippo.activity.FuguBaseActivity;
import com.hippo.agent.database.AgentCommonData;
import com.hippo.constant.FuguAppConstant;
import com.hippo.database.CommonData;
import com.hippo.model.Image;
import com.hippo.utils.filepicker.Util;
import com.hippo.utils.loadingBox.ProgressWheel;
import com.hippo.utils.zoomview.ZoomageView;
import java.text.SimpleDateFormat;
import java.util.Locale;

public class ImageDisplayActivity
extends FuguBaseActivity {
    private static final String TAG = ImageDisplayActivity.class.getSimpleName();
    private String imageUrl = "";
    ImageView ivImage;
    ImageView ivDownload;
    LinearLayout llTopBar;
    TextView tvDateTime;
    ZoomageView ivOriginalImage;
    ProgressWheel progressWheel;
    private RelativeLayout mainLayout;

    @Override
    protected void onCreate(Bundle bundle) {
        String string2;
        String string3;
        super.onCreate(bundle);
        this.setContentView(R.layout.hippo_activity_image_display);
        this.progressWheel = (ProgressWheel)this.findViewById(R.id.progress);
        this.progressWheel.spin();
        this.mainLayout = (RelativeLayout)this.findViewById(R.id.main_layout);
        this.ivImage = (ImageView)this.findViewById(R.id.ivMsgImage);
        this.ivDownload = (ImageView)this.findViewById(R.id.ivDownload);
        this.ivOriginalImage = (ZoomageView)this.findViewById(R.id.ivOriginalImage);
        this.llTopBar = (LinearLayout)this.findViewById(R.id.llTopBar);
        TextView textView = (TextView)this.findViewById(R.id.tvChannelName);
        this.tvDateTime = (TextView)this.findViewById(R.id.tvDateTime);
        ImageView imageView = (ImageView)this.findViewById(R.id.ivBack);
        final Image image = (Image)this.getIntent().getSerializableExtra("image");
        if (!TextUtils.isEmpty((CharSequence)image.getChannelName())) {
            textView.setText((CharSequence)image.getChannelName());
        } else {
            textView.setText((CharSequence)"Message");
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd MMM, hh:mm a");
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("hh:mm a");
        SimpleDateFormat simpleDateFormat3 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.ENGLISH);
        try {
            string3 = simpleDateFormat.format(simpleDateFormat3.parse(com.hippo.utils.DateUtils.getInstance().convertToLocal(image.getDateTime())));
            if (DateUtils.isToday((long)simpleDateFormat3.parse(com.hippo.utils.DateUtils.getInstance().convertToLocal(image.getDateTime())).getTime())) {
                string2 = simpleDateFormat2.format(simpleDateFormat3.parse(com.hippo.utils.DateUtils.getInstance().convertToLocal(image.getDateTime())));
                this.tvDateTime.setText((CharSequence)("Today, " + string2));
            } else {
                this.tvDateTime.setText((CharSequence)simpleDateFormat.format(simpleDateFormat3.parse(com.hippo.utils.DateUtils.getInstance().convertToLocal(image.getDateTime()))));
            }
        }
        catch (Exception exception) {
            this.tvDateTime.setVisibility(8);
        }
        imageView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                ImageDisplayActivity.this.onBackPressed();
            }
        });
        this.ivDownload.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                ImageDisplayActivity.this.downloadFile(image.getImageUrl());
            }
        });
        this.supportPostponeEnterTransition();
        new RequestOptions();
        string3 = (RequestOptions)((RequestOptions)((RequestOptions)((RequestOptions)((RequestOptions)RequestOptions.placeholderOf((int)R.drawable.hippo_placeholder).dontAnimate()).onlyRetrieveFromCache(true)).diskCacheStrategy(DiskCacheStrategy.ALL)).error(R.drawable.hippo_call_placeholder)).dontTransform();
        string2 = (RequestOptions)((RequestOptions)((RequestOptions)((RequestOptions)new RequestOptions().dontAnimate()).diskCacheStrategy(DiskCacheStrategy.ALL)).error(R.drawable.hippo_call_placeholder)).dontTransform();
        String string4 = image.getImageUrl();
        Glide.with((FragmentActivity)this).load(image.getThumbnailUrl()).apply((BaseRequestOptions)string3).into((Target)new CustomViewTarget<RelativeLayout, Drawable>(this.mainLayout, (RequestOptions)string2, string4, image){
            final /* synthetic */ RequestOptions val$requestOptions2;
            final /* synthetic */ String val$url;
            final /* synthetic */ Image val$image;
            {
                this.val$requestOptions2 = requestOptions;
                this.val$url = string2;
                this.val$image = image;
                super((View)relativeLayout);
            }

            public void onLoadFailed(@Nullable Drawable drawable2) {
                ImageDisplayActivity.this.ivImage.setVisibility(8);
                ImageDisplayActivity.this.progressWheel.setVisibility(8);
                Glide.with((FragmentActivity)ImageDisplayActivity.this).asBitmap().apply((BaseRequestOptions)this.val$requestOptions2).load(this.val$url).into((ImageView)ImageDisplayActivity.this.ivOriginalImage);
            }

            public void onResourceReady(@NonNull Drawable drawable2, @Nullable Transition<? super Drawable> transition) {
                ImageDisplayActivity.this.supportStartPostponedEnterTransition();
                ImageDisplayActivity.this.ivImage.setVisibility(0);
                ImageDisplayActivity.this.ivImage.setImageDrawable(drawable2);
                ImageDisplayActivity.this.progressWheel.setVisibility(8);
                new ObjectAnimator();
                ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)ImageDisplayActivity.this.llTopBar, (Property)View.ALPHA, (float[])new float[]{0.0f, 1.0f});
                objectAnimator.setDuration(500L);
                objectAnimator.setStartDelay(200L);
                objectAnimator.start();
                new Handler().postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        Glide.with((FragmentActivity)ImageDisplayActivity.this).load(val$image.getImageUrl()).apply((BaseRequestOptions)val$requestOptions2).into((Target)new CustomViewTarget<RelativeLayout, Drawable>(ImageDisplayActivity.this.mainLayout){

                            protected void onResourceCleared(@Nullable Drawable drawable2) {
                            }

                            public void onLoadFailed(@Nullable Drawable drawable2) {
                                ImageDisplayActivity.this.ivImage.setVisibility(8);
                                ImageDisplayActivity.this.progressWheel.setVisibility(8);
                                Glide.with((FragmentActivity)ImageDisplayActivity.this).asBitmap().apply((BaseRequestOptions)val$requestOptions2).load(val$url).into((ImageView)ImageDisplayActivity.this.ivOriginalImage);
                            }

                            public void onResourceReady(@NonNull Drawable drawable2, @Nullable Transition<? super Drawable> transition) {
                                ImageDisplayActivity.this.supportStartPostponedEnterTransition();
                                ImageDisplayActivity.this.ivImage.setVisibility(8);
                                ImageDisplayActivity.this.ivOriginalImage.setImageDrawable(drawable2);
                            }
                        });
                    }
                }, 500L);
            }

            protected void onResourceCleared(@Nullable Drawable drawable2) {
            }
        });
    }

    public void onBackPressed() {
        super.onBackPressed();
    }

    private Long downloadFile(String string2) {
        String string3 = Util.extractFileNameWithoutSuffix(string2);
        String string4 = Util.getExtension(string2);
        DownloadManager.Request request = new DownloadManager.Request(Uri.parse((String)string2));
        if (AgentCommonData.isAgentFlow()) {
            request.setDescription((CharSequence)AgentCommonData.getUserData().getBusinessName());
        } else {
            request.setDescription((CharSequence)CommonData.getUserDetails().getData().getBusinessName());
        }
        request.setTitle((CharSequence)string3);
        request.allowScanningByMediaScanner();
        request.setNotificationVisibility(1);
        String string5 = Util.getOrCreateDirectoryPath(FuguAppConstant.DocumentType.IMAGE.toString());
        request.setDestinationInExternalPublicDir(string5, string3 + string4);
        request.setMimeType("image/jpeg");
        DownloadManager downloadManager = (DownloadManager)this.getSystemService("download");
        if (downloadManager != null) {
            return downloadManager.enqueue(request);
        }
        return null;
    }
}

