/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.activity;

import android.app.Activity;
import android.app.ActivityManager;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.Bundle;
import android.view.MenuItem;
import android.view.View;
import android.view.Window;
import android.view.inputmethod.InputMethodManager;
import android.widget.TextView;
import androidx.annotation.RequiresApi;
import androidx.appcompat.app.ActionBar;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.hippo.HippoConfig;
import com.hippo.R;
import com.hippo.constant.FuguAppConstant;
import com.hippo.database.CommonData;
import com.hippo.retrofit.APIError;
import com.hippo.retrofit.CommonParams;
import com.hippo.retrofit.CommonResponse;
import com.hippo.retrofit.ResponseResolver;
import com.hippo.retrofit.RestClient;
import com.hippo.utils.HippoLog;
import com.hippo.utils.fileUpload.FileuploadModel;
import com.hippo.utils.fileUpload.Prefs;
import com.hippo.utils.filepicker.MyForeGroundService;
import io.github.inflationx.viewpump.ViewPumpContextWrapper;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;
import retrofit2.Callback;

public class FuguBaseActivity
extends AppCompatActivity
implements FuguAppConstant {
    private static final String TAG = FuguBaseActivity.class.getSimpleName();
    public Type fileuploadType = new TypeToken<List<FileuploadModel>>(){}.getType();
    private TextView titleView;

    protected void attachBaseContext(Context context) {
        super.attachBaseContext((Context)ViewPumpContextWrapper.wrap((Context)context));
    }

    protected void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        if (Build.VERSION.SDK_INT >= 21) {
            this.setStatusBarColor();
        }
        this.uncaughtExceptionError();
    }

    @RequiresApi(api=21)
    private void setStatusBarColor() {
        Window window = this.getWindow();
        window.addFlags(Integer.MIN_VALUE);
        window.clearFlags(0x4000000);
        window.getDecorView().setSystemUiVisibility(8192);
        window.setStatusBarColor(CommonData.getColorConfig().getHippoStatusBar());
    }

    protected void checkAutoUpload() {
        if (!this.isMyServiceRunning(MyForeGroundService.class)) {
            ArrayList arrayList = (ArrayList)new Gson().fromJson(Prefs.with((Context)this).getString("pref_upload_data", ""), this.fileuploadType);
            if (arrayList == null) {
                return;
            }
            HippoLog.e("TAG", "fileuploadModels data = " + new Gson().toJson((Object)arrayList));
            if (arrayList.size() > 0) {
                Intent intent = new Intent(this.getBaseContext(), MyForeGroundService.class);
                intent.setAction("start");
                if (Build.VERSION.SDK_INT >= 26) {
                    this.startForegroundService(intent);
                } else {
                    this.startService(intent);
                }
            }
        }
    }

    protected boolean isMyServiceRunning(Class<?> clazz) {
        ActivityManager activityManager = (ActivityManager)this.getSystemService("activity");
        for (ActivityManager.RunningServiceInfo runningServiceInfo : activityManager.getRunningServices(Integer.MAX_VALUE)) {
            if (!clazz.getName().equals(runningServiceInfo.service.getClassName())) continue;
            return true;
        }
        return false;
    }

    private void uncaughtExceptionError() {
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread thread, Throwable throwable) {
                HippoLog.e("unCaughtException paramThread", "---> " + thread.toString());
                HippoLog.e("unCaughtException paramThrowable", "---> " + throwable.toString());
                StringWriter stringWriter = new StringWriter();
                throwable.printStackTrace(new PrintWriter(stringWriter));
                HippoLog.e("unCaughtException stackTrace", "---> " + stringWriter);
                System.err.println(stringWriter);
                if (!HippoConfig.DEBUG) {
                    FuguBaseActivity.this.apiSendError(stringWriter.toString());
                }
            }
        });
    }

    public void apiSendError(String string2) {
        if (this.isNetworkAvailable()) {
            PackageInfo packageInfo = null;
            try {
                packageInfo = this.getPackageManager().getPackageInfo(this.getPackageName(), 0);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                nameNotFoundException.printStackTrace();
            }
            JSONObject jSONObject = new JSONObject();
            try {
                jSONObject.put("log", (Object)string2);
                if (packageInfo != null) {
                    jSONObject.put("version", packageInfo.versionCode);
                }
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("app_secret_key", HippoConfig.getInstance().getAppKey());
            hashMap.put("device_type", 1);
            hashMap.put("app_version", 251);
            hashMap.put("device_details", CommonData.deviceDetails((Context)this));
            hashMap.put("error", jSONObject.toString());
            CommonParams commonParams = new CommonParams.Builder().putMap(hashMap).build();
            RestClient.getApiInterface().sendError(commonParams.getMap()).enqueue((Callback)new ResponseResolver<CommonResponse>((Activity)this, Boolean.valueOf(false), Boolean.valueOf(true)){

                @Override
                public void success(CommonResponse commonResponse) {
                    HippoLog.v("success", commonResponse.toString());
                }

                @Override
                public void failure(APIError aPIError) {
                    HippoLog.v("failure", aPIError.toString());
                }
            });
        }
    }

    public boolean isNetworkAvailable() {
        ConnectivityManager connectivityManager = (ConnectivityManager)this.getSystemService("connectivity");
        NetworkInfo networkInfo = null;
        if (connectivityManager != null) {
            networkInfo = connectivityManager.getActiveNetworkInfo();
        }
        return networkInfo != null && networkInfo.isConnected();
    }

    public boolean onOptionsItemSelected(MenuItem menuItem) {
        if (menuItem.getItemId() == 16908332) {
            this.finish();
        }
        return super.onOptionsItemSelected(menuItem);
    }

    public ActionBar setToolbar(Toolbar toolbar, String string2, String string3) {
        ActionBar actionBar = this.getSupportActionBar();
        if (actionBar != null) {
            actionBar.setDisplayHomeAsUpEnabled(true);
            actionBar.setBackgroundDrawable((Drawable)new ColorDrawable(CommonData.getColorConfig().getHippoActionBarBg()));
            toolbar.setTitleTextColor(CommonData.getColorConfig().getHippoActionBarText());
            toolbar.setSubtitleTextColor(CommonData.getColorConfig().getHippoActionBarText());
            actionBar.setHomeAsUpIndicator(R.drawable.hippo_ic_arrow_back);
            actionBar.setTitle((CharSequence)string2);
            actionBar.setSubtitle((CharSequence)string3);
        }
        return this.getSupportActionBar();
    }

    protected void hideKeyboard(Activity activity) {
        try {
            View view = activity.getCurrentFocus();
            InputMethodManager inputMethodManager = (InputMethodManager)activity.getSystemService("input_method");
            inputMethodManager.hideSoftInputFromWindow(view.getWindowToken(), 0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public ActionBar setToolbar(Toolbar toolbar, String string2) {
        ActionBar actionBar = this.getSupportActionBar();
        if (actionBar != null) {
            actionBar.setDisplayHomeAsUpEnabled(true);
            actionBar.setBackgroundDrawable((Drawable)new ColorDrawable(CommonData.getColorConfig().getHippoActionBarBg()));
            actionBar.setHomeAsUpIndicator(R.drawable.hippo_ic_arrow_back);
            if (HippoConfig.getInstance().getHomeUpIndicatorDrawableId() != -1) {
                actionBar.setHomeAsUpIndicator(HippoConfig.getInstance().getHomeUpIndicatorDrawableId());
            }
            actionBar.setTitle((CharSequence)"");
            toolbar.setTitleTextColor(CommonData.getColorConfig().getHippoActionBarText());
            ((TextView)toolbar.findViewById(R.id.tv_toolbar_name)).setText((CharSequence)string2);
            ((TextView)toolbar.findViewById(R.id.tv_toolbar_name)).setTextColor(CommonData.getColorConfig().getHippoActionBarText());
        }
        return this.getSupportActionBar();
    }

    public ActionBar setToolbar(Toolbar toolbar, String string2, boolean bl) {
        ActionBar actionBar = this.getSupportActionBar();
        if (actionBar != null) {
            actionBar.setDisplayHomeAsUpEnabled(true);
            actionBar.setBackgroundDrawable((Drawable)new ColorDrawable(CommonData.getColorConfig().getHippoActionBarBg()));
            actionBar.setHomeAsUpIndicator(R.drawable.hippo_ic_arrow_back);
            actionBar.setDisplayHomeAsUpEnabled(false);
            actionBar.setHomeButtonEnabled(false);
            if (HippoConfig.getInstance().getHomeUpIndicatorDrawableId() != -1) {
                actionBar.setHomeAsUpIndicator(HippoConfig.getInstance().getHomeUpIndicatorDrawableId());
            }
            actionBar.setTitle((CharSequence)"");
            toolbar.setTitleTextColor(CommonData.getColorConfig().getHippoActionBarText());
            this.titleView = (TextView)toolbar.findViewById(R.id.tv_toolbar_name);
            this.titleView.setText((CharSequence)string2);
            this.titleView.setTextColor(CommonData.getColorConfig().getHippoActionBarText());
        }
        return this.getSupportActionBar();
    }

    public ActionBar setToolbarNew(Toolbar toolbar, String string2) {
        ActionBar actionBar = this.setToolbarNew(toolbar, string2, true);
        return actionBar;
    }

    public ActionBar setToolbarNew(Toolbar toolbar, String string2, boolean bl) {
        this.setSupportActionBar(toolbar);
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(bl);
        this.getSupportActionBar().setDisplayShowTitleEnabled(false);
        ((TextView)toolbar.findViewById(R.id.tv_toolbar_name)).setText((CharSequence)string2);
        return this.getSupportActionBar();
    }

    public void updateTitle(Toolbar toolbar, String string2) {
        if (this.titleView == null) {
            this.titleView = (TextView)toolbar.findViewById(R.id.tv_toolbar_name);
        }
        this.titleView.setText((CharSequence)string2);
    }

    public void showErrorMessage(String string2, String string3) {
        this.showErrorMessage(string2, string3, false);
    }

    public void showErrorMessage(final String string2, final String string3, final boolean bl) {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                new AlertDialog.Builder((Context)FuguBaseActivity.this).setMessage((CharSequence)string2).setPositiveButton((CharSequence)string3, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialogInterface, int n) {
                        if (bl) {
                            FuguBaseActivity.this.finish();
                        }
                    }
                }).setCancelable(false).show();
            }
        });
    }

    protected void onPause() {
        super.onPause();
        if (HippoConfig.getInstance().getLifeCyclerListener() != null) {
            HippoConfig.getInstance().getLifeCyclerListener().onPause();
        }
    }

    protected void onResume() {
        super.onResume();
        if (HippoConfig.getInstance().getLifeCyclerListener() != null) {
            HippoConfig.getInstance().getLifeCyclerListener().onResume();
        }
    }
}

