/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.activity;

import android.content.Context;
import android.content.IntentFilter;
import android.os.Bundle;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.google.android.material.tabs.TabLayout;
import com.hippo.HippoConfig;
import com.hippo.LibApp;
import com.hippo.R;
import com.hippo.activity.FuguBaseActivity;
import com.hippo.adapter.TabAdapter;
import com.hippo.fragment.CampaignFragment;
import com.hippo.fragment.ChannelTypeFragment;
import com.hippo.utils.CustomViewPager;
import faye.ConnectionManager;

public class ChannelActivity
extends FuguBaseActivity
implements ViewPager.OnPageChangeListener {
    private CustomViewPager viewPager;
    private TabLayout tabLayout;
    private boolean isPromotionalPush;
    private boolean hasPager;
    private int position = 0;
    private TabAdapter pagerAdapter;
    String[] titles = new String[2];
    private int[] tabIcons = new int[]{R.drawable.ic_chat_tab, R.drawable.ic_btn_notification};

    @Override
    protected void onCreate(Bundle bundle) {
        block6: {
            super.onCreate(bundle);
            this.setContentView(R.layout.activity_channle_pager);
            try {
                LibApp.getInstance().screenOpened("List Screen");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (HippoConfig.getInstance().getMobileCampaignBuilder() != null) {
                    this.hasPager = HippoConfig.getInstance().getMobileCampaignBuilder().hasCampaignPager();
                }
            }
            catch (Exception exception) {
                if (!HippoConfig.DEBUG) break block6;
                exception.printStackTrace();
            }
        }
        this.isPromotionalPush = this.getIntent().getBooleanExtra("is_promotional_push", false);
        this.viewPager = (CustomViewPager)this.findViewById(R.id.pagerView);
        this.tabLayout = (TabLayout)this.findViewById(R.id.tabs);
        if (!this.hasPager) {
            this.tabLayout.setVisibility(8);
        }
        this.viewPager.setPagingEnabled(false);
        this.viewPager.addOnPageChangeListener(this);
        this.loadPage();
        ConnectionManager.INSTANCE.initFayeConnection();
    }

    private void loadPage() {
        this.titles[0] = "Chats";
        this.titles[1] = "Notifications";
        this.pagerAdapter = new TabAdapter(this.getSupportFragmentManager(), (Context)this);
        this.pagerAdapter.addFragment(new ChannelTypeFragment(), this.titles[0], this.tabIcons[0]);
        if (this.hasPager) {
            this.pagerAdapter.addFragment(new CampaignFragment(), this.titles[1], this.tabIcons[1]);
            this.tabLayout.setVisibility(0);
        } else {
            this.tabLayout.setVisibility(8);
        }
        this.viewPager.setAdapter((PagerAdapter)this.pagerAdapter);
        if (this.hasPager) {
            this.tabLayout.setupWithViewPager((ViewPager)this.viewPager);
            this.highLightCurrentTab(0);
            this.tabLayout.addOnTabSelectedListener((TabLayout.OnTabSelectedListener)new TabLayout.ViewPagerOnTabSelectedListener(this.viewPager){

                public void onTabReselected(TabLayout.Tab tab) {
                    super.onTabReselected(tab);
                }

                public void onTabSelected(TabLayout.Tab tab) {
                    super.onTabSelected(tab);
                }

                public void onTabUnselected(TabLayout.Tab tab) {
                    super.onTabUnselected(tab);
                }
            });
        }
        if (this.isPromotionalPush && this.hasPager) {
            this.isPromotionalPush = false;
            this.viewPager.setCurrentItem(1);
        }
    }

    private void highLightCurrentTab(int n) {
        for (int j = 0; j < this.tabLayout.getTabCount(); ++j) {
            TabLayout.Tab tab = this.tabLayout.getTabAt(j);
            assert (tab != null);
            tab.setCustomView(null);
            tab.setCustomView(this.pagerAdapter.getTabView(j));
        }
        TabLayout.Tab tab = this.tabLayout.getTabAt(n);
        assert (tab != null);
        tab.setCustomView(null);
        tab.setCustomView(this.pagerAdapter.getSelectedTabView(n));
    }

    @Override
    protected void onResume() {
        super.onResume();
    }

    protected void onDestroy() {
        super.onDestroy();
        this.viewPager.removeOnPageChangeListener(this);
    }

    public void onBackPressed() {
        super.onBackPressed();
    }

    public void onPageScrolled(int n, float f2, int n2) {
        this.position = n;
    }

    public void onPageSelected(int n) {
        this.highLightCurrentTab(n);
    }

    public void onPageScrollStateChanged(int n) {
    }

    private IntentFilter getIntentFilter() {
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("network_state_changed");
        intentFilter.addAction("notification_tapped");
        return intentFilter;
    }
}

