/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils.swipetoshow;

import android.content.Context;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import androidx.recyclerview.widget.RecyclerView;
import com.hippo.utils.swipetoshow.SwipeHolder;

public abstract class SwipeOnItemTouchAdapter
implements RecyclerView.OnItemTouchListener {
    private Context context;
    private RecyclerView recyclerView;
    private RecyclerView.LayoutManager layoutManager;
    private final int TOUCH_SLOP;
    int startX;
    int startY;
    boolean beginSlide;
    boolean beginScroll;
    boolean animatingPollute;
    SwipeHolder targetView;
    SwipeHolder animatingView;
    int targetPosition;
    boolean pendingHiddenClick;
    private boolean enableSwipe;

    public SwipeOnItemTouchAdapter(Context context, RecyclerView recyclerView, RecyclerView.LayoutManager layoutManager) {
        this.TOUCH_SLOP = ViewConfiguration.get((Context)context).getScaledTouchSlop();
        this.context = context;
        this.recyclerView = recyclerView;
        this.layoutManager = layoutManager;
    }

    public boolean onInterceptTouchEvent(RecyclerView recyclerView, MotionEvent motionEvent) {
        if (this.enableSwipe) {
            return false;
        }
        if (this.animatingView != null && this.animatingView.isAnimating()) {
            this.animatingPollute = true;
            return true;
        }
        this.animatingView = null;
        switch (motionEvent.getAction()) {
            case 0: {
                this.startX = (int)motionEvent.getX();
                this.startY = (int)motionEvent.getY();
                this.beginSlide = false;
                this.beginScroll = false;
                this.animatingPollute = false;
                if (this.targetView == null) break;
                float f2 = this.startX;
                float f3 = this.startY;
                if (this.isXInHiddenView(f2, f3)) {
                    this.pendingHiddenClick = true;
                    break;
                }
                this.targetView.animateCollapse();
                this.animatingView = this.targetView;
                this.targetView = null;
                this.targetPosition = -1;
                break;
            }
            case 2: {
                if (this.animatingPollute) {
                    return false;
                }
                if (this.beginScroll) {
                    return false;
                }
                if (this.beginSlide) {
                    return true;
                }
                if (this.beginSlide) break;
                int n = (int)(motionEvent.getX() - (float)this.startX);
                int n2 = (int)(motionEvent.getY() - (float)this.startY);
                if (Math.abs(n) > this.TOUCH_SLOP) {
                    if (!(recyclerView.findChildViewUnder(motionEvent.getX(), motionEvent.getY()) instanceof SwipeHolder)) {
                        return false;
                    }
                    this.beginSlide = true;
                    this.targetView = (SwipeHolder)recyclerView.findChildViewUnder(motionEvent.getX(), motionEvent.getY());
                    if (this.targetView == null) {
                        this.beginSlide = false;
                        return false;
                    }
                    this.targetPosition = this.layoutManager.getPosition((View)this.targetView);
                    this.startX = (int)motionEvent.getX();
                    return true;
                }
                if (Math.abs(n2) <= this.TOUCH_SLOP) break;
                this.beginScroll = true;
                return false;
            }
            case 1: {
                View view;
                if (this.animatingPollute) {
                    this.animatingPollute = false;
                    return false;
                }
                if (this.targetView != null) {
                    int n;
                    int n3 = (int)motionEvent.getX();
                    if (!this.isXInHiddenView(n3, n = (int)motionEvent.getY())) break;
                    this.onItemHiddenClick(this.targetView, this.targetPosition);
                    this.targetView = null;
                    break;
                }
                if (this.beginSlide || this.beginScroll || this.targetView != null || (view = recyclerView.findChildViewUnder(motionEvent.getX(), motionEvent.getY())) == null) break;
                int n = this.layoutManager.getPosition(view);
                this.onItemClick(n);
                break;
            }
            case 3: {
                this.beginSlide = false;
                this.beginScroll = false;
                this.animatingPollute = false;
            }
        }
        return false;
    }

    public void onTouchEvent(RecyclerView recyclerView, MotionEvent motionEvent) {
        if (this.animatingView != null && this.animatingView.isAnimating()) {
            this.animatingPollute = true;
            return;
        }
        this.animatingView = null;
        switch (motionEvent.getAction()) {
            case 2: {
                if (this.animatingPollute) {
                    return;
                }
                this.targetView.slide((int)((float)this.startX - motionEvent.getX()));
                break;
            }
            case 1: {
                if (this.animatingPollute) {
                    this.animatingPollute = false;
                    return;
                }
                boolean bl = this.targetView.determineShowOrHide();
                if (bl) break;
                this.targetView = null;
                this.targetPosition = -1;
            }
        }
    }

    public boolean isBusy() {
        return this.targetView != null;
    }

    public void onRequestDisallowInterceptTouchEvent(boolean bl) {
    }

    private boolean isXInHiddenView(float f2, float f3) {
        return this.recyclerView.findChildViewUnder(f2, f3) == this.targetView && this.targetView.isXInHideArea((int)f2);
    }

    public abstract void onItemHiddenClick(SwipeHolder var1, int var2);

    public abstract void onItemClick(int var1);

    public void setEnableSwipe(boolean bl) {
        this.enableSwipe = bl;
    }
}

