/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils.swipetoshow;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.DecelerateInterpolator;
import android.widget.FrameLayout;
import com.hippo.utils.swipetoshow.HideContentHolder;

public class SwipeHolder
extends FrameLayout {
    private static final int ALIGN_ANIMATION_DURATION = 200;
    private HideContentHolder hideContentHolder;
    private View mainContent;
    boolean animating;

    public SwipeHolder(Context context) {
        super(context);
    }

    public SwipeHolder(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
    }

    public SwipeHolder(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.hideContentHolder = (HideContentHolder)this.getChildAt(0);
        this.mainContent = this.getChildAt(1);
    }

    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        this.hideContentHolder.layout(n3 - this.hideContentHolder.getMeasuredWidth(), 0, n3, this.hideContentHolder.getMeasuredHeight());
        this.mainContent.layout(0, 0, n3, this.mainContent.getMeasuredHeight());
    }

    protected void slide(int n) {
        if (n < 0) {
            this.mainContent.scrollTo(0, 0);
            this.hideContentHolder.setShowPixel(0);
            return;
        }
        int n2 = this.hideContentHolder.getWidth();
        if (n > n2) {
            float f2 = n - n2;
            this.mainContent.scrollTo((int)((float)n2 + f2 * (1.0f - f2 / (float)n)), 0);
        } else {
            this.mainContent.scrollTo(n, 0);
        }
        this.hideContentHolder.setShowPixel(n);
    }

    public void reset() {
        this.mainContent.scrollTo(0, 0);
        this.hideContentHolder.setShowPixel(0);
    }

    public boolean isAnimating() {
        return this.animating;
    }

    void animatedAlignShow() {
        final int n = this.hideContentHolder.getWidth();
        final int n2 = this.mainContent.getScrollX() - n;
        final int n3 = this.hideContentHolder.getShowPixel() - n;
        ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f});
        valueAnimator.setDuration(200L);
        valueAnimator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                float f2 = valueAnimator.getAnimatedFraction();
                SwipeHolder.this.mainContent.scrollTo(n + (int)((float)n2 * (1.0f - f2)), 0);
                SwipeHolder.this.hideContentHolder.setShowPixel(n + (int)((float)n3 * (1.0f - f2)));
            }
        });
        valueAnimator.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animator) {
            }

            public void onAnimationEnd(Animator animator) {
                SwipeHolder.this.mainContent.scrollTo(n, 0);
                SwipeHolder.this.animating = false;
            }

            public void onAnimationCancel(Animator animator) {
            }

            public void onAnimationRepeat(Animator animator) {
            }
        });
        valueAnimator.start();
        this.animating = true;
    }

    void animateCollapse() {
        final int n = this.hideContentHolder.getShowPixel();
        final int n2 = this.mainContent.getScrollX();
        ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f});
        valueAnimator.setDuration(200L);
        valueAnimator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                float f2 = valueAnimator.getAnimatedFraction();
                SwipeHolder.this.mainContent.scrollTo((int)((float)n2 * (1.0f - f2)), 0);
                SwipeHolder.this.hideContentHolder.setShowPixel((int)((float)n * (1.0f - f2)));
            }
        });
        valueAnimator.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animator) {
            }

            public void onAnimationEnd(Animator animator) {
                SwipeHolder.this.mainContent.scrollTo(0, 0);
                SwipeHolder.this.hideContentHolder.setShowPixel(0);
                SwipeHolder.this.animating = false;
            }

            public void onAnimationCancel(Animator animator) {
            }

            public void onAnimationRepeat(Animator animator) {
            }
        });
        valueAnimator.start();
        this.animating = true;
    }

    protected boolean isXInHideArea(int n) {
        return n > this.hideContentHolder.getLeft();
    }

    protected boolean determineShowOrHide() {
        if (this.hideContentHolder.getShowPixel() < this.hideContentHolder.getWidth() / 3) {
            this.animateCollapse();
            return false;
        }
        this.animatedAlignShow();
        return true;
    }
}

