/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils.swipeLayout;

import android.animation.ObjectAnimator;
import android.content.Context;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import com.hippo.utils.swipeLayout.listener.LayoutShiftListener;
import com.hippo.utils.swipeLayout.listener.OnLayoutPercentageChangeListener;
import com.hippo.utils.swipeLayout.listener.OnLayoutSwipedListener;
import java.util.HashSet;
import java.util.Set;

public class SwipeGestureManager
implements View.OnTouchListener {
    private OnLayoutSwipedListener onSwipedListener;
    private OnLayoutPercentageChangeListener onLayoutPercentageChangeListener;
    private LayoutShiftListener layoutShiftListener;
    private float swipeSpeed;
    private int orientationMode;
    private Set<Integer> blocks;
    private float firstXPosition;
    private float firstYPosition;
    private int lastXPosition;
    private int lastYPosition;
    private int currentXPosition;
    private int currentYPosition;
    private int shiftX;
    private int shiftY;
    private int lastMotion = -1;
    private Context context;
    private final GestureDetector gestureDetector;
    private boolean isSwipeable = true;
    private View view = null;

    private SwipeGestureManager(Context context, float f2, float f3, float f4, int n) {
        this.context = context;
        this.firstXPosition = f2;
        this.firstYPosition = f3;
        this.swipeSpeed = f4;
        this.orientationMode = n;
        this.blocks = new HashSet<Integer>();
        this.gestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)new FlingGestureDetector());
    }

    public boolean onTouch(View view, MotionEvent motionEvent) {
        try {
            boolean bl;
            this.view = view;
            switch (this.orientationMode) {
                case 1: {
                    bl = this.swipeByY(view, motionEvent);
                    break;
                }
                default: {
                    bl = false;
                }
            }
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void isSwipeable(boolean bl) {
        this.isSwipeable = bl;
    }

    public void customRollBack(float f2) {
        if (this.view != null) {
            this.rollback(this.view, "y", this.view.getY(), this.firstYPosition);
        }
    }

    private boolean swipeByY(View view, MotionEvent motionEvent) {
        if (this.isSwipeable && !this.blocks.contains(1)) {
            if (this.gestureDetector.onTouchEvent(motionEvent)) {
                return true;
            }
            int n = (int)motionEvent.getRawY();
            int n2 = view.getHeight();
            float f2 = Math.abs(view.getY()) / (float)(n2 / 4);
            if (motionEvent.getActionMasked() == 0) {
                this.lastYPosition = n;
                this.currentYPosition = (int)view.getY();
                this.lastMotion = 0;
            } else if (motionEvent.getActionMasked() == 2) {
                this.shiftY = n - this.lastYPosition;
                view.setY((float)this.currentYPosition + (float)this.shiftY * this.swipeSpeed);
                if (this.onLayoutPercentageChangeListener != null && (double)f2 > 0.1) {
                    this.onLayoutPercentageChangeListener.percentageY(f2 > 1.0f ? 1.0f : f2);
                }
                this.triggerPositionChangeListener(this.shiftX, this.shiftY, true);
                this.lastMotion = 2;
            } else if (motionEvent.getActionMasked() == 1) {
                this.triggerPositionChangeListener(this.shiftX, this.shiftY, false);
                this.lastMotion = 1;
                if ((double)f2 > 1.0) {
                    this.triggerSwipeListener();
                }
                this.rollback(view, "y", view.getY(), this.firstYPosition);
            } else if (motionEvent.getActionMasked() == 3) {
                return false;
            }
        }
        return true;
    }

    private boolean swipeByX(View view, MotionEvent motionEvent) {
        return true;
    }

    public void rollback(View view, String string2, float f2, float f3) {
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)view, (String)string2, (float[])new float[]{f2, f3});
        objectAnimator.setDuration(300L);
        objectAnimator.start();
    }

    public void addBlock(int n) {
        this.blocks.add(n);
    }

    public void setBlockSet(Set<Integer> set) {
        this.blocks.addAll(set);
    }

    public void removeBlock(int n) {
        this.blocks.remove(n);
    }

    public void setSwipeSpeed(int n) {
        this.swipeSpeed = n;
    }

    public void setOrientationMode(int n) {
        this.orientationMode = n;
    }

    public void setOnSwipedListener(OnLayoutSwipedListener onLayoutSwipedListener) {
        this.onSwipedListener = onLayoutSwipedListener;
    }

    public void setOnLayoutPercentageChangeListener(OnLayoutPercentageChangeListener onLayoutPercentageChangeListener) {
        this.onLayoutPercentageChangeListener = onLayoutPercentageChangeListener;
    }

    public void setLayoutShiftListener(LayoutShiftListener layoutShiftListener) {
        this.layoutShiftListener = layoutShiftListener;
    }

    private void triggerSwipeListener() {
        if (this.onSwipedListener != null) {
            this.onSwipedListener.onLayoutSwiped(0);
        }
    }

    private void triggerPositionChangeListener(float f2, float f3, boolean bl) {
        if (this.layoutShiftListener != null && this.lastMotion != 1) {
            this.layoutShiftListener.onLayoutShifted(f2, f3, bl);
        }
    }

    public abstract class OrientationMode {
        public static final int LEFT_RIGHT = 0;
        public static final int UP_BOTTOM = 1;
        public static final int BOTH = 2;
        public static final int NONE = 3;
    }

    public static class Builder {
        private final Context context;
        private float mSwipeSpeed;
        private int mOrientationMode;
        private float startX;
        private float startY;

        public Builder(Context context) {
            this.context = context;
        }

        public void setSwipeSpeed(float f2) {
            this.mSwipeSpeed = f2;
        }

        public void setOrientationMode(int n) {
            this.mOrientationMode = n;
        }

        public void setStartCoordinates(float f2, float f3) {
            this.startX = f2;
            this.startY = f3;
        }

        public void setStartX(int n) {
            this.startX = n;
        }

        public SwipeGestureManager create() {
            return new SwipeGestureManager(this.context, this.startX, this.startY, this.mSwipeSpeed, this.mOrientationMode);
        }
    }

    class FlingGestureDetector
    extends GestureDetector.SimpleOnGestureListener {
        float sensitivity = 500.0f;

        FlingGestureDetector() {
        }

        public boolean onFling(MotionEvent motionEvent, MotionEvent motionEvent2, float f2, float f3) {
            if (Math.abs(f3) > this.sensitivity && !SwipeGestureManager.this.blocks.contains(1)) {
                if (SwipeGestureManager.this.isSwipeable) {
                    SwipeGestureManager.this.triggerSwipeListener();
                }
            } else if (!(Math.abs(f2) > this.sensitivity) || !SwipeGestureManager.this.blocks.contains(0)) {
                // empty if block
            }
            return false;
        }
    }
}

