/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils.showmoretextview;

import android.content.Context;
import android.os.Parcelable;
import android.text.SpannableString;
import android.text.TextPaint;
import android.text.method.LinkMovementMethod;
import android.text.style.ClickableSpan;
import android.text.style.ForegroundColorSpan;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewTreeObserver;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatTextView;
import com.hippo.utils.showmoretextview.SaveState;

public class ShowMoreTextView
extends AppCompatTextView {
    private static final String TAG = ShowMoreTextView.class.getName();
    private int showingLine = 1;
    private int showingChar;
    private boolean isCharEnable;
    private String showMore = "Show more";
    private String showLess = "Show less";
    private String dotdot = "...";
    private int MAGIC_NUMBER = 5;
    private int showMoreTextColor = -65536;
    private int showLessTextColor = -65536;
    private String mainText;
    private boolean isAlreadySet;

    public ShowMoreTextView(Context context) {
        super(context);
    }

    public ShowMoreTextView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.mainText = this.getText().toString();
    }

    public Parcelable onSaveInstanceState() {
        return super.onSaveInstanceState();
    }

    public void onRestoreInstanceState(Parcelable parcelable) {
        super.onRestoreInstanceState(parcelable);
    }

    private void addShowMore() {
        ViewTreeObserver viewTreeObserver = this.getViewTreeObserver();
        viewTreeObserver.addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                String string2 = ShowMoreTextView.this.getText().toString();
                if (!ShowMoreTextView.this.isAlreadySet) {
                    ShowMoreTextView.this.mainText = ShowMoreTextView.this.getText().toString();
                    ShowMoreTextView.this.isAlreadySet = true;
                }
                String string3 = "";
                if (ShowMoreTextView.this.isCharEnable) {
                    if (ShowMoreTextView.this.showingChar >= string2.length()) {
                        try {
                            throw new Exception("Character count cannot be exceed total line count");
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                    String string4 = string2.substring(0, ShowMoreTextView.this.showingChar);
                    string4 = string4 + ShowMoreTextView.this.dotdot + ShowMoreTextView.this.showMore;
                    SaveState.isCollapse = true;
                    ShowMoreTextView.this.setText(string4);
                    Log.d((String)TAG, (String)("Text: " + string4));
                } else {
                    if (ShowMoreTextView.this.showingLine >= ShowMoreTextView.this.getLineCount()) {
                        try {
                            throw new Exception("Line Number cannot be exceed total line count");
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            Log.e((String)TAG, (String)("Error: " + exception.getMessage()));
                            ShowMoreTextView.this.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                            return;
                        }
                    }
                    int n = 0;
                    for (int j = 0; j < ShowMoreTextView.this.showingLine; ++j) {
                        int n2 = ShowMoreTextView.this.getLayout().getLineEnd(j);
                        string3 = string3 + string2.substring(n, n2);
                        n = n2;
                    }
                    String string5 = string3.substring(0, string3.length() - (ShowMoreTextView.this.dotdot.length() + ShowMoreTextView.this.showMore.length() + ShowMoreTextView.this.MAGIC_NUMBER));
                    Log.d((String)TAG, (String)("Text: " + string5));
                    Log.d((String)TAG, (String)("Text: " + string3));
                    string5 = string5 + ShowMoreTextView.this.dotdot + ShowMoreTextView.this.showMore;
                    SaveState.isCollapse = true;
                    ShowMoreTextView.this.setText(string5);
                }
                ShowMoreTextView.this.setShowMoreColoringAndClickable();
                ShowMoreTextView.this.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            }
        });
    }

    private void setShowMoreColoringAndClickable() {
        SpannableString spannableString = new SpannableString(this.getText());
        Log.d((String)TAG, (String)("Text: " + this.getText()));
        spannableString.setSpan((Object)new ClickableSpan(){

            public void updateDrawState(TextPaint textPaint) {
                textPaint.setUnderlineText(false);
            }

            public void onClick(@Nullable View view) {
                ShowMoreTextView.this.setMaxLines(Integer.MAX_VALUE);
                ShowMoreTextView.this.setText(ShowMoreTextView.this.mainText);
                SaveState.isCollapse = false;
                ShowMoreTextView.this.showLessButton();
                Log.d((String)TAG, (String)("Item clicked: " + ShowMoreTextView.this.mainText));
            }
        }, this.getText().length() - (this.dotdot.length() + this.showMore.length()), this.getText().length(), 0);
        spannableString.setSpan((Object)new ForegroundColorSpan(this.showMoreTextColor), this.getText().length() - (this.dotdot.length() + this.showMore.length()), this.getText().length(), 33);
        this.setMovementMethod(LinkMovementMethod.getInstance());
        this.setText((CharSequence)spannableString, TextView.BufferType.SPANNABLE);
    }

    private void showLessButton() {
        String string2 = this.getText() + this.dotdot + this.showLess;
        SpannableString spannableString = new SpannableString((CharSequence)string2);
        spannableString.setSpan((Object)new ClickableSpan(){

            public void updateDrawState(TextPaint textPaint) {
                textPaint.setUnderlineText(false);
            }

            public void onClick(@Nullable View view) {
                ShowMoreTextView.this.setMaxLines(ShowMoreTextView.this.showingLine);
                ShowMoreTextView.this.addShowMore();
                Log.d((String)TAG, (String)"Item clicked: ");
            }
        }, string2.length() - (this.dotdot.length() + this.showLess.length()), string2.length(), 0);
        spannableString.setSpan((Object)new ForegroundColorSpan(this.showLessTextColor), string2.length() - (this.dotdot.length() + this.showLess.length()), string2.length(), 33);
        this.setMovementMethod(LinkMovementMethod.getInstance());
        this.setText((CharSequence)spannableString, TextView.BufferType.SPANNABLE);
    }

    public void setShowingLine(int n) {
        if (n == 0) {
            try {
                throw new Exception("Line Number cannot be 0");
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
        }
        this.isCharEnable = false;
        this.showingLine = n;
        this.setMaxLines(this.showingLine);
        if (SaveState.isCollapse) {
            this.addShowMore();
        } else {
            this.setMaxLines(Integer.MAX_VALUE);
            this.showLessButton();
        }
    }

    public void setShowingChar(int n) {
        if (n == 0) {
            try {
                throw new Exception("Character length cannot be 0");
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
        }
        this.isCharEnable = true;
        this.showingChar = n;
        if (SaveState.isCollapse) {
            this.addShowMore();
        } else {
            this.setMaxLines(Integer.MAX_VALUE);
            this.showLessButton();
        }
    }

    public void addShowMoreText(String string2) {
        this.showMore = string2;
    }

    public void addShowLessText(String string2) {
        this.showLess = string2;
    }

    public void setShowMoreColor(int n) {
        this.showMoreTextColor = n;
    }

    public void setShowLessTextColor(int n) {
        this.showLessTextColor = n;
    }
}

