/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils.showmoretextview;

import android.animation.LayoutTransition;
import android.content.Context;
import android.graphics.Color;
import android.os.Build;
import android.os.Handler;
import android.text.SpannableString;
import android.text.SpannableStringBuilder;
import android.text.TextPaint;
import android.text.method.LinkMovementMethod;
import android.text.style.ClickableSpan;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

public class ReadMoreOption {
    public static final int TYPE_LINE = 1;
    public static final int TYPE_CHARACTER = 2;
    private static final String TAG = ReadMoreOption.class.getSimpleName();
    private Context context;
    private int textLength;
    private int textLengthType;
    private String moreLabel;
    private String lessLabel;
    private int moreLabelColor;
    private int lessLabelColor;
    private boolean labelUnderLine;
    private boolean expandAnimation;
    private OptionClick optionClick;
    private int position;
    private int status;

    private ReadMoreOption(Builder builder) {
        this.context = builder.context;
        this.textLength = builder.textLength;
        this.textLengthType = builder.textLengthType;
        this.moreLabel = builder.moreLabel;
        this.lessLabel = builder.lessLabel;
        this.moreLabelColor = builder.moreLabelColor;
        this.lessLabelColor = builder.lessLabelColor;
        this.labelUnderLine = builder.labelUnderLine;
        this.expandAnimation = builder.expandAnimation;
        this.optionClick = builder.optionClick;
        this.position = builder.position;
        this.status = builder.status;
    }

    public void addReadLessTo(final TextView textView, final CharSequence charSequence) {
        textView.post(new Runnable(){

            @Override
            public void run() {
                textView.setMaxLines(Integer.MAX_VALUE);
                SpannableStringBuilder spannableStringBuilder = new SpannableStringBuilder(charSequence).append((CharSequence)"...").append((CharSequence)ReadMoreOption.this.lessLabel);
                SpannableString spannableString = SpannableString.valueOf((CharSequence)spannableStringBuilder);
                ClickableSpan clickableSpan = new ClickableSpan(){

                    public void onClick(View view) {
                        new Handler().post(new Runnable(){

                            @Override
                            public void run() {
                                ReadMoreOption.this.addReadMoreTo(textView, charSequence);
                                if (ReadMoreOption.this.optionClick != null) {
                                    ReadMoreOption.this.optionClick.onReadLessClickListener(ReadMoreOption.this.position);
                                }
                            }
                        });
                    }

                    public void updateDrawState(TextPaint textPaint) {
                        super.updateDrawState(textPaint);
                        textPaint.setUnderlineText(ReadMoreOption.this.labelUnderLine);
                        textPaint.setColor(ReadMoreOption.this.lessLabelColor);
                    }
                };
                spannableString.setSpan((Object)clickableSpan, spannableString.length() - ReadMoreOption.this.lessLabel.length(), spannableString.length(), 33);
                textView.setText((CharSequence)spannableString);
                textView.setMovementMethod(LinkMovementMethod.getInstance());
            }
        });
    }

    public void addReadMoreTo(final TextView textView, final CharSequence charSequence) {
        if (this.textLengthType == 2) {
            if (charSequence.length() <= this.textLength) {
                textView.setText(charSequence);
                return;
            }
        } else {
            textView.setLines(this.textLength);
            textView.setText(charSequence);
        }
        textView.post(new Runnable(){

            @Override
            public void run() {
                ViewGroup.MarginLayoutParams marginLayoutParams;
                int n = ReadMoreOption.this.textLength;
                if (ReadMoreOption.this.textLengthType == 1) {
                    int n2;
                    if (textView.getLayout().getLineCount() <= ReadMoreOption.this.textLength) {
                        textView.setText(charSequence);
                        return;
                    }
                    marginLayoutParams = (ViewGroup.MarginLayoutParams)textView.getLayoutParams();
                    int n3 = textView.getLayout().getLineStart(ReadMoreOption.this.textLength - 1);
                    int n4 = textView.getLayout().getLineEnd(ReadMoreOption.this.textLength - 1);
                    int n5 = n4 - n3;
                    if (n5 >= (n2 = ReadMoreOption.this.moreLabel.length() + 4 + marginLayoutParams.rightMargin / 6)) {
                        CharSequence charSequence2 = charSequence.subSequence(textView.getLayout().getLineStart(0), textView.getLayout().getLineEnd(ReadMoreOption.this.textLength - 1));
                        n = charSequence2.length() - (ReadMoreOption.this.moreLabel.length() + 4 + marginLayoutParams.rightMargin / 6);
                    } else {
                        CharSequence charSequence3 = charSequence.subSequence(textView.getLayout().getLineStart(0), textView.getLayout().getLineStart(ReadMoreOption.this.textLength - 1));
                        n = charSequence3.length();
                    }
                }
                SpannableStringBuilder spannableStringBuilder = new SpannableStringBuilder(charSequence.subSequence(0, n)).append((CharSequence)"...").append((CharSequence)ReadMoreOption.this.moreLabel);
                marginLayoutParams = SpannableString.valueOf((CharSequence)spannableStringBuilder);
                ClickableSpan clickableSpan = new ClickableSpan(){

                    public void onClick(View view) {
                        ReadMoreOption.this.addReadLess(textView, charSequence);
                        if (ReadMoreOption.this.optionClick != null) {
                            ReadMoreOption.this.optionClick.onReadMoreClickListener(ReadMoreOption.this.position);
                        }
                    }

                    public void updateDrawState(TextPaint textPaint) {
                        super.updateDrawState(textPaint);
                        textPaint.setUnderlineText(ReadMoreOption.this.labelUnderLine);
                        textPaint.setColor(ReadMoreOption.this.moreLabelColor);
                    }
                };
                marginLayoutParams.setSpan((Object)clickableSpan, marginLayoutParams.length() - ReadMoreOption.this.moreLabel.length(), marginLayoutParams.length(), 33);
                if (Build.VERSION.SDK_INT >= 16 && ReadMoreOption.this.expandAnimation) {
                    LayoutTransition layoutTransition = new LayoutTransition();
                    layoutTransition.enableTransitionType(4);
                    ((ViewGroup)textView.getParent()).setLayoutTransition(layoutTransition);
                }
                textView.setText((CharSequence)marginLayoutParams);
                textView.setMovementMethod(LinkMovementMethod.getInstance());
            }
        });
    }

    private void addReadLess(final TextView textView, final CharSequence charSequence) {
        textView.setMaxLines(Integer.MAX_VALUE);
        SpannableStringBuilder spannableStringBuilder = new SpannableStringBuilder(charSequence).append((CharSequence)"...").append((CharSequence)this.lessLabel);
        SpannableString spannableString = SpannableString.valueOf((CharSequence)spannableStringBuilder);
        ClickableSpan clickableSpan = new ClickableSpan(){

            public void onClick(View view) {
                new Handler().post(new Runnable(){

                    @Override
                    public void run() {
                        ReadMoreOption.this.addReadMoreTo(textView, charSequence);
                        if (ReadMoreOption.this.optionClick != null) {
                            ReadMoreOption.this.optionClick.onReadLessClickListener(ReadMoreOption.this.position);
                        }
                    }
                });
            }

            public void updateDrawState(TextPaint textPaint) {
                super.updateDrawState(textPaint);
                textPaint.setUnderlineText(ReadMoreOption.this.labelUnderLine);
                textPaint.setColor(ReadMoreOption.this.lessLabelColor);
            }
        };
        spannableString.setSpan((Object)clickableSpan, spannableString.length() - this.lessLabel.length(), spannableString.length(), 33);
        textView.setText((CharSequence)spannableString);
        textView.setMovementMethod(LinkMovementMethod.getInstance());
    }

    public static interface OptionClick {
        public void onReadMoreClickListener(int var1);

        public void onReadLessClickListener(int var1);
    }

    public static class Builder {
        private Context context;
        private int textLength = 100;
        private int textLengthType = 2;
        private String moreLabel = "read more";
        private String lessLabel = "read less";
        private int moreLabelColor = Color.parseColor((String)"#ff00ff");
        private int lessLabelColor = Color.parseColor((String)"#ff00ff");
        private boolean labelUnderLine = false;
        private boolean expandAnimation = false;
        private int status;
        private OptionClick optionClick;
        private int position;

        public Builder(Context context) {
            this.context = context;
        }

        public Builder textLength(int n, int n2) {
            this.textLength = n;
            this.textLengthType = n2;
            return this;
        }

        public Builder moreLabel(String string2) {
            this.moreLabel = string2;
            return this;
        }

        public Builder lessLabel(String string2) {
            this.lessLabel = string2;
            return this;
        }

        public Builder moreLabelColor(int n) {
            this.moreLabelColor = n;
            return this;
        }

        public Builder lessLabelColor(int n) {
            this.lessLabelColor = n;
            return this;
        }

        public Builder labelUnderLine(boolean bl) {
            this.labelUnderLine = bl;
            return this;
        }

        public Builder expandAnimation(boolean bl) {
            this.expandAnimation = bl;
            return this;
        }

        public Builder optionClick(OptionClick optionClick) {
            this.optionClick = optionClick;
            return this;
        }

        public Builder position(int n) {
            this.position = n;
            return this;
        }

        public Builder status(int n) {
            this.status = n;
            return this;
        }

        public ReadMoreOption build() {
            return new ReadMoreOption(this);
        }
    }
}

