/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils.photoview;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Matrix;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.View;
import android.widget.ImageView;
import com.hippo.utils.photoview.OnDoubleTap;
import com.hippo.utils.photoview.OnMatrixChangedListener;
import com.hippo.utils.photoview.OnOutsidePhotoTapListener;
import com.hippo.utils.photoview.OnPhotoTapListener;
import com.hippo.utils.photoview.OnScaleChangedListener;
import com.hippo.utils.photoview.OnSingleFlingListener;
import com.hippo.utils.photoview.OnViewDragListener;
import com.hippo.utils.photoview.OnViewTapListener;
import com.hippo.utils.photoview.PhotoViewAttacher;

@SuppressLint(value={"AppCompatCustomView"})
public class PhotoView
extends ImageView {
    private PhotoViewAttacher attacher;
    private ImageView.ScaleType pendingScaleType;

    public PhotoView(Context context) {
        this(context, null);
    }

    public PhotoView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public PhotoView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.init();
    }

    @TargetApi(value=21)
    public PhotoView(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.init();
    }

    private void init() {
        this.attacher = new PhotoViewAttacher(this);
        super.setScaleType(ImageView.ScaleType.MATRIX);
        if (this.pendingScaleType != null) {
            this.setScaleType(this.pendingScaleType);
            this.pendingScaleType = null;
        }
    }

    public PhotoViewAttacher getAttacher() {
        return this.attacher;
    }

    public ImageView.ScaleType getScaleType() {
        return this.attacher.getScaleType();
    }

    public Matrix getImageMatrix() {
        return this.attacher.getImageMatrix();
    }

    public void setOnLongClickListener(View.OnLongClickListener onLongClickListener) {
        this.attacher.setOnLongClickListener(onLongClickListener);
    }

    public void setOnClickListener(View.OnClickListener onClickListener) {
        this.attacher.setOnClickListener(onClickListener);
    }

    public void setScaleType(ImageView.ScaleType scaleType) {
        if (this.attacher == null) {
            this.pendingScaleType = scaleType;
        } else {
            this.attacher.setScaleType(scaleType);
        }
    }

    public void setImageDrawable(Drawable drawable2) {
        super.setImageDrawable(drawable2);
        if (this.attacher != null) {
            this.attacher.update();
        }
    }

    public void setImageResource(int n) {
        super.setImageResource(n);
        if (this.attacher != null) {
            this.attacher.update();
        }
    }

    public void setImageURI(Uri uri) {
        super.setImageURI(uri);
        if (this.attacher != null) {
            this.attacher.update();
        }
    }

    protected boolean setFrame(int n, int n2, int n3, int n4) {
        boolean bl = super.setFrame(n, n2, n3, n4);
        if (bl) {
            this.attacher.update();
        }
        return bl;
    }

    public void setRotationTo(float f2) {
        this.attacher.setRotationTo(f2);
    }

    public void setRotationBy(float f2) {
        this.attacher.setRotationBy(f2);
    }

    @Deprecated
    public boolean isZoomEnabled() {
        return this.attacher.isZoomEnabled();
    }

    public boolean isZoomable() {
        return this.attacher.isZoomable();
    }

    public void setZoomable(boolean bl) {
        this.attacher.setZoomable(bl);
    }

    public RectF getDisplayRect() {
        return this.attacher.getDisplayRect();
    }

    public void getDisplayMatrix(Matrix matrix) {
        this.attacher.getDisplayMatrix(matrix);
    }

    public boolean setDisplayMatrix(Matrix matrix) {
        return this.attacher.setDisplayMatrix(matrix);
    }

    public void getSuppMatrix(Matrix matrix) {
        this.attacher.getSuppMatrix(matrix);
    }

    public boolean setSuppMatrix(Matrix matrix) {
        return this.attacher.setDisplayMatrix(matrix);
    }

    public float getMinimumScale() {
        return this.attacher.getMinimumScale();
    }

    public float getMediumScale() {
        return this.attacher.getMediumScale();
    }

    public float getMaximumScale() {
        return this.attacher.getMaximumScale();
    }

    public float getScale() {
        return this.attacher.getScale();
    }

    public void setAllowParentInterceptOnEdge(boolean bl) {
        this.attacher.setAllowParentInterceptOnEdge(bl);
    }

    public void setMinimumScale(float f2) {
        this.attacher.setMinimumScale(f2);
    }

    public void setMediumScale(float f2) {
        this.attacher.setMediumScale(f2);
    }

    public void setMaximumScale(float f2) {
        this.attacher.setMaximumScale(f2);
    }

    public void setScaleLevels(float f2, float f3, float f4) {
        this.attacher.setScaleLevels(f2, f3, f4);
    }

    public void setOnMatrixChangeListener(OnMatrixChangedListener onMatrixChangedListener) {
        this.attacher.setOnMatrixChangeListener(onMatrixChangedListener);
    }

    public void setOnPhotoTapListener(OnPhotoTapListener onPhotoTapListener) {
        this.attacher.setOnPhotoTapListener(onPhotoTapListener);
    }

    public void setOnOutsidePhotoTapListener(OnOutsidePhotoTapListener onOutsidePhotoTapListener) {
        this.attacher.setOnOutsidePhotoTapListener(onOutsidePhotoTapListener);
    }

    public void setOnViewTapListener(OnViewTapListener onViewTapListener) {
        this.attacher.setOnViewTapListener(onViewTapListener);
    }

    public void setOnViewDragListener(OnViewDragListener onViewDragListener) {
        this.attacher.setOnViewDragListener(onViewDragListener);
    }

    public void setScale(float f2) {
        this.attacher.setScale(f2);
    }

    public void setScale(float f2, boolean bl) {
        this.attacher.setScale(f2, bl);
    }

    public void setScale(float f2, float f3, float f4, boolean bl) {
        this.attacher.setScale(f2, f3, f4, bl);
    }

    public void setZoomTransitionDuration(int n) {
        this.attacher.setZoomTransitionDuration(n);
    }

    public void setOnDoubleTapListener(GestureDetector.OnDoubleTapListener onDoubleTapListener) {
        this.attacher.setOnDoubleTapListener(onDoubleTapListener);
    }

    public void setOnScaleChangeListener(OnScaleChangedListener onScaleChangedListener) {
        this.attacher.setOnScaleChangeListener(onScaleChangedListener);
    }

    public void setOnSingleFlingListener(OnSingleFlingListener onSingleFlingListener) {
        this.attacher.setOnSingleFlingListener(onSingleFlingListener);
    }

    public void setOnDoubleTap(OnDoubleTap onDoubleTap) {
        this.attacher.setOnDoubleTap(onDoubleTap);
    }
}

