/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils.loadingBox;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import com.hippo.R;

public class ProgressWheel
extends View {
    private static final String TAG = ProgressWheel.class.getSimpleName();
    private final int barLength = 16;
    private final int barMaxLength = 270;
    private final long pauseGrowingTime = 200L;
    private int circleRadius = 28;
    private int barWidth = 4;
    private int rimWidth = 4;
    private boolean fillRadius = false;
    private double timeStartGrowing = 0.0;
    private double barSpinCycleTime = 460.0;
    private float barExtraLength = 0.0f;
    private boolean barGrowingFromFront = true;
    private long pausedTimeWithoutGrowing = 0L;
    private int barColor = -1442840576;
    private int rimColor = 0xFFFFFF;
    private Paint barPaint = new Paint();
    private Paint rimPaint = new Paint();
    private RectF circleBounds = new RectF();
    private float spinSpeed = 230.0f;
    private long lastTimeAnimated = 0L;
    private boolean linearProgress;
    private float mProgress = 0.0f;
    private float mTargetProgress = 0.0f;
    private boolean isSpinning = false;
    private ProgressCallback callback;

    public ProgressWheel(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.parseAttributes(context.obtainStyledAttributes(attributeSet, R.styleable.ProgressWheel));
    }

    public ProgressWheel(Context context) {
        super(context);
    }

    protected void onMeasure(int n, int n2) {
        super.onMeasure(n, n2);
        int n3 = this.circleRadius + this.getPaddingLeft() + this.getPaddingRight();
        int n4 = this.circleRadius + this.getPaddingTop() + this.getPaddingBottom();
        int n5 = View.MeasureSpec.getMode((int)n);
        int n6 = View.MeasureSpec.getSize((int)n);
        int n7 = View.MeasureSpec.getMode((int)n2);
        int n8 = View.MeasureSpec.getSize((int)n2);
        int n9 = n5 == 0x40000000 ? n6 : (n5 == Integer.MIN_VALUE ? Math.min(n3, n6) : n3);
        int n10 = n7 == 0x40000000 || n5 == 0x40000000 ? n8 : (n7 == Integer.MIN_VALUE ? Math.min(n4, n8) : n4);
        this.setMeasuredDimension(n9, n10);
    }

    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        super.onSizeChanged(n, n2, n3, n4);
        this.setupBounds(n, n2);
        this.setupPaints();
        this.invalidate();
    }

    private void setupPaints() {
        this.barPaint.setColor(this.barColor);
        this.barPaint.setAntiAlias(true);
        this.barPaint.setStyle(Paint.Style.STROKE);
        this.barPaint.setStrokeWidth((float)this.barWidth);
        this.rimPaint.setColor(this.rimColor);
        this.rimPaint.setAntiAlias(true);
        this.rimPaint.setStyle(Paint.Style.STROKE);
        this.rimPaint.setStrokeWidth((float)this.rimWidth);
    }

    private void setupBounds(int n, int n2) {
        int n3 = this.getPaddingTop();
        int n4 = this.getPaddingBottom();
        int n5 = this.getPaddingLeft();
        int n6 = this.getPaddingRight();
        if (!this.fillRadius) {
            int n7 = Math.min(n - n5 - n6, n2 - n4 - n3);
            int n8 = Math.min(n7, this.circleRadius * 2 - this.barWidth * 2);
            int n9 = (n - n5 - n6 - n8) / 2 + n5;
            int n10 = (n2 - n3 - n4 - n8) / 2 + n3;
            this.circleBounds = new RectF((float)(n9 + this.barWidth), (float)(n10 + this.barWidth), (float)(n9 + n8 - this.barWidth), (float)(n10 + n8 - this.barWidth));
        } else {
            this.circleBounds = new RectF((float)(n5 + this.barWidth), (float)(n3 + this.barWidth), (float)(n - n6 - this.barWidth), (float)(n2 - n4 - this.barWidth));
        }
    }

    private void parseAttributes(TypedArray typedArray) {
        DisplayMetrics displayMetrics = this.getContext().getResources().getDisplayMetrics();
        this.barWidth = (int)TypedValue.applyDimension((int)1, (float)this.barWidth, (DisplayMetrics)displayMetrics);
        this.rimWidth = (int)TypedValue.applyDimension((int)1, (float)this.rimWidth, (DisplayMetrics)displayMetrics);
        this.circleRadius = (int)TypedValue.applyDimension((int)1, (float)this.circleRadius, (DisplayMetrics)displayMetrics);
        this.circleRadius = (int)typedArray.getDimension(R.styleable.ProgressWheel_matProg_circleRadius, (float)this.circleRadius);
        this.fillRadius = typedArray.getBoolean(R.styleable.ProgressWheel_matProg_fillRadius, false);
        this.barWidth = (int)typedArray.getDimension(R.styleable.ProgressWheel_matProg_barWidth, (float)this.barWidth);
        this.rimWidth = (int)typedArray.getDimension(R.styleable.ProgressWheel_matProg_rimWidth, (float)this.rimWidth);
        float f2 = typedArray.getFloat(R.styleable.ProgressWheel_matProg_spinSpeed, this.spinSpeed / 360.0f);
        this.spinSpeed = f2 * 360.0f;
        this.barSpinCycleTime = typedArray.getInt(R.styleable.ProgressWheel_matProg_barSpinCycleTime, (int)this.barSpinCycleTime);
        this.barColor = typedArray.getColor(R.styleable.ProgressWheel_matProg_barColor, this.barColor);
        this.rimColor = typedArray.getColor(R.styleable.ProgressWheel_matProg_rimColor, this.rimColor);
        this.linearProgress = typedArray.getBoolean(R.styleable.ProgressWheel_matProg_linearProgress, false);
        if (typedArray.getBoolean(R.styleable.ProgressWheel_matProg_progressIndeterminate, false)) {
            this.spin();
        }
        typedArray.recycle();
    }

    public void setCallback(ProgressCallback progressCallback) {
        this.callback = progressCallback;
        if (!this.isSpinning) {
            this.runCallback();
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        canvas.drawArc(this.circleBounds, 360.0f, 360.0f, false, this.rimPaint);
        boolean bl = false;
        if (this.isSpinning) {
            bl = true;
            long l = SystemClock.uptimeMillis() - this.lastTimeAnimated;
            float f2 = (float)l * this.spinSpeed / 1000.0f;
            this.updateBarLength(l);
            this.mProgress += f2;
            if (this.mProgress > 360.0f) {
                this.mProgress -= 360.0f;
            }
            this.lastTimeAnimated = SystemClock.uptimeMillis();
            float f3 = this.mProgress - 90.0f;
            float f4 = 16.0f + this.barExtraLength;
            if (this.isInEditMode()) {
                f3 = 0.0f;
                f4 = 135.0f;
            }
            canvas.drawArc(this.circleBounds, f3, f4, false, this.barPaint);
        } else {
            float f5;
            float f6;
            float f7 = this.mProgress;
            if (this.mProgress != this.mTargetProgress) {
                bl = true;
                f6 = (float)(SystemClock.uptimeMillis() - this.lastTimeAnimated) / 1000.0f;
                f5 = f6 * this.spinSpeed;
                this.mProgress = Math.min(this.mProgress + f5, this.mTargetProgress);
                this.lastTimeAnimated = SystemClock.uptimeMillis();
            }
            if (f7 != this.mProgress) {
                this.runCallback();
            }
            f6 = 0.0f;
            f5 = this.mProgress;
            if (!this.linearProgress) {
                float f8 = 2.0f;
                f6 = (float)(1.0 - Math.pow(1.0f - this.mProgress / 360.0f, 2.0f * f8)) * 360.0f;
                f5 = (float)(1.0 - Math.pow(1.0f - this.mProgress / 360.0f, f8)) * 360.0f;
            }
            if (this.isInEditMode()) {
                f5 = 360.0f;
            }
            canvas.drawArc(this.circleBounds, f6 - 90.0f, f5, false, this.barPaint);
        }
        if (bl) {
            this.invalidate();
        }
    }

    protected void onVisibilityChanged(View view, int n) {
        super.onVisibilityChanged(view, n);
        if (n == 0) {
            this.lastTimeAnimated = SystemClock.uptimeMillis();
        }
    }

    private void updateBarLength(long l) {
        if (this.pausedTimeWithoutGrowing >= 200L) {
            this.timeStartGrowing += (double)l;
            if (this.timeStartGrowing > this.barSpinCycleTime) {
                this.timeStartGrowing -= this.barSpinCycleTime;
                this.pausedTimeWithoutGrowing = 0L;
                this.barGrowingFromFront = !this.barGrowingFromFront;
            }
            float f2 = (float)Math.cos((this.timeStartGrowing / this.barSpinCycleTime + 1.0) * Math.PI) / 2.0f + 0.5f;
            float f3 = 254.0f;
            if (this.barGrowingFromFront) {
                this.barExtraLength = f2 * f3;
            } else {
                float f4 = f3 * (1.0f - f2);
                this.mProgress += this.barExtraLength - f4;
                this.barExtraLength = f4;
            }
        } else {
            this.pausedTimeWithoutGrowing += l;
        }
    }

    public boolean isSpinning() {
        return this.isSpinning;
    }

    public void resetCount() {
        this.mProgress = 0.0f;
        this.mTargetProgress = 0.0f;
        this.invalidate();
    }

    public void stopSpinning() {
        this.isSpinning = false;
        this.mProgress = 0.0f;
        this.mTargetProgress = 0.0f;
        this.invalidate();
    }

    public void spin() {
        this.lastTimeAnimated = SystemClock.uptimeMillis();
        this.isSpinning = true;
        this.invalidate();
    }

    private void runCallback() {
        if (this.callback != null) {
            float f2 = (float)Math.round(this.mProgress * 100.0f / 360.0f) / 100.0f;
            this.callback.onProgressUpdate(f2);
        }
    }

    public void setInstantProgress(float f2) {
        if (this.isSpinning) {
            this.mProgress = 0.0f;
            this.isSpinning = false;
        }
        if (f2 > 1.0f) {
            f2 -= 1.0f;
        } else if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        if (f2 == this.mTargetProgress) {
            return;
        }
        this.mProgress = this.mTargetProgress = Math.min(f2 * 360.0f, 360.0f);
        this.lastTimeAnimated = SystemClock.uptimeMillis();
        this.invalidate();
    }

    public Parcelable onSaveInstanceState() {
        Parcelable parcelable = super.onSaveInstanceState();
        WheelSavedState wheelSavedState = new WheelSavedState(parcelable);
        wheelSavedState.mProgress = this.mProgress;
        wheelSavedState.mTargetProgress = this.mTargetProgress;
        wheelSavedState.isSpinning = this.isSpinning;
        wheelSavedState.spinSpeed = this.spinSpeed;
        wheelSavedState.barWidth = this.barWidth;
        wheelSavedState.barColor = this.barColor;
        wheelSavedState.rimWidth = this.rimWidth;
        wheelSavedState.rimColor = this.rimColor;
        wheelSavedState.circleRadius = this.circleRadius;
        wheelSavedState.linearProgress = this.linearProgress;
        wheelSavedState.fillRadius = this.fillRadius;
        return wheelSavedState;
    }

    public void onRestoreInstanceState(Parcelable parcelable) {
        if (!(parcelable instanceof WheelSavedState)) {
            super.onRestoreInstanceState(parcelable);
            return;
        }
        WheelSavedState wheelSavedState = (WheelSavedState)parcelable;
        super.onRestoreInstanceState(wheelSavedState.getSuperState());
        this.mProgress = wheelSavedState.mProgress;
        this.mTargetProgress = wheelSavedState.mTargetProgress;
        this.isSpinning = wheelSavedState.isSpinning;
        this.spinSpeed = wheelSavedState.spinSpeed;
        this.barWidth = wheelSavedState.barWidth;
        this.barColor = wheelSavedState.barColor;
        this.rimWidth = wheelSavedState.rimWidth;
        this.rimColor = wheelSavedState.rimColor;
        this.circleRadius = wheelSavedState.circleRadius;
        this.linearProgress = wheelSavedState.linearProgress;
        this.fillRadius = wheelSavedState.fillRadius;
    }

    public float getProgress() {
        return this.isSpinning ? -1.0f : this.mProgress / 360.0f;
    }

    public void setProgress(float f2) {
        if (this.isSpinning) {
            this.mProgress = 0.0f;
            this.isSpinning = false;
            this.runCallback();
        }
        if (f2 > 1.0f) {
            f2 -= 1.0f;
        } else if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        if (f2 == this.mTargetProgress) {
            return;
        }
        if (this.mProgress == this.mTargetProgress) {
            this.lastTimeAnimated = SystemClock.uptimeMillis();
        }
        this.mTargetProgress = Math.min(f2 * 360.0f, 360.0f);
        this.invalidate();
    }

    public void setLinearProgress(boolean bl) {
        this.linearProgress = bl;
        if (!this.isSpinning) {
            this.invalidate();
        }
    }

    public int getCircleRadius() {
        return this.circleRadius;
    }

    public void setCircleRadius(int n) {
        this.circleRadius = n;
        if (!this.isSpinning) {
            this.invalidate();
        }
    }

    public int getBarWidth() {
        return this.barWidth;
    }

    public void setBarWidth(int n) {
        this.barWidth = n;
        if (!this.isSpinning) {
            this.invalidate();
        }
    }

    public int getBarColor() {
        return this.barColor;
    }

    public void setBarColor(int n) {
        this.barColor = n;
        this.setupPaints();
        if (!this.isSpinning) {
            this.invalidate();
        }
    }

    public int getRimColor() {
        return this.rimColor;
    }

    public void setRimColor(int n) {
        this.rimColor = n;
        this.setupPaints();
        if (!this.isSpinning) {
            this.invalidate();
        }
    }

    public float getSpinSpeed() {
        return this.spinSpeed / 360.0f;
    }

    public void setSpinSpeed(float f2) {
        this.spinSpeed = f2 * 360.0f;
    }

    public int getRimWidth() {
        return this.rimWidth;
    }

    public void setRimWidth(int n) {
        this.rimWidth = n;
        if (!this.isSpinning) {
            this.invalidate();
        }
    }

    static class WheelSavedState
    extends View.BaseSavedState {
        public static final Parcelable.Creator<WheelSavedState> CREATOR = new Parcelable.Creator<WheelSavedState>(){

            public WheelSavedState createFromParcel(Parcel parcel) {
                return new WheelSavedState(parcel);
            }

            public WheelSavedState[] newArray(int n) {
                return new WheelSavedState[n];
            }
        };
        float mProgress;
        float mTargetProgress;
        boolean isSpinning;
        float spinSpeed;
        int barWidth;
        int barColor;
        int rimWidth;
        int rimColor;
        int circleRadius;
        boolean linearProgress;
        boolean fillRadius;

        WheelSavedState(Parcelable parcelable) {
            super(parcelable);
        }

        private WheelSavedState(Parcel parcel) {
            super(parcel);
            this.mProgress = parcel.readFloat();
            this.mTargetProgress = parcel.readFloat();
            this.isSpinning = parcel.readByte() != 0;
            this.spinSpeed = parcel.readFloat();
            this.barWidth = parcel.readInt();
            this.barColor = parcel.readInt();
            this.rimWidth = parcel.readInt();
            this.rimColor = parcel.readInt();
            this.circleRadius = parcel.readInt();
            this.linearProgress = parcel.readByte() != 0;
            this.fillRadius = parcel.readByte() != 0;
        }

        public void writeToParcel(Parcel parcel, int n) {
            super.writeToParcel(parcel, n);
            parcel.writeFloat(this.mProgress);
            parcel.writeFloat(this.mTargetProgress);
            parcel.writeByte((byte)(this.isSpinning ? 1 : 0));
            parcel.writeFloat(this.spinSpeed);
            parcel.writeInt(this.barWidth);
            parcel.writeInt(this.barColor);
            parcel.writeInt(this.rimWidth);
            parcel.writeInt(this.rimColor);
            parcel.writeInt(this.circleRadius);
            parcel.writeByte((byte)(this.linearProgress ? 1 : 0));
            parcel.writeByte((byte)(this.fillRadius ? 1 : 0));
        }
    }

    public static interface ProgressCallback {
        public void onProgressUpdate(float var1);
    }
}

