/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils.filepicker.filter.callback;

import android.content.Context;
import android.database.Cursor;
import android.os.Bundle;
import androidx.loader.app.LoaderManager;
import androidx.loader.content.CursorLoader;
import androidx.loader.content.Loader;
import com.hippo.utils.filepicker.Util;
import com.hippo.utils.filepicker.filter.callback.FilterResultCallback;
import com.hippo.utils.filepicker.filter.entity.AudioFile;
import com.hippo.utils.filepicker.filter.entity.Directory;
import com.hippo.utils.filepicker.filter.entity.ImageFile;
import com.hippo.utils.filepicker.filter.entity.NormalFile;
import com.hippo.utils.filepicker.filter.entity.VideoFile;
import com.hippo.utils.filepicker.filter.loader.AudioLoader;
import com.hippo.utils.filepicker.filter.loader.FileLoader;
import com.hippo.utils.filepicker.filter.loader.ImageLoader;
import com.hippo.utils.filepicker.filter.loader.VideoLoader;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FileLoaderCallbacks
implements LoaderManager.LoaderCallbacks<Cursor> {
    public static final int TYPE_IMAGE = 0;
    public static final int TYPE_VIDEO = 1;
    public static final int TYPE_AUDIO = 2;
    public static final int TYPE_FILE = 3;
    private WeakReference<Context> context;
    private FilterResultCallback resultCallback;
    private int mType = 0;
    private String[] mSuffixArgs;
    private CursorLoader mLoader;
    private String mSuffixRegex;

    public FileLoaderCallbacks(Context context, FilterResultCallback filterResultCallback, int n) {
        this(context, filterResultCallback, n, null);
    }

    public FileLoaderCallbacks(Context context, FilterResultCallback filterResultCallback, int n, String[] stringArray) {
        this.context = new WeakReference<Context>(context);
        this.resultCallback = filterResultCallback;
        this.mType = n;
        this.mSuffixArgs = stringArray;
        if (stringArray != null && stringArray.length > 0) {
            this.mSuffixRegex = this.obtainSuffixRegex(stringArray);
        }
    }

    public Loader<Cursor> onCreateLoader(int n, Bundle bundle) {
        switch (this.mType) {
            case 0: {
                this.mLoader = new ImageLoader((Context)this.context.get());
                break;
            }
            case 1: {
                this.mLoader = new VideoLoader((Context)this.context.get());
                break;
            }
            case 2: {
                this.mLoader = new AudioLoader((Context)this.context.get());
                break;
            }
            case 3: {
                this.mLoader = new FileLoader((Context)this.context.get());
            }
        }
        return this.mLoader;
    }

    public void onLoadFinished(Loader<Cursor> loader, Cursor cursor) {
        if (cursor == null) {
            return;
        }
        switch (this.mType) {
            case 0: {
                this.onImageResult(cursor);
                break;
            }
            case 1: {
                this.onVideoResult(cursor);
                break;
            }
            case 2: {
                this.onAudioResult(cursor);
                break;
            }
            case 3: {
                this.onFileResult(cursor);
            }
        }
    }

    public void onLoaderReset(Loader<Cursor> loader) {
    }

    private void onImageResult(Cursor cursor) {
        ArrayList arrayList = new ArrayList();
        if (cursor.getPosition() != -1) {
            cursor.moveToPosition(-1);
        }
        while (cursor.moveToNext()) {
            ImageFile imageFile = new ImageFile();
            imageFile.setId(cursor.getLong(cursor.getColumnIndexOrThrow("_id")));
            imageFile.setName(cursor.getString(cursor.getColumnIndexOrThrow("title")));
            imageFile.setPath(cursor.getString(cursor.getColumnIndexOrThrow("_data")));
            imageFile.setSize(cursor.getLong(cursor.getColumnIndexOrThrow("_size")));
            imageFile.setBucketId(cursor.getString(cursor.getColumnIndexOrThrow("bucket_id")));
            imageFile.setBucketName(cursor.getString(cursor.getColumnIndexOrThrow("bucket_display_name")));
            imageFile.setDate(cursor.getLong(cursor.getColumnIndexOrThrow("date_added")));
            imageFile.setOrientation(cursor.getInt(cursor.getColumnIndexOrThrow("orientation")));
            Directory<ImageFile> directory = new Directory<ImageFile>();
            directory.setId(imageFile.getBucketId());
            directory.setName(imageFile.getBucketName());
            directory.setPath(Util.extractPathWithoutSeparator(imageFile.getPath()));
            if (!arrayList.contains(directory)) {
                directory.addFile(imageFile);
                arrayList.add(directory);
                continue;
            }
            ((Directory)arrayList.get(arrayList.indexOf(directory))).addFile(imageFile);
        }
        if (this.resultCallback != null) {
            this.resultCallback.onResult(arrayList);
        }
    }

    private void onVideoResult(Cursor cursor) {
        ArrayList arrayList = new ArrayList();
        if (cursor.getPosition() != -1) {
            cursor.moveToPosition(-1);
        }
        while (cursor.moveToNext()) {
            VideoFile videoFile = new VideoFile();
            videoFile.setId(cursor.getLong(cursor.getColumnIndexOrThrow("_id")));
            videoFile.setName(cursor.getString(cursor.getColumnIndexOrThrow("title")));
            videoFile.setPath(cursor.getString(cursor.getColumnIndexOrThrow("_data")));
            videoFile.setSize(cursor.getLong(cursor.getColumnIndexOrThrow("_size")));
            videoFile.setBucketId(cursor.getString(cursor.getColumnIndexOrThrow("bucket_id")));
            videoFile.setBucketName(cursor.getString(cursor.getColumnIndexOrThrow("bucket_display_name")));
            videoFile.setDate(cursor.getLong(cursor.getColumnIndexOrThrow("date_added")));
            videoFile.setDuration(cursor.getLong(cursor.getColumnIndexOrThrow("duration")));
            Directory<VideoFile> directory = new Directory<VideoFile>();
            directory.setId(videoFile.getBucketId());
            directory.setName(videoFile.getBucketName());
            directory.setPath(Util.extractPathWithoutSeparator(videoFile.getPath()));
            if (!arrayList.contains(directory)) {
                directory.addFile(videoFile);
                arrayList.add(directory);
                continue;
            }
            ((Directory)arrayList.get(arrayList.indexOf(directory))).addFile(videoFile);
        }
        if (this.resultCallback != null) {
            this.resultCallback.onResult(arrayList);
        }
    }

    private void onAudioResult(Cursor cursor) {
        ArrayList arrayList = new ArrayList();
        if (cursor.getPosition() != -1) {
            cursor.moveToPosition(-1);
        }
        while (cursor.moveToNext()) {
            AudioFile audioFile = new AudioFile();
            audioFile.setId(cursor.getLong(cursor.getColumnIndexOrThrow("_id")));
            audioFile.setName(cursor.getString(cursor.getColumnIndexOrThrow("title")));
            audioFile.setPath(cursor.getString(cursor.getColumnIndexOrThrow("_data")));
            audioFile.setSize(cursor.getLong(cursor.getColumnIndexOrThrow("_size")));
            audioFile.setDate(cursor.getLong(cursor.getColumnIndexOrThrow("date_added")));
            audioFile.setDuration(cursor.getLong(cursor.getColumnIndexOrThrow("duration")));
            Directory<AudioFile> directory = new Directory<AudioFile>();
            directory.setName(Util.extractFileNameWithSuffix(Util.extractPathWithoutSeparator(audioFile.getPath())));
            directory.setPath(Util.extractPathWithoutSeparator(audioFile.getPath()));
            if (!arrayList.contains(directory)) {
                directory.addFile(audioFile);
                arrayList.add(directory);
                continue;
            }
            ((Directory)arrayList.get(arrayList.indexOf(directory))).addFile(audioFile);
        }
        if (this.resultCallback != null) {
            this.resultCallback.onResult(arrayList);
        }
    }

    private void onFileResult(Cursor cursor) {
        ArrayList arrayList = new ArrayList();
        if (cursor.getPosition() != -1) {
            cursor.moveToPosition(-1);
        }
        while (cursor.moveToNext()) {
            String string2 = cursor.getString(cursor.getColumnIndexOrThrow("_data"));
            if (string2 == null || !this.contains(string2)) continue;
            NormalFile normalFile = new NormalFile();
            normalFile.setId(cursor.getLong(cursor.getColumnIndexOrThrow("_id")));
            normalFile.setName(cursor.getString(cursor.getColumnIndexOrThrow("title")));
            normalFile.setPath(cursor.getString(cursor.getColumnIndexOrThrow("_data")));
            normalFile.setSize(cursor.getLong(cursor.getColumnIndexOrThrow("_size")));
            normalFile.setDate(cursor.getLong(cursor.getColumnIndexOrThrow("date_added")));
            normalFile.setMimeType(cursor.getString(cursor.getColumnIndexOrThrow("mime_type")));
            Directory<NormalFile> directory = new Directory<NormalFile>();
            directory.setName(Util.extractFileNameWithSuffix(Util.extractPathWithoutSeparator(normalFile.getPath())));
            directory.setPath(Util.extractPathWithoutSeparator(normalFile.getPath()));
            if (!arrayList.contains(directory)) {
                directory.addFile(normalFile);
                arrayList.add(directory);
                continue;
            }
            ((Directory)arrayList.get(arrayList.indexOf(directory))).addFile(normalFile);
        }
        if (this.resultCallback != null) {
            this.resultCallback.onResult(arrayList);
        }
    }

    private boolean contains(String string2) {
        String string3 = Util.extractFileNameWithSuffix(string2);
        Pattern pattern = Pattern.compile(this.mSuffixRegex, 2);
        Matcher matcher = pattern.matcher(string3);
        return matcher.matches();
    }

    private String obtainSuffixRegex(String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int j = 0; j < stringArray.length; ++j) {
            if (j == 0) {
                stringBuilder.append(stringArray[j].replace(".", ""));
                continue;
            }
            stringBuilder.append("|\\.");
            stringBuilder.append(stringArray[j].replace(".", ""));
        }
        return ".+(\\." + stringBuilder.toString() + ")$";
    }
}

