/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils.filepicker.adapter;

import android.app.Activity;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Environment;
import android.os.Parcelable;
import android.provider.MediaStore;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.recyclerview.widget.RecyclerView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.TransitionOptions;
import com.bumptech.glide.load.resource.drawable.DrawableTransitionOptions;
import com.bumptech.glide.request.RequestOptions;
import com.hippo.R;
import com.hippo.utils.filepicker.ToastUtil;
import com.hippo.utils.filepicker.Util;
import com.hippo.utils.filepicker.adapter.BaseAdapter;
import com.hippo.utils.filepicker.filter.entity.VideoFile;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;

public class VideoPickAdapter
extends BaseAdapter<VideoFile, VideoPickViewHolder> {
    private boolean isNeedCamera;
    public String mVideoPath;
    private static final int COLUMN_NUMBER = 3;

    public VideoPickAdapter(Context context, boolean bl) {
        this(context, new ArrayList<VideoFile>(), bl);
    }

    public VideoPickAdapter(Context context, ArrayList<VideoFile> arrayList, boolean bl) {
        super(context, arrayList);
        this.isNeedCamera = bl;
    }

    public VideoPickViewHolder onCreateViewHolder(ViewGroup viewGroup, int n) {
        View view = LayoutInflater.from((Context)this.mContext).inflate(R.layout.vw_layout_item_video_pick, viewGroup, false);
        ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
        if (layoutParams != null) {
            WindowManager windowManager = (WindowManager)this.mContext.getSystemService("window");
            int n2 = windowManager.getDefaultDisplay().getWidth();
            layoutParams.height = n2 / 3;
        }
        return new VideoPickViewHolder(view);
    }

    public void onBindViewHolder(final VideoPickViewHolder videoPickViewHolder, int n) {
        if (this.isNeedCamera && n == 0) {
            videoPickViewHolder.mIvCamera.setVisibility(0);
            videoPickViewHolder.mIvThumbnail.setVisibility(4);
            videoPickViewHolder.mCbx.setVisibility(4);
            videoPickViewHolder.mShadow.setVisibility(4);
            videoPickViewHolder.mDurationLayout.setVisibility(4);
            videoPickViewHolder.itemView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    Intent intent = new Intent("android.media.action.VIDEO_CAPTURE");
                    String string2 = new SimpleDateFormat("yyyyMMdd_HHmmss", Locale.ENGLISH).format(new Date());
                    File file = new File(Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DCIM).getAbsolutePath() + "/VID_" + string2 + ".mp4");
                    VideoPickAdapter.this.mVideoPath = file.getAbsolutePath();
                    ContentValues contentValues = new ContentValues(1);
                    contentValues.put("_data", VideoPickAdapter.this.mVideoPath);
                    Uri uri = VideoPickAdapter.this.mContext.getContentResolver().insert(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, contentValues);
                    intent.putExtra("output", (Parcelable)uri);
                    intent.putExtra("android.intent.extra.videoQuality", 1);
                    if (Util.detectIntent(VideoPickAdapter.this.mContext, intent)) {
                        ((Activity)VideoPickAdapter.this.mContext).startActivityForResult(intent, 513);
                    } else {
                        ToastUtil.getInstance(VideoPickAdapter.this.mContext).showToast(VideoPickAdapter.this.mContext.getString(R.string.vw_no_video_app));
                    }
                }
            });
        } else {
            videoPickViewHolder.mIvCamera.setVisibility(4);
            videoPickViewHolder.mIvThumbnail.setVisibility(0);
            videoPickViewHolder.mCbx.setVisibility(8);
            videoPickViewHolder.mDurationLayout.setVisibility(0);
            VideoFile videoFile = this.isNeedCamera ? (VideoFile)this.mList.get(n - 1) : (VideoFile)this.mList.get(n);
            RequestOptions requestOptions = new RequestOptions();
            Glide.with((Context)this.mContext).load(videoFile.getPath()).apply(requestOptions.centerCrop()).transition((TransitionOptions)DrawableTransitionOptions.withCrossFade()).into(videoPickViewHolder.mIvThumbnail);
            if (videoFile.isSelected()) {
                videoPickViewHolder.mCbx.setSelected(true);
                videoPickViewHolder.mShadow.setVisibility(0);
            } else {
                videoPickViewHolder.mCbx.setSelected(false);
                videoPickViewHolder.mShadow.setVisibility(4);
            }
            videoPickViewHolder.mCbx.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    videoPickViewHolder.mShadow.setVisibility(0);
                    videoPickViewHolder.mCbx.setSelected(true);
                    int n = VideoPickAdapter.this.isNeedCamera ? videoPickViewHolder.getAdapterPosition() - 1 : videoPickViewHolder.getAdapterPosition();
                    ((VideoFile)VideoPickAdapter.this.mList.get(n)).setSelected(videoPickViewHolder.mCbx.isSelected());
                    if (VideoPickAdapter.this.mListener != null) {
                        VideoPickAdapter.this.mListener.OnSelectStateChanged(videoPickViewHolder.mCbx.isSelected(), VideoPickAdapter.this.mList.get(n));
                    }
                }
            });
            videoPickViewHolder.itemView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    videoPickViewHolder.mShadow.setVisibility(0);
                    videoPickViewHolder.mCbx.setSelected(true);
                    int n = VideoPickAdapter.this.isNeedCamera ? videoPickViewHolder.getAdapterPosition() - 1 : videoPickViewHolder.getAdapterPosition();
                    ((VideoFile)VideoPickAdapter.this.mList.get(n)).setSelected(videoPickViewHolder.mCbx.isSelected());
                    if (VideoPickAdapter.this.mListener != null) {
                        VideoPickAdapter.this.mListener.OnSelectStateChanged(videoPickViewHolder.mCbx.isSelected(), VideoPickAdapter.this.mList.get(n));
                    }
                }
            });
            videoPickViewHolder.mDuration.setText((CharSequence)Util.getDurationString(videoFile.getDuration()));
        }
    }

    public int getItemCount() {
        return this.isNeedCamera ? this.mList.size() + 1 : this.mList.size();
    }

    class VideoPickViewHolder
    extends RecyclerView.ViewHolder {
        private ImageView mIvCamera;
        private ImageView mIvThumbnail;
        private View mShadow;
        private ImageView mCbx;
        private TextView mDuration;
        private RelativeLayout mDurationLayout;

        public VideoPickViewHolder(View view) {
            super(view);
            this.mIvCamera = (ImageView)view.findViewById(R.id.iv_camera);
            this.mIvThumbnail = (ImageView)view.findViewById(R.id.iv_thumbnail);
            this.mShadow = view.findViewById(R.id.shadow);
            this.mCbx = (ImageView)view.findViewById(R.id.cbx);
            this.mDuration = (TextView)view.findViewById(R.id.txt_duration);
            this.mDurationLayout = (RelativeLayout)view.findViewById(R.id.layout_duration);
        }
    }
}

