/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils.filepicker.adapter;

import android.app.Activity;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Environment;
import android.os.Parcelable;
import android.provider.MediaStore;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.ImageView;
import androidx.recyclerview.widget.RecyclerView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.TransitionOptions;
import com.bumptech.glide.load.resource.drawable.DrawableTransitionOptions;
import com.bumptech.glide.request.RequestOptions;
import com.hippo.R;
import com.hippo.utils.filepicker.ToastUtil;
import com.hippo.utils.filepicker.Util;
import com.hippo.utils.filepicker.adapter.BaseAdapter;
import com.hippo.utils.filepicker.filter.entity.ImageFile;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;

public class ImagePickAdapter
extends BaseAdapter<ImageFile, ImagePickViewHolder> {
    private boolean isNeedImagePager;
    private boolean isNeedCamera;
    private int mMaxNumber;
    private int mCurrentNumber = 0;
    public String mImagePath;
    public Uri mImageUri;
    private static final int COLUMN_NUMBER = 3;

    public ImagePickAdapter(Context context, boolean bl, boolean bl2, int n) {
        this(context, new ArrayList<ImageFile>(), bl, bl2, n);
    }

    public ImagePickAdapter(Context context, ArrayList<ImageFile> arrayList, boolean bl, boolean bl2, int n) {
        super(context, arrayList);
        this.isNeedCamera = bl;
        this.mMaxNumber = n;
        this.isNeedImagePager = bl2;
    }

    public ImagePickViewHolder onCreateViewHolder(ViewGroup viewGroup, int n) {
        View view = LayoutInflater.from((Context)this.mContext).inflate(R.layout.vw_layout_item_image_pick, viewGroup, false);
        ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
        if (layoutParams != null) {
            WindowManager windowManager = (WindowManager)this.mContext.getSystemService("window");
            int n2 = windowManager.getDefaultDisplay().getWidth();
            layoutParams.height = n2 / 3;
        }
        return new ImagePickViewHolder(view);
    }

    public void onBindViewHolder(final ImagePickViewHolder imagePickViewHolder, int n) {
        if (this.isNeedCamera && n == 0) {
            imagePickViewHolder.mIvCamera.setVisibility(0);
            imagePickViewHolder.mIvThumbnail.setVisibility(4);
            imagePickViewHolder.mCbx.setVisibility(4);
            imagePickViewHolder.mShadow.setVisibility(4);
            imagePickViewHolder.itemView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
                    String string2 = new SimpleDateFormat("yyyyMMdd_HHmmss", Locale.ENGLISH).format(new Date());
                    File file = new File(Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DCIM).getAbsolutePath() + "/IMG_" + string2 + ".jpg");
                    ImagePickAdapter.this.mImagePath = file.getAbsolutePath();
                    ContentValues contentValues = new ContentValues(1);
                    contentValues.put("_data", ImagePickAdapter.this.mImagePath);
                    ImagePickAdapter.this.mImageUri = ImagePickAdapter.this.mContext.getContentResolver().insert(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, contentValues);
                    intent.putExtra("output", (Parcelable)ImagePickAdapter.this.mImageUri);
                    if (Util.detectIntent(ImagePickAdapter.this.mContext, intent)) {
                        ((Activity)ImagePickAdapter.this.mContext).startActivityForResult(intent, 257);
                    } else {
                        ToastUtil.getInstance(ImagePickAdapter.this.mContext).showToast(ImagePickAdapter.this.mContext.getString(R.string.vw_no_photo_app));
                    }
                }
            });
        } else {
            imagePickViewHolder.mIvCamera.setVisibility(4);
            imagePickViewHolder.mIvThumbnail.setVisibility(0);
            if (!this.isNeedImagePager) {
                imagePickViewHolder.mCbx.setVisibility(0);
            }
            ImageFile imageFile = this.isNeedCamera ? (ImageFile)this.mList.get(n - 1) : (ImageFile)this.mList.get(n);
            RequestOptions requestOptions = new RequestOptions();
            Glide.with((Context)this.mContext).load(imageFile.getPath()).apply(requestOptions.centerCrop()).transition((TransitionOptions)DrawableTransitionOptions.withCrossFade()).into(imagePickViewHolder.mIvThumbnail);
            if (imageFile.isSelected()) {
                imagePickViewHolder.mCbx.setSelected(true);
                imagePickViewHolder.mShadow.setVisibility(0);
            } else {
                imagePickViewHolder.mCbx.setSelected(false);
                imagePickViewHolder.mShadow.setVisibility(4);
            }
            imagePickViewHolder.mCbx.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    int n;
                    if (!view.isSelected() && ImagePickAdapter.this.isUpToMax()) {
                        ToastUtil.getInstance(ImagePickAdapter.this.mContext).showToast(R.string.vw_up_to_max);
                        return;
                    }
                    int n2 = n = ImagePickAdapter.this.isNeedCamera ? imagePickViewHolder.getAdapterPosition() - 1 : imagePickViewHolder.getAdapterPosition();
                    if (view.isSelected()) {
                        imagePickViewHolder.mShadow.setVisibility(4);
                        imagePickViewHolder.mCbx.setSelected(false);
                        ImagePickAdapter.this.mCurrentNumber--;
                        ((ImageFile)ImagePickAdapter.this.mList.get(n)).setSelected(false);
                    } else {
                        imagePickViewHolder.mShadow.setVisibility(0);
                        imagePickViewHolder.mCbx.setSelected(true);
                        ImagePickAdapter.this.mCurrentNumber++;
                        ((ImageFile)ImagePickAdapter.this.mList.get(n)).setSelected(true);
                    }
                    if (ImagePickAdapter.this.mListener != null) {
                        ImagePickAdapter.this.mListener.OnSelectStateChanged(imagePickViewHolder.mCbx.isSelected(), ImagePickAdapter.this.mList.get(n));
                    }
                }
            });
            if (this.isNeedImagePager) {
                imagePickViewHolder.itemView.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        int n = ImagePickAdapter.this.isNeedCamera ? imagePickViewHolder.getAdapterPosition() - 1 : imagePickViewHolder.getAdapterPosition();
                        imagePickViewHolder.mShadow.setVisibility(0);
                        imagePickViewHolder.mCbx.setSelected(true);
                        ImagePickAdapter.this.mCurrentNumber++;
                        ((ImageFile)ImagePickAdapter.this.mList.get(n)).setSelected(true);
                        if (ImagePickAdapter.this.mListener != null) {
                            ImagePickAdapter.this.mListener.OnSelectStateChanged(imagePickViewHolder.mCbx.isSelected(), ImagePickAdapter.this.mList.get(n));
                        }
                    }
                });
            } else {
                imagePickViewHolder.mIvThumbnail.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        int n;
                        if (!imagePickViewHolder.mCbx.isSelected() && ImagePickAdapter.this.isUpToMax()) {
                            ToastUtil.getInstance(ImagePickAdapter.this.mContext).showToast(R.string.vw_up_to_max);
                            return;
                        }
                        int n2 = n = ImagePickAdapter.this.isNeedCamera ? imagePickViewHolder.getAdapterPosition() - 1 : imagePickViewHolder.getAdapterPosition();
                        if (imagePickViewHolder.mCbx.isSelected()) {
                            imagePickViewHolder.mShadow.setVisibility(4);
                            imagePickViewHolder.mCbx.setSelected(false);
                            ImagePickAdapter.this.mCurrentNumber--;
                            ((ImageFile)ImagePickAdapter.this.mList.get(n)).setSelected(false);
                        } else {
                            imagePickViewHolder.mShadow.setVisibility(0);
                            imagePickViewHolder.mCbx.setSelected(true);
                            ImagePickAdapter.this.mCurrentNumber++;
                            ((ImageFile)ImagePickAdapter.this.mList.get(n)).setSelected(true);
                        }
                        if (ImagePickAdapter.this.mListener != null) {
                            ImagePickAdapter.this.mListener.OnSelectStateChanged(imagePickViewHolder.mCbx.isSelected(), ImagePickAdapter.this.mList.get(n));
                        }
                    }
                });
            }
        }
    }

    public int getItemCount() {
        return this.isNeedCamera ? this.mList.size() + 1 : this.mList.size();
    }

    public boolean isUpToMax() {
        return this.mCurrentNumber >= this.mMaxNumber;
    }

    public void setCurrentNumber(int n) {
        this.mCurrentNumber = n;
    }

    class ImagePickViewHolder
    extends RecyclerView.ViewHolder {
        private ImageView mIvCamera;
        private ImageView mIvThumbnail;
        private View mShadow;
        private ImageView mCbx;

        public ImagePickViewHolder(View view) {
            super(view);
            this.mIvCamera = (ImageView)view.findViewById(R.id.iv_camera);
            this.mIvThumbnail = (ImageView)view.findViewById(R.id.iv_thumbnail);
            this.mShadow = view.findViewById(R.id.shadow);
            this.mCbx = (ImageView)view.findViewById(R.id.cbx);
        }
    }
}

