/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils.filepicker.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.TransitionOptions;
import com.bumptech.glide.load.resource.drawable.DrawableTransitionOptions;
import com.bumptech.glide.request.RequestOptions;
import com.hippo.R;
import com.hippo.utils.filepicker.adapter.BaseAdapter;
import com.hippo.utils.filepicker.filter.entity.Directory;
import com.hippo.utils.filepicker.filter.entity.ImageFile;
import com.hippo.utils.filepicker.filter.entity.VideoFile;
import java.util.ArrayList;

public class ImageDirectoryAdapter
extends BaseAdapter<Directory, ViewHolder> {
    private static final int COLUMN_NUMBER = 2;

    public ImageDirectoryAdapter(Context context) {
        this(context, new ArrayList<Directory>());
    }

    public ImageDirectoryAdapter(Context context, ArrayList<Directory> arrayList) {
        super(context, arrayList);
    }

    public ViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int n) {
        View view = LayoutInflater.from((Context)this.mContext).inflate(R.layout.vw_layout_item_image_pick, viewGroup, false);
        ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
        if (layoutParams != null) {
            WindowManager windowManager = (WindowManager)this.mContext.getSystemService("window");
            int n2 = windowManager.getDefaultDisplay().getWidth();
            layoutParams.height = n2 / 2;
        }
        return new ViewHolder(view);
    }

    public void onBindViewHolder(final @NonNull ViewHolder viewHolder, int n) {
        viewHolder.mIvThumbnail.setVisibility(0);
        viewHolder.folderInfo.setVisibility(0);
        if (((Directory)this.mList.get(n)).getFiles().get(0) instanceof ImageFile) {
            ImageFile imageFile = (ImageFile)((Directory)this.mList.get(n)).getFiles().get(0);
            RequestOptions requestOptions = new RequestOptions();
            Glide.with((Context)this.mContext).load(imageFile.getPath()).apply(requestOptions.centerCrop()).transition((TransitionOptions)DrawableTransitionOptions.withCrossFade()).into(viewHolder.mIvThumbnail);
        } else {
            VideoFile videoFile = (VideoFile)((Directory)this.mList.get(n)).getFiles().get(0);
            RequestOptions requestOptions = new RequestOptions();
            Glide.with((Context)this.mContext).load(videoFile.getPath()).apply(requestOptions.centerCrop()).transition((TransitionOptions)DrawableTransitionOptions.withCrossFade()).into(viewHolder.mIvThumbnail);
        }
        viewHolder.mIvThumbnail.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (ImageDirectoryAdapter.this.mListener != null) {
                    ImageDirectoryAdapter.this.mListener.OnSelectStateChanged(true, ImageDirectoryAdapter.this.mList.get(viewHolder.getAdapterPosition()));
                }
            }
        });
        viewHolder.totalCount.setText((CharSequence)("" + ((Directory)this.mList.get(n)).getFiles().size()));
        viewHolder.directoryName.setText((CharSequence)((Directory)this.mList.get(n)).getName());
    }

    public int getItemCount() {
        return this.mList.size();
    }

    public class ViewHolder
    extends RecyclerView.ViewHolder {
        private ImageView mIvThumbnail;
        private RelativeLayout folderInfo;
        private TextView totalCount;
        private TextView directoryName;

        public ViewHolder(View view) {
            super(view);
            this.mIvThumbnail = (ImageView)view.findViewById(R.id.iv_thumbnail);
            this.folderInfo = (RelativeLayout)view.findViewById(R.id.folder_info);
            this.totalCount = (TextView)view.findViewById(R.id.total_count);
            this.directoryName = (TextView)view.findViewById(R.id.directory_name);
        }
    }
}

