/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils.filepicker.adapter;

import android.content.Context;
import androidx.recyclerview.widget.RecyclerView;
import com.hippo.utils.filepicker.adapter.OnSelectStateListener;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseAdapter<T, VH extends RecyclerView.ViewHolder>
extends RecyclerView.Adapter<VH> {
    protected Context mContext;
    protected ArrayList<T> mList;
    protected OnSelectStateListener<T> mListener;

    public BaseAdapter(Context context, ArrayList<T> arrayList) {
        this.mContext = context;
        this.mList = arrayList;
    }

    public void add(List<T> list) {
        this.mList.addAll(list);
        this.notifyDataSetChanged();
    }

    public void add(T t) {
        this.mList.add(t);
        this.notifyDataSetChanged();
    }

    public void add(int n, T t) {
        this.mList.add(n, t);
        this.notifyDataSetChanged();
    }

    public void refresh(List<T> list) {
        this.mList.clear();
        this.mList.addAll(list);
        this.notifyDataSetChanged();
    }

    public void refresh(T t) {
        this.mList.clear();
        this.mList.add(t);
        this.notifyDataSetChanged();
    }

    public List<T> getDataSet() {
        return this.mList;
    }

    public void setOnSelectStateListener(OnSelectStateListener<T> onSelectStateListener) {
        this.mListener = onSelectStateListener;
    }
}

