/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils.filepicker.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.recyclerview.widget.RecyclerView;
import com.hippo.R;
import com.hippo.utils.filepicker.Util;
import com.hippo.utils.filepicker.adapter.BaseAdapter;
import com.hippo.utils.filepicker.adapter.RecyclerItemClickListener;
import com.hippo.utils.filepicker.filter.entity.AudioFile;
import java.util.ArrayList;

public class AudioPickAdapter
extends BaseAdapter<AudioFile, AudioPickViewHolder>
implements RecyclerItemClickListener {
    private RecyclerView recyclerView;

    public AudioPickAdapter(Context context, RecyclerView recyclerView) {
        this(context, new ArrayList<AudioFile>(), recyclerView);
    }

    public AudioPickAdapter(Context context, ArrayList<AudioFile> arrayList, RecyclerView recyclerView) {
        super(context, arrayList);
        this.recyclerView = recyclerView;
    }

    public AudioPickViewHolder onCreateViewHolder(ViewGroup viewGroup, int n) {
        View view = LayoutInflater.from((Context)this.mContext).inflate(R.layout.vw_layout_item_audio_pick, viewGroup, false);
        return new AudioPickViewHolder(view, this);
    }

    public void onBindViewHolder(AudioPickViewHolder audioPickViewHolder, int n) {
        AudioFile audioFile = (AudioFile)this.mList.get(n);
        audioPickViewHolder.mTvTitle.setText((CharSequence)audioFile.getName());
        audioPickViewHolder.mTvTitle.measure(0, 0);
        if (audioPickViewHolder.mTvTitle.getMeasuredWidth() > Util.getScreenWidth(this.mContext) - Util.dip2px(this.mContext, 120.0f)) {
            audioPickViewHolder.mTvTitle.setLines(2);
        } else {
            audioPickViewHolder.mTvTitle.setLines(1);
        }
        audioPickViewHolder.mCbx.setVisibility(0);
        audioPickViewHolder.mTvDuration.setText((CharSequence)Util.getDurationString(audioFile.getDuration()));
        if (audioFile.isSelected()) {
            audioPickViewHolder.mCbx.setSelected(true);
        } else {
            audioPickViewHolder.mCbx.setSelected(false);
        }
    }

    private void selectItem(AudioPickViewHolder audioPickViewHolder) {
        for (int j = 0; j < this.mList.size(); ++j) {
            if (j == audioPickViewHolder.getAdapterPosition()) {
                if (((AudioFile)this.mList.get(j)).isSelected()) {
                    audioPickViewHolder.mCbx.setSelected(false);
                    continue;
                }
                audioPickViewHolder.mCbx.setSelected(true);
                continue;
            }
            audioPickViewHolder.mCbx.setSelected(false);
        }
        this.notifyDataSetChanged();
        if (this.mListener != null) {
            this.mListener.OnSelectStateChanged(audioPickViewHolder.mCbx.isSelected(), this.mList.get(audioPickViewHolder.getAdapterPosition()));
        }
    }

    public int getItemCount() {
        return this.mList.size();
    }

    @Override
    public void onItemClick(View view, View view2) {
        int n;
        int n2 = this.recyclerView.getChildLayoutPosition(view2);
        if (n2 != -1 && (n = view.getId()) == R.id.main_layout) {
            for (int j = 0; j < this.mList.size(); ++j) {
                if (j == n2) {
                    ((AudioFile)this.mList.get(j)).setSelected(true);
                    if (((AudioFile)this.mList.get(j)).isPlaying()) {
                        ((AudioFile)this.mList.get(j)).setPlaying(false);
                        continue;
                    }
                    ((AudioFile)this.mList.get(j)).setPlaying(true);
                    continue;
                }
                ((AudioFile)this.mList.get(j)).setSelected(false);
                ((AudioFile)this.mList.get(j)).setPlaying(false);
            }
            this.notifyDataSetChanged();
            if (this.mListener != null) {
                this.mListener.OnSelectStateChanged(((AudioFile)this.mList.get(n2)).isPlaying(), this.mList.get(n2));
            }
        }
    }

    @Override
    public void onItemSelected(View view, View view2, boolean bl) {
    }

    class AudioPickViewHolder
    extends RecyclerView.ViewHolder {
        private RelativeLayout mainLayout;
        private TextView mTvTitle;
        private TextView mTvDuration;
        private ImageView mCbx;

        public AudioPickViewHolder(final View view, final RecyclerItemClickListener recyclerItemClickListener) {
            super(view);
            this.mainLayout = (RelativeLayout)view.findViewById(R.id.main_layout);
            this.mTvTitle = (TextView)view.findViewById(R.id.tv_audio_title);
            this.mTvDuration = (TextView)view.findViewById(R.id.tv_duration);
            this.mCbx = (ImageView)view.findViewById(R.id.cbx);
            this.mCbx.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view2) {
                    recyclerItemClickListener.onItemClick((View)AudioPickViewHolder.this.mainLayout, view);
                }
            });
            this.mainLayout.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view2) {
                    recyclerItemClickListener.onItemClick((View)AudioPickViewHolder.this.mainLayout, view);
                }
            });
        }
    }
}

